/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.codeInsight.generation.actions.PresentableCodeInsightActionHandler;
import com.intellij.icons.AllIcons;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.navigation.OCGotoAction;
import com.jetbrains.cidr.lang.navigation.OCGotoActionSync;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCClassPredeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.search.OCFunctionAncestorsQuery;
import com.jetbrains.cidr.lang.search.OCMemberInheritorsSearch;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGotoSuperHandler
implements PresentableCodeInsightActionHandler,
LanguageCodeInsightActionHandler {
    public void update(@NotNull Editor editor, @NotNull PsiFile file, Presentation presentation) {
        presentation.setText(OCBundle.message("action.CIDR.Lang.goto.super.definition", new Object[0]));
        presentation.setDescription("");
    }

    public boolean isValidFor(Editor editor, PsiFile file) {
        return file instanceof OCFile;
    }

    @Nullable
    public static OCGotoAction<PsiElement> getAction(PsiElement element) {
        Collection<? extends OCSymbol> supers = OCGotoSuperHandler.computeSuperSymbols(element);
        if (ContainerUtil.isEmpty(supers)) {
            return null;
        }
        String popupTitle = OCGotoSuperHandler.inferPopupTitle(supers, element.getProject());
        Icon icon = OCGotoSuperHandler.inferIcon(supers);
        return new OCGotoSuperSymbolActionSync(element, popupTitle, icon);
    }

    @Nullable
    private static Collection<? extends OCSymbol> computeSuperSymbols(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return OCGotoSuperHandler.getSuperSymbols(element);
        }
        return (Collection)CidrConcurrentUtilsKt.computeUnderProgress((String)OCBundle.message("navigation.goto.resolving.target", new Object[0]), (Project)element.getProject(), () -> OCGotoSuperHandler.getSuperSymbols(element));
    }

    @NotNull
    private static Icon inferIcon(@NotNull Collection<? extends OCSymbol> supers) {
        return OCGotoSuperHandler.isImplementor(supers) ? AllIcons.Gutter.ImplementingMethod : AllIcons.Gutter.OverridingMethod;
    }

    @NlsContexts.PopupTitle
    @NotNull
    private static String inferPopupTitle(@NotNull Collection<? extends OCSymbol> supers, @NotNull Project project) {
        OCSymbol superSymbol;
        OCSymbol oCSymbol = superSymbol = supers.isEmpty() ? null : supers.iterator().next();
        if (superSymbol instanceof OCMemberSymbol) {
            return OCBundle.message("goto.super.type.name1", superSymbol.getKind().getNameLowercase(), ((OCMemberSymbol)superSymbol).getParent().getNameWithKindLowercase(OCCompilationContext.create(superSymbol, project)));
        }
        if (superSymbol instanceof OCFunctionSymbol) {
            OCSymbolWithQualifiedName parent = ((OCFunctionSymbol)superSymbol).getParent();
            if (parent != null) {
                return OCBundle.message("goto.super.type.name2", parent.getNameWithKindLowercase(OCCompilationContext.create(superSymbol, project)));
            }
        } else {
            return OCBundle.message("goto.super.type.name3", new Object[0]);
        }
        return OCBundle.message("goto.symbol", new Object[0]);
    }

    private static boolean isImplementor(@NotNull Collection<? extends OCSymbol> supers) {
        for (OCSymbol oCSymbol : supers) {
            boolean isCurImplementor;
            if (oCSymbol instanceof OCProtocolSymbol) {
                isCurImplementor = true;
            } else if (oCSymbol instanceof OCMethodSymbol) {
                isCurImplementor = ((OCMethodSymbol)oCSymbol).getParent() instanceof OCProtocolSymbol;
            } else {
                boolean bl = isCurImplementor = oCSymbol instanceof OCFunctionSymbol && oCSymbol.isPredeclaration();
            }
            if (isCurImplementor) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static Collection<? extends OCSymbol> getSuperSymbols(PsiElement element) {
        OCStructSymbol structSymbol;
        if (element instanceof OCClassDeclaration && !(element instanceof OCClassPredeclaration)) {
            return ((OCClassDeclaration)element).getSuperSymbols();
        }
        if (element instanceof OCDeclarator || element instanceof OCMethod) {
            Object symbol2 = ((OCSymbolDeclarator)element).getSymbol();
            Project project = element.getProject();
            if (symbol2 instanceof OCFunctionSymbol && ((OCDeclarator)element).getParameterList() != null && ((OCDeclarator)element).isPossibleStructMember()) {
                return new OCFunctionAncestorsQuery((OCFunctionSymbol)symbol2, false, false, project).findAll();
            }
            if (symbol2 instanceof OCMemberSymbol) {
                CommonProcessors.CollectUniquesProcessor processor = new CommonProcessors.CollectUniquesProcessor();
                OCMemberInheritorsSearch.SearchParameters<OCMemberSymbol> parameters = OCMemberInheritorsSearch.getParameters((OCMemberSymbol)symbol2, project);
                parameters.setIncludeSelfImplementation(false);
                parameters.setInheritors(false);
                parameters.setAncestors(true);
                if (((OCMemberSymbol)symbol2).getParent() instanceof OCImplementationSymbol) {
                    parameters.setImplementationsThenInterfaces(true);
                } else {
                    parameters.setInterfacesThenImplementations(true);
                }
                OCMemberInheritorsSearch.search(parameters).forEach((Processor)processor);
                return processor.getResults();
            }
        } else if (element instanceof OCStruct && (structSymbol = (OCStructSymbol)((OCStruct)element).getSymbol()) != null) {
            ArrayList supers = new ArrayList();
            structSymbol.processBaseClasses(OCResolveContext.forPsi(element), (symbol, visibility) -> {
                supers.add(symbol);
                return true;
            });
            return supers;
        }
        return null;
    }

    @Nullable
    public static PsiElement getContext(@Nullable PsiElement element) {
        PsiElement context = PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCFunctionDeclaration.class, OCMethod.class, OCClassDeclaration.class, OCStruct.class});
        if (context instanceof OCFunctionDeclaration) {
            context = ((OCFunctionDeclaration)context).getDeclarator();
        }
        return context;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        PsiElement context = OCGotoSuperHandler.getContext(element);
        OCGotoAction<PsiElement> action = OCGotoSuperHandler.getAction(context);
        if (action != null) {
            action.navigate(null, editor);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static class OCGotoSuperSymbolActionSync
    extends OCGotoActionSync<PsiElement> {
        @NotNull
        private @NlsContexts.PopupTitle String myPopupTitle;

        OCGotoSuperSymbolActionSync(@NotNull PsiElement element, @NotNull @NlsContexts.PopupTitle String popupTitle, @NotNull Icon icon) {
            super(element, icon);
            this.myPopupTitle = popupTitle;
        }

        @Override
        @NotNull
        public String getPopupTitle() {
            return this.myPopupTitle;
        }

        @Override
        @NotNull
        public String getTooltip() {
            return OCBundle.message("navigation.goto.resolving.target", new Object[0]);
        }

        @Override
        @NotNull
        protected Collection<? extends OCSymbol> evaluateTargets(@NotNull PsiElement source) {
            Collection<? extends OCSymbol> superSymbols = OCGotoSuperHandler.computeSuperSymbols(source);
            if (superSymbols == null) {
                return Collections.emptyList();
            }
            this.setIcon(OCGotoSuperHandler.inferIcon(superSymbols));
            this.myPopupTitle = OCGotoSuperHandler.inferPopupTitle(superSymbols, source.getProject());
            return superSymbols;
        }
    }
}

