/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.navigation.GotoImplementationHandler;
import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.codeInsight.navigation.ImplementationSearcher;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.daemon.clang.ExternalResolveUtils;
import java.util.Collections;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGotoImplementationHandler
extends GotoImplementationHandler {
    @Nullable
    public GotoTargetHandler.GotoData getSourceAndTargetElements(@NotNull Editor editor, PsiFile file) {
        Project project = file.getProject();
        int offsetFromGutter = OCGotoImplementationHandler.tryGetNavigationSourceOffsetFromGutterIcon((Editor)editor, (String)"GotoImplementation");
        if (ExternalResolveUtils.canDoExternalResolveRelaxed(project)) {
            int offset = editor.getCaretModel().getOffset();
            Callable<GotoTargetHandler.GotoData> slowResolver = () -> this.getSourceAndTargetElementsSlow(editor, offsetFromGutter);
            Callable<GotoTargetHandler.GotoData> fastResolver = () -> OCGotoImplementationHandler.getSourceAndTargetElementsFast(file, offset);
            return (GotoTargetHandler.GotoData)ActionUtil.underModalProgress((Project)project, (String)CodeInsightBundle.message((String)"progress.title.resolving.reference", (Object[])new Object[0]), () -> (GotoTargetHandler.GotoData)ExternalResolveUtils.findInParallel(6000L, slowResolver, fastResolver));
        }
        return (GotoTargetHandler.GotoData)ActionUtil.underModalProgress((Project)project, (String)CodeInsightBundle.message((String)"progress.title.resolving.reference", (Object[])new Object[0]), () -> this.getSourceAndTargetElementsSlow(editor, offsetFromGutter));
    }

    @Nullable
    private static GotoTargetHandler.GotoData getSourceAndTargetElementsFast(@NotNull PsiFile file, int offset) {
        PsiElement[] elements = ExternalResolveUtils.resolveElements(file, offset);
        if (elements != null && elements.length > 0) {
            return new GotoTargetHandler.GotoData(elements[0], elements, Collections.emptyList());
        }
        return null;
    }

    @Nullable
    public GotoTargetHandler.GotoData getSourceAndTargetElementsSlow(@NotNull Editor editor, int maybeOffsetFromGutters) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement source = TargetElementUtil.getInstance().findTargetElement(editor, ImplementationSearcher.getFlags(), offset);
        if (source == null && (offset = maybeOffsetFromGutters) >= 0) {
            source = TargetElementUtil.getInstance().findTargetElement(editor, ImplementationSearcher.getFlags(), offset);
        }
        if (source == null) {
            return null;
        }
        return this.createDataForSource(editor, offset, source);
    }

    protected PsiElement @Nullable [] findTargets(@NotNull Editor editor, int offset, @NotNull PsiElement source) {
        PsiReference reference = TargetElementUtil.findReference((Editor)editor, (int)offset);
        return new FirstImplementationsSearcherEx(reference).searchImplementations(editor, source, offset);
    }

    private static class FirstImplementationsSearcherEx
    extends ImplementationSearcher {
        @Nullable
        private final PsiReference myRef;

        FirstImplementationsSearcherEx(@Nullable PsiReference reference) {
            this.myRef = reference;
        }

        protected PsiElement @Nullable [] searchDefinitions(final PsiElement element, Editor editor) {
            PsiElement[] psiElementArray;
            final TargetElementUtil instance = TargetElementUtil.getInstance();
            CommonProcessors.FindProcessor<PsiElement> processor = new CommonProcessors.FindProcessor<PsiElement>(){

                protected boolean accept(PsiElement o) {
                    ProgressManager.checkCanceled();
                    if (myRef != null && !myRef.getElement().isValid()) {
                        return false;
                    }
                    return instance.acceptImplementationForReference(myRef, element);
                }
            };
            this.search(element, editor).forEach((Processor)processor);
            PsiElement foundElement = (PsiElement)processor.getFoundValue();
            if (foundElement != null) {
                PsiElement[] psiElementArray2 = new PsiElement[1];
                psiElementArray = psiElementArray2;
                psiElementArray2[0] = foundElement;
            } else {
                psiElementArray = PsiElement.EMPTY_ARRAY;
            }
            return psiElementArray;
        }
    }
}

