/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap.serialization;

import com.jetbrains.cidr.lang.modulemap.serialization.ModuleInfo;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapSerializationPack;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleReference;
import com.jetbrains.cidr.lang.modulemap.serialization.SerializedModuleMap;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapSymbol;
import com.jetbrains.cidr.lang.qualifiedName.QualifiedName;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/serialization/SerializedModuleMapPrinter;", "", "out", "Ljava/io/PrintWriter;", "(Ljava/io/PrintWriter;)V", "writeModule", "", "module", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapSymbol;", "prefix", "", "writeModuleInfo", "moduleInfo", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleInfo;", "writeModuleMapString", "map", "Lcom/jetbrains/cidr/lang/modulemap/serialization/SerializedModuleMap;", "writeSerializedPack", "pack", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationPack$ProjectPack;", "intellij.c"})
public final class SerializedModuleMapPrinter {
    private final PrintWriter out;

    public final void writeSerializedPack(@NotNull ModuleMapSerializationPack.ProjectPack pack) {
        SerializedModuleMap globalMap = pack.getSerializationData().getGlobalMap();
        if (globalMap != null) {
            this.out.println("Global map:");
            this.writeModuleMapString(globalMap);
        }
        for (SerializedModuleMap projectMap : pack.getSerializationData().getProjectMaps()) {
            this.out.println("Project map:");
            this.writeModuleMapString(projectMap);
        }
        this.out.flush();
    }

    private final void writeModuleMapString(SerializedModuleMap map2) {
        Iterable $this$sortedBy$iv = map2.getModuleMap().getModules();
        boolean $i$f$sortedBy = false;
        List modules2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ModuleMapSymbol it = (ModuleMapSymbol)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (ModuleMapSymbol)b;
                Comparable comparable2 = comparable;
                bl = false;
                String string = it.getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        });
        for (ModuleMapSymbol module : modules2) {
            this.writeModule(module, "  ");
        }
        Iterable $this$sortedBy$iv2 = map2.getModuleInfos();
        boolean $i$f$sortedBy2 = false;
        for (ModuleInfo moduleInfo : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ModuleInfo it = (ModuleInfo)a;
                boolean bl = false;
                Comparable comparable = it.getModule().getModuleName();
                it = (ModuleInfo)b;
                Comparable comparable2 = comparable;
                bl = false;
                QualifiedName qualifiedName = it.getModule().getModuleName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)qualifiedName);
            }
        })) {
            this.writeModuleInfo(moduleInfo, "  ");
        }
        this.out.println();
    }

    private final void writeModuleInfo(ModuleInfo moduleInfo, String prefix) {
        this.out.print(prefix);
        this.out.println(moduleInfo.getModule().getModuleName());
        Iterable $this$sortedBy$iv = moduleInfo.getDependencies();
        boolean $i$f$sortedBy = false;
        for (ModuleReference dependency : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ModuleReference it = (ModuleReference)a;
                boolean bl = false;
                Comparable comparable = it.getQualifiedName();
                it = (ModuleReference)b;
                Comparable comparable2 = comparable;
                bl = false;
                QualifiedName qualifiedName = it.getQualifiedName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)qualifiedName);
            }
        })) {
            this.out.print(prefix);
            this.out.print("  ");
            this.out.println(dependency.getQualifiedName());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void writeModule(ModuleMapSymbol module, String prefix) {
        void $this$buildString;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder;
        PrintWriter printWriter = this.out;
        boolean bl = false;
        $this$buildString.append(prefix);
        $this$buildString.append(module.getName());
        if (module.isExplicit()) {
            $this$buildString.append(" [");
            $this$buildString.append("external");
            $this$buildString.append("]");
        }
        Unit unit = Unit.INSTANCE;
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        printWriter.println(string);
        Iterable $this$sortedBy$iv = module.getSubModules().values();
        boolean $i$f$sortedBy = false;
        for (ModuleMapSymbol subModule : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ModuleMapSymbol it = (ModuleMapSymbol)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (ModuleMapSymbol)b;
                Comparable comparable2 = comparable;
                bl = false;
                String string = it.getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        })) {
            this.writeModule(subModule, prefix + "  ");
        }
    }

    public SerializedModuleMapPrinter(@NotNull PrintWriter out) {
        this.out = out;
    }
}

