/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap.serialization;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.jetbrains.cidr.lang.modulemap.AllowedModules;
import com.jetbrains.cidr.lang.modulemap.ModuleMapLog;
import com.jetbrains.cidr.lang.modulemap.ModuleMapRoot;
import com.jetbrains.cidr.lang.modulemap.ModuleMapUtil;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapPlatformType;
import com.jetbrains.cidr.lang.modulemap.serialization.DependencyInitializer;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapAssembledPack;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapBundledSerializationData;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapConcurrentSerializationService;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapDeserializationSession;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapInitialDeserializationPack;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapPlatformHolder;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapProjectSerializedData;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapReference;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapSerializationInfo;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapSerializationService;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleSeriailzationUtilKt;
import com.jetbrains.cidr.lang.modulemap.serialization.PackAssembler;
import com.jetbrains.cidr.lang.modulemap.serialization.RefToMapIndex;
import com.jetbrains.cidr.lang.modulemap.serialization.RootsWithConfigurations;
import com.jetbrains.cidr.lang.modulemap.serialization.SerializedModuleMap;
import com.jetbrains.cidr.lang.modulemap.serialization.ValidPackCollector;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMap;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapCache;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapPack;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapPackWithRoot;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapSignature;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapSymbol;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u000fJ,\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u000fH\u0002J \u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u000fH\u0002J\u0016\u0010\u001d\u001a\u00020\u00162\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\fH\u0002J&\u0010 \u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\"\u001a\u00020\u000fH\u0002J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001b0\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010$\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapDeserializationSession;", "", "project", "Lcom/intellij/openapi/project/Project;", "serializationService", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationService;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationService;)V", "buildModuleToSignatureIndex", "", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapSymbol;", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapSignature;", "packs", "", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapAssembledPack;", "deserializeAllModuleMaps", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "roots", "Lcom/jetbrains/cidr/lang/modulemap/serialization/RootsWithConfigurations;", "deserializeBundledModuleMapsOnly", "deserializeForAllowedModuleRebuild", "", "deserializeModuleMaps", "bundledOnly", "deserializeRawPacks", "preparedPacks", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapInitialDeserializationPack;", "doDeserializePacks", "flushValidPacksToModuleMapCache", "validPacks", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapPackWithRoot;", "initializeDependencies", "deserializedPacks", "ignoreSetupErrors", "prepareInitialPacks", "reportDeserializationFailure", "intellij.c"})
public final class ModuleMapDeserializationSession {
    private final Project project;
    private final ModuleMapSerializationService serializationService;

    public final void deserializeModuleMaps(@NotNull ProgressIndicator indicator, @NotNull RootsWithConfigurations roots2, boolean bundledOnly) {
        if (AllowedModules.Companion.isRebuildRequired()) {
            this.deserializeForAllowedModuleRebuild(indicator, roots2);
            return;
        }
        if (!bundledOnly) {
            if (this.deserializeAllModuleMaps(indicator, roots2)) {
                return;
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw (Throwable)((Object)new AssertionError((Object)"Deserialization failed"));
            }
            ModuleMapLog.LOG.error("Module map deserialization failed");
        }
        if (this.deserializeBundledModuleMapsOnly(indicator, roots2)) {
            return;
        }
        this.reportDeserializationFailure();
    }

    private final void deserializeForAllowedModuleRebuild(ProgressIndicator indicator, RootsWithConfigurations roots2) {
        if (!this.deserializeBundledModuleMapsOnly(indicator, roots2)) {
            this.reportDeserializationFailure();
        }
    }

    private final void reportDeserializationFailure() {
        ModuleMapLog.LOG.error("Bundled module map deserialization failed");
    }

    private final boolean deserializeAllModuleMaps(ProgressIndicator indicator, RootsWithConfigurations roots2) {
        return this.doDeserializePacks(indicator, roots2, false);
    }

    private final boolean deserializeBundledModuleMapsOnly(ProgressIndicator indicator, RootsWithConfigurations roots2) {
        ModuleMapCache.Companion.getInstance(this.project).reset();
        ModuleMapManager.Companion.getInstance(this.project).clearCache();
        return this.doDeserializePacks(indicator, roots2, true);
    }

    private final boolean doDeserializePacks(ProgressIndicator indicator, RootsWithConfigurations roots2, boolean bundledOnly) {
        List<ModuleMapInitialDeserializationPack> preparedPacks2 = this.prepareInitialPacks(roots2);
        ModuleSeriailzationUtilKt.checkNoDuplicatingStorages((Sequence<ModuleMapSerializationInfo>)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)preparedPacks2), (Function1)doDeserializePacks.1.INSTANCE));
        List<ModuleMapAssembledPack> packs = this.deserializeRawPacks(preparedPacks2, indicator, bundledOnly);
        List<ModuleMapPackWithRoot> list = this.initializeDependencies(packs, bundledOnly);
        if (list == null) {
            return false;
        }
        List<ModuleMapPackWithRoot> initializedPacks = list;
        this.flushValidPacksToModuleMapCache(initializedPacks);
        if (ModuleMapLog.LOG.isTraceEnabled()) {
            boolean $i$f$runReadAction = false;
            ApplicationManager.getApplication().runReadAction(new Computable(initializedPacks){
                final /* synthetic */ List $initializedPacks$inlined;
                {
                    this.$initializedPacks$inlined = list;
                }

                public final T compute() {
                    boolean bl = false;
                    for (ModuleMapPackWithRoot pack : this.$initializedPacks$inlined) {
                        ModuleMapLog.LOG.trace("Applied module maps: " + pack.getModuleMapRoot());
                    }
                    return (T)Unit.INSTANCE;
                }
            });
        }
        ModuleMapLog.LOG.info("Loaded " + ModuleSeriailzationUtilKt.flatSize((Collection<ModuleMapPackWithRoot>)initializedPacks) + " module maps in " + initializedPacks.size() + " packs for " + roots2.getSize() + " search roots");
        return true;
    }

    private final List<ModuleMapAssembledPack> deserializeRawPacks(List<ModuleMapInitialDeserializationPack> preparedPacks2, ProgressIndicator indicator, boolean bundledOnly) {
        boolean shouldDeserializeNonBundledPacks = ModuleMapCache.Companion.shouldReloadCache();
        ConcurrentLinkedDeque concurrentDeque = new ConcurrentLinkedDeque();
        Function3<ModuleMapInitialDeserializationPack, ModuleMapBundledSerializationData, ModuleMapProjectSerializedData, Unit> $fun$assemblePack$1 = new Function3<ModuleMapInitialDeserializationPack, ModuleMapBundledSerializationData, ModuleMapProjectSerializedData, Unit>(bundledOnly, indicator, shouldDeserializeNonBundledPacks, concurrentDeque){
            final /* synthetic */ boolean $bundledOnly;
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ boolean $shouldDeserializeNonBundledPacks;
            final /* synthetic */ ConcurrentLinkedDeque $concurrentDeque;

            public final void invoke(@NotNull ModuleMapInitialDeserializationPack pack, @Nullable ModuleMapBundledSerializationData bundledData, @Nullable ModuleMapProjectSerializedData projectData) {
                ModuleMapProjectSerializedData moduleMapProjectSerializedData;
                ModuleMapProjectSerializedData moduleMapProjectSerializedData2 = moduleMapProjectSerializedData = projectData;
                ModuleMapBundledSerializationData moduleMapBundledSerializationData = bundledData;
                ModuleMapInitialDeserializationPack moduleMapInitialDeserializationPack = pack;
                PackAssembler packAssembler = PackAssembler.INSTANCE;
                boolean bl = false;
                boolean bl2 = this.$bundledOnly;
                ModuleMapAssembledPack moduleMapAssembledPack = packAssembler.assemblePack(moduleMapInitialDeserializationPack, moduleMapBundledSerializationData, !bl2 ? moduleMapProjectSerializedData : null);
                if (moduleMapAssembledPack == null) {
                    return;
                }
                ModuleMapAssembledPack assembledPack = moduleMapAssembledPack;
                this.$indicator.setText2(assembledPack.getModuleMapRoot().getRoot().getName());
                if (!this.$shouldDeserializeNonBundledPacks && assembledPack.getData().getBundledMaps().isEmpty()) {
                    return;
                }
                this.$concurrentDeque.add(assembledPack);
            }
            {
                this.$bundledOnly = bl;
                this.$indicator = progressIndicator;
                this.$shouldDeserializeNonBundledPacks = bl2;
                this.$concurrentDeque = concurrentLinkedDeque;
                super(3);
            }
        };
        ModuleMapConcurrentSerializationService.Companion.getInstance().deserialize(preparedPacks2, indicator, this.serializationService, (Function3<? super ModuleMapInitialDeserializationPack, ? super ModuleMapBundledSerializationData, ? super ModuleMapProjectSerializedData, Unit>)((Function3)new Function3<ModuleMapInitialDeserializationPack, ModuleMapBundledSerializationData, ModuleMapProjectSerializedData, Unit>($fun$assemblePack$1){
            final /* synthetic */ deserializeRawPacks.1 $assemblePack$1;

            public final void invoke(@NotNull ModuleMapInitialDeserializationPack p1, @Nullable ModuleMapBundledSerializationData p2, @Nullable ModuleMapProjectSerializedData p3) {
                this.$assemblePack$1.invoke(p1, p2, p3);
            }
            {
                this.$assemblePack$1 = var1_1;
                super(3, null, "assemblePack", "invoke(Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapInitialDeserializationPack;Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapBundledSerializationData;Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapProjectSerializedData;)V", 0);
            }
        }));
        List assembledPacks = CollectionsKt.toList((Iterable)concurrentDeque);
        if (ModuleMapLog.LOG.isTraceEnabled()) {
            boolean $i$f$runReadAction = false;
            ApplicationManager.getApplication().runReadAction(new Computable(assembledPacks){
                final /* synthetic */ List $assembledPacks$inlined;
                {
                    this.$assembledPacks$inlined = list;
                }

                public final T compute() {
                    boolean bl = false;
                    for (ModuleMapAssembledPack pack : this.$assembledPacks$inlined) {
                        ModuleMapLog.LOG.trace("Deserialized module maps: " + pack.getModuleMapRoot());
                    }
                    return (T)Unit.INSTANCE;
                }
            });
        }
        return assembledPacks;
    }

    private final List<ModuleMapInitialDeserializationPack> prepareInitialPacks(RootsWithConfigurations roots2) {
        ModuleMapPlatformHolder platformHolder = new ModuleMapPlatformHolder();
        List preparedPacks2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)roots2.getEntries()), (Function1)prepareInitialPacks.preparedPacks.1.INSTANCE), (Function1)((Function1)new Function1<Map.Entry<? extends ModuleMapRoot, ? extends List<? extends OCResolveConfiguration>>, ModuleMapInitialDeserializationPack>(this, platformHolder){
            final /* synthetic */ ModuleMapDeserializationSession this$0;
            final /* synthetic */ ModuleMapPlatformHolder $platformHolder;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ModuleMapInitialDeserializationPack invoke(@NotNull Map.Entry<? extends ModuleMapRoot, ? extends List<? extends OCResolveConfiguration>> $dstr$moduleMapRoot$configurations) {
                void moduleMapRoot;
                Map.Entry<? extends ModuleMapRoot, ? extends List<? extends OCResolveConfiguration>> entry = $dstr$moduleMapRoot$configurations;
                ModuleMapRoot moduleMapRoot2 = entry.getKey();
                entry = $dstr$moduleMapRoot$configurations;
                List<? extends OCResolveConfiguration> configurations = entry.getValue();
                ModuleMapSerializationInfo info = ModuleMapDeserializationSession.access$getSerializationService$p(this.this$0).createSerializationInfo((ModuleMapRoot)moduleMapRoot);
                Set<ModuleMapPlatformType> platforms = this.$platformHolder.getPlatforms(configurations);
                return new ModuleMapInitialDeserializationPack(platforms, info);
            }
            {
                this.this$0 = moduleMapDeserializationSession;
                this.$platformHolder = moduleMapPlatformHolder;
                super(1);
            }
        })), (Function1)prepareInitialPacks.preparedPacks.3.INSTANCE));
        return preparedPacks2;
    }

    private final List<ModuleMapPackWithRoot> initializeDependencies(List<ModuleMapAssembledPack> deserializedPacks, boolean ignoreSetupErrors) {
        Map<ModuleMapReference, SerializedModuleMap> refToSerializedModuleMap = new RefToMapIndex(deserializedPacks).buildRefToMapIndex();
        List<ModuleMapAssembledPack> validPacks = new ValidPackCollector(deserializedPacks, refToSerializedModuleMap, ignoreSetupErrors).collectValidPacks();
        Map<ModuleMapSymbol, ModuleMapSignature> moduleToSignature = this.buildModuleToSignatureIndex(validPacks);
        DependencyInitializer dependencyInitializer = new DependencyInitializer(validPacks, refToSerializedModuleMap, moduleToSignature, ignoreSetupErrors, this.project);
        return dependencyInitializer.setupModuleDependencies();
    }

    private final Map<ModuleMapSymbol, ModuleMapSignature> buildModuleToSignatureIndex(List<ModuleMapAssembledPack> packs) {
        Map result = new LinkedHashMap();
        for (ModuleMapAssembledPack pack : packs) {
            for (SerializedModuleMap serializedModuleMap : pack.getData().getAllMaps()) {
                ModuleMap moduleMap = serializedModuleMap.getModuleMap();
                for (ModuleMapSymbol module : ModuleMapUtil.allModules$default(moduleMap, null, 1, null)) {
                    result.put(module, moduleMap.getSignature());
                }
            }
        }
        return result;
    }

    private final void flushValidPacksToModuleMapCache(List<ModuleMapPackWithRoot> validPacks) {
        ModuleMapCache moduleMapCache = ModuleMapCache.Companion.getInstance(this.project);
        for (ModuleMapPackWithRoot pack : validPacks) {
            ModuleMapPack moduleMapPack = pack.getModuleMapPack();
            moduleMapPack.compact();
            moduleMapCache.cache(pack.getModuleMapRoot(), moduleMapPack);
        }
    }

    public ModuleMapDeserializationSession(@NotNull Project project, @NotNull ModuleMapSerializationService serializationService) {
        this.project = project;
        this.serializationService = serializationService;
    }

    public static final /* synthetic */ ModuleMapSerializationService access$getSerializationService$p(ModuleMapDeserializationSession $this) {
        return $this.serializationService;
    }
}

