/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap.serialization;

import com.google.common.collect.Iterables;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.CustomHeaderProvider;
import com.jetbrains.cidr.lang.modulemap.ModuleMapLog;
import com.jetbrains.cidr.lang.modulemap.ModuleMapRoot;
import com.jetbrains.cidr.lang.modulemap.ModuleMapUtil;
import com.jetbrains.cidr.lang.modulemap.resolve.manager.ModuleMapHeaderCache;
import com.jetbrains.cidr.lang.modulemap.serialization.DependencyInitializerKt;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleInfo;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapAssembledPack;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapReference;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleReference;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleSeriailzationUtilKt;
import com.jetbrains.cidr.lang.modulemap.serialization.SerializedModuleMap;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapPackWithRoot;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapSignature;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapSymbol;
import com.jetbrains.cidr.lang.modulemap.symbols.impl.ModuleMapSymbolImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BK\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0006\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J \u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0002J \u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\rH\u0002J.\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u001e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0002J\u001f\u0010\u001f\u001a\t\u0018\u00010\u0019\u00a2\u0006\u0002\b 2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020$2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010&\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010\u0003R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/jetbrains/cidr/lang/modulemap/serialization/DependencyInitializer;", "", "validPacks", "", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapAssembledPack;", "refToSerializedModuleMap", "", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapReference;", "Lcom/jetbrains/cidr/lang/modulemap/serialization/SerializedModuleMap;", "moduleToSignature", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapSymbol;", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapSignature;", "ignoreSetupErrors", "", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/util/List;Ljava/util/Map;Ljava/util/Map;ZLcom/intellij/openapi/project/Project;)V", "applyDependencies", "info", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleInfo;", "moduleMapRoot", "Lcom/jetbrains/cidr/lang/modulemap/ModuleMapRoot;", "forceIgnoreErrors", "applyHeaders", "rootBaseDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "applyReference", "reference", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleReference;", "dependencies", "", "findVirtualFile", "Lorg/jetbrains/annotations/Nullable;", "path", "", "reportMissingFile", "", "resolveReference", "setupModuleDependencies", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapPackWithRoot;", "intellij.c"})
public final class DependencyInitializer {
    private final List<ModuleMapAssembledPack> validPacks;
    private final Map<ModuleMapReference, SerializedModuleMap> refToSerializedModuleMap;
    private final Map<ModuleMapSymbol, ModuleMapSignature> moduleToSignature;
    private final boolean ignoreSetupErrors;
    private final Project project;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<ModuleMapPackWithRoot> setupModuleDependencies() {
        void $this$mapTo$iv$iv;
        Iterable rootBaseDirectory;
        for (ModuleMapAssembledPack pack : this.validPacks) {
            rootBaseDirectory = ModuleSeriailzationUtilKt.getRootBaseDirectory(pack.getModuleMapRoot().getRoot());
            if (rootBaseDirectory == null) {
                ModuleMapLog.LOG.error("Root Base Directory is null for valid pack " + pack.getModuleMapRoot());
                return null;
            }
            for (SerializedModuleMap serializedModuleMap : pack.getData().getAllMaps()) {
                boolean forceIgnoreErrors = pack.isBundledModuleMap(serializedModuleMap);
                for (ModuleInfo info : serializedModuleMap.getModuleInfos()) {
                    boolean result = this.applyHeaders((VirtualFile)rootBaseDirectory, info, forceIgnoreErrors) && this.applyDependencies(info, pack.getModuleMapRoot(), forceIgnoreErrors);
                    if (result) continue;
                    return null;
                }
            }
        }
        Iterable $this$map$iv = this.validPacks;
        boolean $i$f$map = false;
        rootBaseDirectory = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ModuleMapAssembledPack moduleMapAssembledPack = (ModuleMapAssembledPack)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ModuleMapPackWithRoot moduleMapPackWithRoot = new ModuleMapPackWithRoot(it.getModuleMapRoot(), DependencyInitializerKt.access$toModuleMapPack((ModuleMapAssembledPack)it));
            collection.add(moduleMapPackWithRoot);
        }
        return (List)destination$iv$iv;
    }

    private final boolean applyDependencies(ModuleInfo info, ModuleMapRoot moduleMapRoot, boolean forceIgnoreErrors) {
        List<ModuleReference> serializedDependencies = info.getDependencies();
        ArrayList dependencies2 = new ArrayList(serializedDependencies.size());
        for (ModuleReference reference : serializedDependencies) {
            if (this.applyReference(reference, dependencies2, moduleMapRoot, forceIgnoreErrors)) continue;
            return false;
        }
        ModuleMapSymbol moduleMapSymbol = info.getModule();
        if (moduleMapSymbol == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.cidr.lang.modulemap.symbols.impl.ModuleMapSymbolImpl");
        }
        ((ModuleMapSymbolImpl)moduleMapSymbol).setDependencies(CollectionsKt.toList((Iterable)dependencies2));
        return true;
    }

    private final boolean applyReference(ModuleReference reference, List<ModuleMapSymbol> dependencies2, ModuleMapRoot moduleMapRoot, boolean forceIgnoreErrors) {
        boolean doIgnore;
        ModuleMapSymbol dependencyModule = this.resolveReference(reference);
        if (dependencyModule != null) {
            Collection collection = dependencies2;
            collection.add(dependencyModule);
            return true;
        }
        boolean bl = doIgnore = this.ignoreSetupErrors || forceIgnoreErrors;
        if (doIgnore && StringsKt.endsWith$default((String)reference.getModuleMapReference().getModuleMapRootReference().getUid-knzGXSs(), (String)"include/c++/v1:false", (boolean)false, (int)2, null)) {
            return true;
        }
        ModuleMapLog.LOG.error("broken reference " + reference + " for " + ModuleMapUtil.getRootText(moduleMapRoot));
        return doIgnore;
    }

    private final ModuleMapSymbol resolveReference(ModuleReference reference) {
        SerializedModuleMap serializedModuleMap = this.refToSerializedModuleMap.get(reference.getModuleMapReference());
        if (serializedModuleMap == null) {
            return null;
        }
        SerializedModuleMap serializedModuleMap2 = serializedModuleMap;
        return serializedModuleMap2.getModuleMap().getModule(reference.getQualifiedName());
    }

    /*
     * WARNING - void declaration
     */
    private final boolean applyHeaders(VirtualFile rootBaseDirectory, ModuleInfo info, boolean forceIgnoreErrors) {
        ModuleMapSymbol module;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = info.getHeaders();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile virtualFile;
            VirtualFile header;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String path = (String)element$iv$iv;
            boolean bl2 = false;
            VirtualFile $this$alsoIfNull$iv = this.findVirtualFile(rootBaseDirectory, path);
            boolean $i$f$alsoIfNull = false;
            if ($this$alsoIfNull$iv == null) {
                boolean bl3 = false;
                this.reportMissingFile(path, rootBaseDirectory);
                if (!this.ignoreSetupErrors && !forceIgnoreErrors) {
                    return false;
                }
            }
            if ((header = $this$alsoIfNull$iv) == null) continue;
            VirtualFile it$iv$iv = virtualFile;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List headers = (List)destination$iv$iv;
        ModuleMapSymbol moduleMapSymbol = module = info.getModule();
        if (moduleMapSymbol == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.cidr.lang.modulemap.symbols.impl.ModuleMapSymbolImpl");
        }
        ((ModuleMapSymbolImpl)moduleMapSymbol).setIncludeHeaders(headers);
        ModuleMapSignature signature2 = (ModuleMapSignature)MapsKt.getValue(this.moduleToSignature, (Object)module);
        List<VirtualFile> internalHeaders = module.getInternalHeaders();
        ModuleMapHeaderCache.Companion.getInstance(this.project).addHeaders(module, signature2, Iterables.concat((Iterable)headers, (Iterable)internalHeaders));
        return true;
    }

    private final void reportMissingFile(String path, VirtualFile rootBaseDirectory) {
        String error = "Missing file " + path + " in base directory: " + rootBaseDirectory.getCanonicalPath();
        if (this.ignoreSetupErrors) {
            ModuleMapLog.LOG.warn(error);
        } else {
            ModuleMapLog.LOG.error(error);
        }
    }

    private final VirtualFile findVirtualFile(VirtualFile rootBaseDirectory, String path) {
        VirtualFile virtualFile;
        VirtualFile virtualFile2 = rootBaseDirectory.findFileByRelativePath(path);
        if (virtualFile2 == null) {
            virtualFile2 = virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
        }
        if (virtualFile2 == null) {
            virtualFile = CustomHeaderProvider.getCustomHeaderFile(path, this.project, rootBaseDirectory);
        }
        return virtualFile;
    }

    public DependencyInitializer(@NotNull List<ModuleMapAssembledPack> validPacks, @NotNull Map<ModuleMapReference, SerializedModuleMap> refToSerializedModuleMap, @NotNull Map<ModuleMapSymbol, ? extends ModuleMapSignature> moduleToSignature, boolean ignoreSetupErrors, @NotNull Project project) {
        this.validPacks = validPacks;
        this.refToSerializedModuleMap = refToSerializedModuleMap;
        this.moduleToSignature = moduleToSignature;
        this.ignoreSetupErrors = ignoreSetupErrors;
        this.project = project;
    }
}

