/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap.resolve.manager;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.CollectionFactory;
import com.jetbrains.cidr.lang.modulemap.ModuleMapLog;
import com.jetbrains.cidr.lang.modulemap.ModuleMapRoot;
import com.jetbrains.cidr.lang.modulemap.ModuleMapUtil;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0011\u001a\u00020\u0005R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\u00020\t*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/resolve/manager/ModuleMapLocationCache;", "", "()V", "moduleMapLocationsCache", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/jetbrains/cidr/lang/modulemap/ModuleMapRoot;", "", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot;", "searchRootPath", "", "getSearchRootPath", "(Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot;)Ljava/lang/String;", "buildPossibleModuleMapLocations", "headersSearchRoot", "clear", "", "getPossibleModuleMapLocations", "moduleMapRoot", "Companion", "intellij.c"})
public final class ModuleMapLocationCache {
    private final ConcurrentMap<ModuleMapRoot, Collection<HeadersSearchRoot>> moduleMapLocationsCache = CollectionFactory.createConcurrentSoftMap();
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Collection<HeadersSearchRoot> getPossibleModuleMapLocations(@NotNull ModuleMapRoot moduleMapRoot) {
        return this.moduleMapLocationsCache.computeIfAbsent(moduleMapRoot, new Function(this){
            final /* synthetic */ ModuleMapLocationCache this$0;

            public final Collection<HeadersSearchRoot> apply(ModuleMapRoot root) {
                return ModuleMapLocationCache.access$buildPossibleModuleMapLocations(this.this$0, root.getRoot());
            }
            {
                this.this$0 = moduleMapLocationCache;
            }
        });
    }

    private final Collection<HeadersSearchRoot> buildPossibleModuleMapLocations(HeadersSearchRoot headersSearchRoot) {
        if (ModuleMapLog.LOG.isTraceEnabled()) {
            ModuleMapLog.LOG.trace("Collecting possible module map locations for " + this.getSearchRootPath(headersSearchRoot));
        }
        Collection<HeadersSearchRoot> possibleLocations = ModuleMapUtil.getPossibleModuleMapLocations(headersSearchRoot);
        if (ModuleMapLog.LOG.isTraceEnabled()) {
            Iterable $this$forEach$iv = possibleLocations;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HeadersSearchRoot possibleLocation = (HeadersSearchRoot)element$iv;
                boolean bl = false;
                ModuleMapLog.LOG.trace("  found possible location " + this.getSearchRootPath(possibleLocation));
            }
        }
        return possibleLocations;
    }

    private final String getSearchRootPath(HeadersSearchRoot $this$searchRootPath) {
        Object object = $this$searchRootPath.getVirtualFile();
        if (object == null || (object = object.getPath()) == null) {
            object = $this$searchRootPath.getName();
        }
        return object;
    }

    public final void clear() {
        this.moduleMapLocationsCache.clear();
    }

    public static final /* synthetic */ Collection access$buildPossibleModuleMapLocations(ModuleMapLocationCache $this, HeadersSearchRoot headersSearchRoot) {
        return $this.buildPossibleModuleMapLocations(headersSearchRoot);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/resolve/manager/ModuleMapLocationCache$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/cidr/lang/modulemap/resolve/manager/ModuleMapLocationCache;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.c"})
    public static final class Companion {
        @NotNull
        public final ModuleMapLocationCache getInstance(@NotNull Project project) {
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            return (ModuleMapLocationCache)$this$service$iv.getService(ModuleMapLocationCache.class);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

