/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.PlatformUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.UtilKt;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.modulemap.ModuleMapLog;
import com.jetbrains.cidr.lang.modulemap.ModuleMapRoot;
import com.jetbrains.cidr.lang.modulemap.psi.ModuleMapFile;
import com.jetbrains.cidr.lang.modulemap.psi.impl.ModuleMapFileImpl;
import com.jetbrains.cidr.lang.modulemap.resolve.IncludedHeadersRootModuleMapCollector;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapDefaultPathResolver;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapPathResolver;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapAssembledPack;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMap;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapSymbol;
import com.jetbrains.cidr.lang.modulemap.symbols.impl.ModuleMapSymbolBuilding;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.psi.impl.OCCodeFragmentImpl;
import com.jetbrains.cidr.lang.qualifiedName.QualifiedName;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.IncludedHeadersRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.ModuleMapAwareHeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.ModuleMapLocationProvider;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u008a\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u001a\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0004H\u0007\u001a\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u0006\u0010\u001f\u001a\u00020 \u001a\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0004\u001a(\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%*\u00020'2\u0016\b\u0002\u0010(\u001a\u0010\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u0018\u0018\u00010)\u001a(\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%*\u00020&2\u0016\b\u0002\u0010(\u001a\u0010\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u0018\u0018\u00010)\u001a.\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%*\b\u0012\u0004\u0012\u00020&0*2\u0016\b\u0002\u0010(\u001a\u0010\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u0018\u0018\u00010)\u001a.\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%*\b\u0012\u0004\u0012\u00020&0%2\u0016\b\u0002\u0010(\u001a\u0010\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u0018\u0018\u00010)\u001a\n\u0010+\u001a\u00020,*\u00020\n\u001a\f\u0010+\u001a\u00020,*\u00020\rH\u0002\u001a\n\u0010-\u001a\u00020\u0002*\u00020.\u001a.\u0010/\u001a\b\u0012\u0004\u0012\u00020&0%*\b\u0012\u0004\u0012\u00020&0%2\u0014\u0010(\u001a\u0010\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u0018\u0018\u00010)H\u0002\u001a\f\u00100\u001a\u0004\u0018\u00010\u0004*\u00020\r\u001a\u0016\u00101\u001a\u0004\u0018\u00010'*\u00020\n2\b\u00102\u001a\u0004\u0018\u00010.\u001a\u0016\u00103\u001a\u0004\u0018\u00010&*\u00020\u00052\u0006\u00104\u001a\u00020'H\u0002\u001a\u0016\u00103\u001a\u0004\u0018\u00010&*\u00020\u00052\b\u00102\u001a\u0004\u0018\u00010.\u001a\f\u00105\u001a\u0004\u0018\u00010\u0004*\u00020\n\u001a\u0012\u00106\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040**\u00020\u0005\u001a\u001a\u00106\u001a\b\u0012\u0004\u0012\u00020\u00040**\u00020\u00052\u0006\u00104\u001a\u00020'H\u0002\u001a\u0010\u00107\u001a\b\u0012\u0004\u0012\u00020\u00040**\u00020\u0005\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u000e\"\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\"\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0015\"\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0016\u00a8\u00068"}, d2={"MODULE_MAP_CONTEXT", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/cidr/lang/preprocessor/OCImmutableInclusionContext;", "mainFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/AppleFramework;", "getMainFile", "(Lcom/jetbrains/cidr/lang/workspace/headerRoots/AppleFramework;)Lcom/intellij/openapi/vfs/VirtualFile;", "possibleModuleMapLocations", "", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot;", "getPossibleModuleMapLocations", "(Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot;)Ljava/util/Collection;", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/IncludedHeadersRoot;", "(Lcom/jetbrains/cidr/lang/workspace/headerRoots/IncludedHeadersRoot;)Ljava/util/Collection;", "rootText", "", "Lcom/jetbrains/cidr/lang/modulemap/ModuleMapRoot;", "getRootText", "(Lcom/jetbrains/cidr/lang/modulemap/ModuleMapRoot;)Ljava/lang/String;", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapAssembledPack;", "(Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapAssembledPack;)Ljava/lang/String;", "(Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot;)Ljava/lang/String;", "checkModuleMapFile", "", "file", "forceLoadModuleMapFile", "Lcom/jetbrains/cidr/lang/modulemap/psi/ModuleMapFile;", "moduleMapFile", "project", "Lcom/intellij/openapi/project/Project;", "getPreferredLanguageKind", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "getTimestamp", "", "root", "allModules", "Lkotlin/sequences/Sequence;", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapSymbol;", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMap;", "condition", "Lkotlin/Function1;", "", "createModuleMapPathResolver", "Lcom/jetbrains/cidr/lang/modulemap/resolve/ModuleMapPathResolver;", "createSignatureContext", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "filterIfNotNull", "findModuleMapVirtualFile", "getDeclaredModules", "configuration", "getMainFrameworkModule", "moduleMap", "getModuleMapVirtualFile", "getPublicHeadersToInclude", "getPublicHeadersToIncludeWithoutCaching", "intellij.c"})
@JvmName(name="ModuleMapUtil")
public final class ModuleMapUtil {
    private static final Key<OCImmutableInclusionContext> MODULE_MAP_CONTEXT = new Key("MODULE_MAP_CONTEXT");

    @Contract(value="null -> false")
    public static final boolean checkModuleMapFile(@Nullable VirtualFile file) {
        return file != null && file.isValid() && !file.isDirectory();
    }

    @Nullable
    public static final ModuleMapFile forceLoadModuleMapFile(@NotNull VirtualFile moduleMapFile, @NotNull Project project) {
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PsiFile psi = psiManager.findFile(moduleMapFile);
        if (psi instanceof ModuleMapFile) {
            return (ModuleMapFile)psi;
        }
        try {
            String text = VfsUtilCore.loadText((VirtualFile)moduleMapFile);
            return ModuleMapFileImpl.createFromText(text, psiManager);
        }
        catch (IOException e) {
            ModuleMapLog.LOG.info("IOException reading module map at path " + moduleMapFile.getPath(), (Throwable)e);
            return null;
        }
    }

    @NotNull
    public static final List<VirtualFile> getPublicHeadersToIncludeWithoutCaching(@NotNull AppleFramework $this$getPublicHeadersToIncludeWithoutCaching) {
        ModuleMap moduleMap = ModuleMapSymbolBuilding.INSTANCE.buildShallowModuleMap((HeadersSearchRoot)$this$getPublicHeadersToIncludeWithoutCaching);
        return ModuleMapUtil.getPublicHeadersToInclude($this$getPublicHeadersToIncludeWithoutCaching, moduleMap);
    }

    @Nullable
    public static final ModuleMap getDeclaredModules(@NotNull HeadersSearchRoot $this$getDeclaredModules, @Nullable OCResolveConfiguration configuration) {
        return ModuleMapManager.Companion.getInstance($this$getDeclaredModules.getProject()).cacheFor(configuration).getModuleMap($this$getDeclaredModules);
    }

    @Nullable
    public static final VirtualFile getMainFile(@NotNull AppleFramework $this$mainFile) {
        ModuleMapSymbol moduleMapSymbol = ModuleMapUtil.getMainFrameworkModule($this$mainFile, null);
        return moduleMapSymbol != null ? moduleMapSymbol.getUmbrellaHeaderVirtualFile() : null;
    }

    @Nullable
    public static final ModuleMapSymbol getMainFrameworkModule(@NotNull AppleFramework $this$getMainFrameworkModule, @Nullable OCResolveConfiguration configuration) {
        ModuleMap moduleMap = ModuleMapManager.Companion.getInstance($this$getMainFrameworkModule.getProject()).cacheFor(configuration).getModuleMap((HeadersSearchRoot)$this$getMainFrameworkModule);
        if (moduleMap == null) {
            return null;
        }
        ModuleMap moduleMap2 = moduleMap;
        return ModuleMapUtil.getMainFrameworkModule($this$getMainFrameworkModule, moduleMap2);
    }

    private static final ModuleMapSymbol getMainFrameworkModule(AppleFramework $this$getMainFrameworkModule, ModuleMap moduleMap) {
        return moduleMap.getModule(QualifiedName.Companion.asQualifiedName($this$getMainFrameworkModule.getName()));
    }

    @NotNull
    public static final List<VirtualFile> getPublicHeadersToInclude(@NotNull AppleFramework $this$getPublicHeadersToInclude) {
        Object object = ModuleMapUtil.getMainFrameworkModule($this$getPublicHeadersToInclude, null);
        if (object == null || (object = object.getIncludeHeaders()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private static final List<VirtualFile> getPublicHeadersToInclude(AppleFramework $this$getPublicHeadersToInclude, ModuleMap moduleMap) {
        Object object = ModuleMapUtil.getMainFrameworkModule($this$getPublicHeadersToInclude, moduleMap);
        if (object == null || (object = object.getIncludeHeaders()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Nullable
    public static final VirtualFile findModuleMapVirtualFile(@NotNull IncludedHeadersRoot $this$findModuleMapVirtualFile) {
        VirtualFile virtualFile = $this$findModuleMapVirtualFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile dir = virtualFile;
        if (!dir.isValid()) {
            ModuleMapLog.LOG.error("Invalid directory: " + $this$findModuleMapVirtualFile);
            return null;
        }
        VirtualFile defaultFile = dir.findChild("module.modulemap");
        if (ModuleMapUtil.checkModuleMapFile(defaultFile)) {
            return defaultFile;
        }
        VirtualFile legacyFile = dir.findChild("module.map");
        if (ModuleMapUtil.checkModuleMapFile(legacyFile)) {
            return legacyFile;
        }
        return null;
    }

    private static final ModuleMapPathResolver createModuleMapPathResolver(IncludedHeadersRoot $this$createModuleMapPathResolver) {
        ModuleMapPathResolver moduleMapPathResolver;
        VirtualFile virtualFile = $this$createModuleMapPathResolver.getVirtualFile();
        if (virtualFile != null) {
            VirtualFile virtualFile2;
            VirtualFile it = virtualFile2 = virtualFile;
            boolean bl = false;
            moduleMapPathResolver = new ModuleMapDefaultPathResolver(it, null, 2, null);
        } else {
            moduleMapPathResolver = ModuleMapPathResolver.NULL;
        }
        return moduleMapPathResolver;
    }

    private static final Collection<HeadersSearchRoot> getPossibleModuleMapLocations(IncludedHeadersRoot $this$possibleModuleMapLocations) {
        if ($this$possibleModuleMapLocations.getKind() == HeadersSearchPath.Kind.BUILTIN) {
            IncludedHeadersRootModuleMapCollector collector = new IncludedHeadersRootModuleMapCollector($this$possibleModuleMapLocations);
            HeadersSearchRoot.processUnder((PsiElementProcessor)((PsiElementProcessor)collector), (VirtualFile)$this$possibleModuleMapLocations.getVirtualFile(), (boolean)false, (Project)$this$possibleModuleMapLocations.getProject());
            return collector.getRoots();
        }
        return CollectionsKt.listOf((Object)$this$possibleModuleMapLocations);
    }

    @Nullable
    public static final VirtualFile getModuleMapVirtualFile(@NotNull HeadersSearchRoot $this$getModuleMapVirtualFile) {
        HeadersSearchRoot headersSearchRoot = $this$getModuleMapVirtualFile;
        return headersSearchRoot instanceof ModuleMapAwareHeadersSearchRoot ? ((ModuleMapAwareHeadersSearchRoot)$this$getModuleMapVirtualFile).getModuleMapVirtualFile() : (headersSearchRoot instanceof IncludedHeadersRoot ? ModuleMapUtil.findModuleMapVirtualFile((IncludedHeadersRoot)$this$getModuleMapVirtualFile) : null);
    }

    @NotNull
    public static final ModuleMapPathResolver createModuleMapPathResolver(@NotNull HeadersSearchRoot $this$createModuleMapPathResolver) {
        ModuleMapPathResolver moduleMapPathResolver;
        HeadersSearchRoot headersSearchRoot = $this$createModuleMapPathResolver;
        if (headersSearchRoot instanceof ModuleMapAwareHeadersSearchRoot) {
            moduleMapPathResolver = ((ModuleMapAwareHeadersSearchRoot)$this$createModuleMapPathResolver).createModuleMapPathResolver();
        } else if (headersSearchRoot instanceof IncludedHeadersRoot) {
            moduleMapPathResolver = ModuleMapUtil.createModuleMapPathResolver((IncludedHeadersRoot)$this$createModuleMapPathResolver);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("An attempt to create ModuleMapPathResolver for " + $this$createModuleMapPathResolver)));
        }
        return moduleMapPathResolver;
    }

    @NotNull
    public static final Collection<HeadersSearchRoot> getPossibleModuleMapLocations(@NotNull HeadersSearchRoot $this$possibleModuleMapLocations) {
        HeadersSearchRoot headersSearchRoot = $this$possibleModuleMapLocations;
        return headersSearchRoot instanceof ModuleMapLocationProvider ? ((ModuleMapLocationProvider)$this$possibleModuleMapLocations).getPossibleModuleMapLocations() : (headersSearchRoot instanceof IncludedHeadersRoot ? ModuleMapUtil.getPossibleModuleMapLocations((IncludedHeadersRoot)$this$possibleModuleMapLocations) : (Collection<Object>)CollectionsKt.listOf((Object)$this$possibleModuleMapLocations));
    }

    @NotNull
    public static final String getRootText(@NotNull ModuleMapAssembledPack $this$rootText) {
        return ModuleMapUtil.getRootText($this$rootText.getModuleMapRoot());
    }

    @NotNull
    public static final String getRootText(@NotNull HeadersSearchRoot $this$rootText) {
        boolean $i$f$runReadAction = false;
        return (String)ApplicationManager.getApplication().runReadAction(new Computable($this$rootText){
            final /* synthetic */ HeadersSearchRoot $this_rootText$inlined;
            {
                this.$this_rootText$inlined = headersSearchRoot;
            }

            public final T compute() {
                boolean bl = false;
                return (T)this.$this_rootText$inlined.toString();
            }
        });
    }

    @NotNull
    public static final String getRootText(@NotNull ModuleMapRoot $this$rootText) {
        return ModuleMapUtil.getRootText($this$rootText.getRoot());
    }

    @NotNull
    public static final OCLanguageKind getPreferredLanguageKind() {
        boolean hasObjC = OCLanguage.enableObjectiveCSettings();
        return CLanguageKind.find((boolean)hasObjC, (!PlatformUtils.isMobileIde() ? 1 : 0) != 0, (boolean)false);
    }

    @NotNull
    public static final OCImmutableInclusionContext createSignatureContext(@NotNull OCResolveConfiguration $this$createSignatureContext) {
        OCImmutableInclusionContext oCImmutableInclusionContext = (OCImmutableInclusionContext)$this$createSignatureContext.getUserData(MODULE_MAP_CONTEXT);
        if (oCImmutableInclusionContext != null) {
            OCImmutableInclusionContext oCImmutableInclusionContext2;
            OCImmutableInclusionContext it = oCImmutableInclusionContext2 = oCImmutableInclusionContext;
            boolean bl = false;
            return it;
        }
        OCLanguageKind preferredLanguageKind = ModuleMapUtil.getPreferredLanguageKind();
        OCCodeFragmentImpl file = new OCCodeFragmentImpl($this$createSignatureContext.getProject(), preferredLanguageKind, "", false, (IElementType)OCTokenTypes.OC_FILE);
        OCInclusionContext context = OCInclusionContext.beforePCHFileContext($this$createSignatureContext, preferredLanguageKind, file);
        return (OCImmutableInclusionContext)$this$createSignatureContext.putUserDataIfAbsent(MODULE_MAP_CONTEXT, (Object)context);
    }

    @NotNull
    public static final Sequence<ModuleMapSymbol> allModules(@NotNull ModuleMap $this$allModules, @Nullable Function1<? super ModuleMapSymbol, Boolean> condition) {
        return ModuleMapUtil.allModules($this$allModules.getModules(), condition);
    }

    public static /* synthetic */ Sequence allModules$default(ModuleMap moduleMap, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        return ModuleMapUtil.allModules(moduleMap, (Function1<? super ModuleMapSymbol, Boolean>)function1);
    }

    @NotNull
    public static final Sequence<ModuleMapSymbol> allModules(@NotNull List<? extends ModuleMapSymbol> $this$allModules, @Nullable Function1<? super ModuleMapSymbol, Boolean> condition) {
        return ModuleMapUtil.allModules((Sequence<? extends ModuleMapSymbol>)CollectionsKt.asSequence((Iterable)$this$allModules), condition);
    }

    public static /* synthetic */ Sequence allModules$default(List list, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        return ModuleMapUtil.allModules(list, (Function1<? super ModuleMapSymbol, Boolean>)function1);
    }

    @NotNull
    public static final Sequence<ModuleMapSymbol> allModules(@NotNull ModuleMapSymbol $this$allModules, @Nullable Function1<? super ModuleMapSymbol, Boolean> condition) {
        return ModuleMapUtil.allModules((Sequence<? extends ModuleMapSymbol>)SequencesKt.sequenceOf((Object[])new ModuleMapSymbol[]{$this$allModules}), condition);
    }

    public static /* synthetic */ Sequence allModules$default(ModuleMapSymbol moduleMapSymbol, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        return ModuleMapUtil.allModules(moduleMapSymbol, (Function1<? super ModuleMapSymbol, Boolean>)function1);
    }

    @NotNull
    public static final Sequence<ModuleMapSymbol> allModules(@NotNull Sequence<? extends ModuleMapSymbol> $this$allModules, @Nullable Function1<? super ModuleMapSymbol, Boolean> condition) {
        return UtilKt.generateRecursiveSequence(ModuleMapUtil.filterIfNotNull($this$allModules, condition), (Function1)((Function1)new Function1<ModuleMapSymbol, Sequence<? extends ModuleMapSymbol>>(condition){
            final /* synthetic */ Function1 $condition;

            @NotNull
            public final Sequence<ModuleMapSymbol> invoke(@NotNull ModuleMapSymbol module) {
                return ModuleMapUtil.access$filterIfNotNull(CollectionsKt.asSequence((Iterable)module.getSubModules().values()), this.$condition);
            }
            {
                this.$condition = function1;
                super(1);
            }
        }));
    }

    public static /* synthetic */ Sequence allModules$default(Sequence sequence, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        return ModuleMapUtil.allModules((Sequence<? extends ModuleMapSymbol>)sequence, (Function1<? super ModuleMapSymbol, Boolean>)function1);
    }

    private static final Sequence<ModuleMapSymbol> filterIfNotNull(Sequence<? extends ModuleMapSymbol> $this$filterIfNotNull, Function1<? super ModuleMapSymbol, Boolean> condition) {
        return condition == null ? $this$filterIfNotNull : SequencesKt.filter($this$filterIfNotNull, condition);
    }

    /*
     * WARNING - void declaration
     */
    public static final long getTimestamp(@NotNull VirtualFile root) {
        void timestamp;
        Ref.LongRef longRef = new Ref.LongRef();
        longRef.element = 0L;
        VfsUtilCore.processFilesRecursively((VirtualFile)root, (Processor)new Processor((Ref.LongRef)timestamp){
            final /* synthetic */ Ref.LongRef $timestamp;

            public final boolean process(VirtualFile file) {
                String fileName = file.getName();
                if (!FileUtil.extensionEquals((String)fileName, (String)"lock") && !StringsKt.startsWith$default((CharSequence)fileName, (char)'.', (boolean)false, (int)2, null)) {
                    this.$timestamp.element += file.getTimeStamp();
                }
                return true;
            }
            {
                this.$timestamp = longRef;
            }
        });
        return timestamp.element;
    }

    public static final /* synthetic */ Sequence access$filterIfNotNull(Sequence $this$access_u24filterIfNotNull, Function1 condition) {
        return ModuleMapUtil.filterIfNotNull((Sequence<? extends ModuleMapSymbol>)$this$access_u24filterIfNotNull, (Function1<? super ModuleMapSymbol, Boolean>)condition);
    }
}

