/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.legacy.types.visitors;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.legacy.types.OCTypeCheckResult;
import com.jetbrains.cidr.lang.legacy.types.OCTypeCheckResultBuilder;
import com.jetbrains.cidr.lang.legacy.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.expression.OCLiteralExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCTollFreeBridges;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeCheckState;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCTypeCompatibilityVisitor_OCArrayType
extends OCTypeCompatibilityVisitor<OCArrayType> {
    protected OCTypeCompatibilityVisitor_OCArrayType(@NotNull OCArrayType sourceType, @Nullable OCTypeOwner source, @Nullable PsiElement context, boolean allowImplicitConversions, boolean assumeNullSubstitutionsEquals, @NotNull OCResolveContext resolveContext) {
        super(sourceType, source, context, allowImplicitConversions, assumeNullSubstitutionsEquals, resolveContext);
    }

    @Override
    public OCTypeCheckResult visitFunctionType(final OCFunctionType type) {
        return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP, OCInspections.IncompatiblePointers.class, "ext_typecheck_convert_incompatible_pointer", new IntentionAction[0]){

            @Override
            public String getMessage() {
                return "Incompatible pointer types '" + type.getName(OCTypeCompatibilityVisitor_OCArrayType.this.myResolveContext) + "' and '" + OCTypeCompatibilityVisitor_OCArrayType.this.getSourceTypeName() + "'";
            }
        };
    }

    @Override
    public OCTypeCheckResult visitObjectType(OCObjectType type) {
        return this.visitType(type);
    }

    @Override
    public OCTypeCheckResult visitPointerType(final OCPointerType type) {
        OCType lTerminalType = type.getTerminalType();
        OCType rTerminalType = ((OCArrayType)this.mySourceType).getTerminalType();
        int lPointersDepth = type.pointersDepth();
        int rPointersDepth = ((OCArrayType)this.mySourceType).pointersDepth();
        if (!(lTerminalType.isUnknown() || rTerminalType.isUnknown() || lTerminalType instanceof OCFunctionType && rTerminalType instanceof OCFunctionType || !(type.isPointerToPointerToObjectCompatible() ^ ((OCArrayType)this.mySourceType).isPointerToPointerToObjectCompatible()))) {
            boolean isTollFreeBridge = OCTollFreeBridges.isCompatible(type, this.mySourceType);
            if (OCCompilerFeaturesHelper.isArcEnabled(this.myContext.getContainingFile())) {
                OCTypeCheckResult result = this.checkArcBridgeCast(type, isTollFreeBridge);
                if (result != null) {
                    return result;
                }
            } else if (isTollFreeBridge) {
                return OCTypeCheckResultBuilder.createOK();
            }
        }
        OCTypeCheckResult checkResult = this.validateConstPointers(type, this.myResolveContext);
        boolean isCpp = OCTypeCompatibilityVisitor_OCArrayType.isCpp(this.myContext);
        boolean warningEvenInCpp = false;
        if (!checkResult.getState().isError(this.myContext)) {
            return checkResult;
        }
        if (lTerminalType instanceof OCObjectType && rTerminalType instanceof OCObjectType && type.getRefType().isCompatible(((OCArrayType)this.mySourceType).getRefType(), this.myResolveContext)) {
            return OCTypeCheckResultBuilder.createOK();
        }
        if (type.isPointerToVoid() && !isCpp) {
            return OCTypeCheckResultBuilder.createOK();
        }
        if (((OCArrayType)this.mySourceType).isPointerToVoid() && !isCpp) {
            return OCTypeCheckResultBuilder.createOK();
        }
        if (lTerminalType instanceof OCObjectType && rTerminalType instanceof OCObjectType && lPointersDepth == rPointersDepth) {
            return OCTypeCompatibilityVisitor_OCArrayType.checkConvertible(type.getRefType(), ((OCArrayType)this.mySourceType).getRefType(), this.mySource, this.myContext, true, true, this.myResolveContext);
        }
        if (lTerminalType instanceof OCMagicType) {
            return OCTypeCheckResultBuilder.createOK();
        }
        if (this.isCppClassType(lTerminalType) && this.isCppClassType(rTerminalType) && lPointersDepth == rPointersDepth) {
            if (OCTypeUtils.isSameOrDerivedFrom(((OCArrayType)this.mySourceType).getRefType(), type.getRefType(), this.myResolveContext) || ((OCArrayType)this.mySourceType).isMagicInside(this.myResolveContext)) {
                return OCTypeCheckResultBuilder.createOK();
            }
            if (this.myContext instanceof OCCastExpression) {
                warningEvenInCpp = true;
            }
        }
        if (lTerminalType instanceof OCFunctionType && rTerminalType instanceof OCFunctionType && lPointersDepth == rPointersDepth) {
            return OCTypeCompatibilityVisitor_OCArrayType.checkConvertible(type.getRefType(), ((OCArrayType)this.mySourceType).getRefType(), this.mySource, this.myContext, true, true, this.myResolveContext);
        }
        if (type.getRefType() instanceof OCIdType && ((OCIdType)type.getRefType()).getAllProtocols().isEmpty() && ((OCArrayType)this.mySourceType).isPointerToObjectCompatible() || type.isPointerToObjectCompatible() && ((OCArrayType)this.mySourceType).isPointerToID() && ((OCArrayType)this.mySourceType).getTerminalType() instanceof OCObjectType && ((OCObjectType)((OCArrayType)this.mySourceType).getTerminalType()).getAllProtocols().isEmpty()) {
            return OCTypeCheckResultBuilder.createOK();
        }
        if ((lTerminalType instanceof OCReferenceType || rTerminalType instanceof OCReferenceType) && type.getCanonicalName(this.myResolveContext).equals(((OCArrayType)this.mySourceType).getCanonicalName(this.myResolveContext))) {
            return OCTypeCheckResultBuilder.createOK();
        }
        OCTypeOwner innerSource = OCParenthesesUtils.diveIntoParentheses(this.mySource);
        if (isCpp && lPointersDepth == 1 && rPointersDepth == 1 && innerSource instanceof OCLiteralExpression && lTerminalType instanceof OCIntType && rTerminalType instanceof OCIntType) {
            boolean bothChars = this.bothTypesEquals(OCIntType.CHAR, lTerminalType, rTerminalType);
            boolean bothWide = this.bothTypesEquals(OCIntType.WCHAR, lTerminalType, rTerminalType);
            boolean bothChar8 = this.bothTypesEquals(OCIntType.CHAR8, lTerminalType, rTerminalType);
            boolean bothChar16 = this.bothTypesEquals(OCIntType.CHAR16, lTerminalType, rTerminalType);
            boolean bothChar32 = this.bothTypesEquals(OCIntType.CHAR32, lTerminalType, rTerminalType);
            if ((bothChars || bothWide || bothChar8 || bothChar16 || bothChar32) && !lTerminalType.isConst() && rTerminalType.isConst()) {
                return new OCTypeCheckResult(OCTypeCheckState.WARNING, OCInspections.IncompatiblePointers.class, "ext_deprecated_string_literal_conversion", new IntentionAction[0]){

                    @Override
                    public String getMessage() {
                        return "Deprecated conversion from string literal to '" + type.getName(OCTypeCompatibilityVisitor_OCArrayType.this.myResolveContext) + "'";
                    }
                };
            }
        }
        OCTypeCheckState state = warningEvenInCpp ? OCTypeCheckState.WARNING : OCTypeCheckState.ERROR_IF_CPP;
        return new OCTypeCheckResult(state, OCInspections.IncompatiblePointers.class, "ext_typecheck_convert_incompatible_pointer", new IntentionAction[0]){

            @Override
            public String getMessage() {
                return "Incompatible pointer types '" + type.getName(OCTypeCompatibilityVisitor_OCArrayType.this.myResolveContext) + "' and '" + OCTypeCompatibilityVisitor_OCArrayType.this.getSourceTypeName() + "'";
            }
        };
    }

    @Override
    public OCTypeCheckResult visitArrayType(OCArrayType type) {
        OCTypeCheckResult literalsResult = this.handleStringLiterals(type);
        if (literalsResult != null) {
            return literalsResult;
        }
        return super.visitArrayType(type);
    }

    @Nullable
    private OCTypeCheckResult handleStringLiterals(OCArrayType dest) {
        if (dest.getRefType() instanceof OCIntType) {
            OCIntType dstRefType = (OCIntType)dest.getRefType();
            OCType refType = ((OCArrayType)this.mySourceType).getRefType();
            if ((OCIntType.CHAR.equals(dstRefType, false, this.myResolveContext) || OCIntType.UCHAR.equals(dstRefType, false, this.myResolveContext) || OCIntType.SCHAR.equals(dstRefType, false, this.myResolveContext)) && OCIntType.CHAR.equals(refType, false, this.myResolveContext) || this.bothTypesEquals(OCIntType.WCHAR, dstRefType, refType) || this.bothTypesEquals(OCIntType.CHAR16, dstRefType, refType) || this.bothTypesEquals(OCIntType.CHAR32, dstRefType, refType)) {
                OCTypeOwner innerSource = OCParenthesesUtils.diveIntoParentheses(this.mySource);
                if (innerSource instanceof OCLiteralExpressionSymbol) {
                    return OCTypeCheckResultBuilder.createOK();
                }
                if (innerSource instanceof OCLiteralExpression && ((OCLiteralExpression)innerSource).isStringLiteral()) {
                    if (((OCArrayType)this.mySourceType).hasLength() && dest.hasLength()) {
                        final int literalLength = ((OCArrayType)this.mySourceType).getLength(this.myResolveContext);
                        final int destLength = dest.getLength(this.myResolveContext);
                        if (destLength < literalLength) {
                            return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP, OCInspections.IncompatibleInitializers.class, "ext_initializer_string_for_char_array_too_long", (OCExpression)innerSource, new IntentionAction[0]){

                                @Override
                                public String getMessage() {
                                    return destLength == literalLength - 1 ? "Initializer string is too long, null-terminator doesn't fit" : "Initializer string is too long for array of chars";
                                }
                            };
                        }
                    }
                    return OCTypeCheckResultBuilder.createOK();
                }
            }
        }
        return null;
    }

    @Override
    public OCTypeCheckResult visitStructType(OCStructType type) {
        if (OCTollFreeBridges.isCompatible(this.mySourceType, type)) {
            return OCTypeCheckResultBuilder.createOK();
        }
        if (type.getKind() == OCSymbolKind.ENUM && !type.isEnumClass()) {
            Computable message = () -> "Taking enum type '" + type.getBestNameInContext(this.myResolveContext) + "' from pointer";
            return this.checkAssignToEnum(type, (Computable<String>)message);
        }
        return this.checkStructCompatibleCtor(type);
    }
}

