/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.legacy.refactoring;

import com.intellij.lang.ImportOptimizer;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.OCObjCAnnotator;
import com.jetbrains.cidr.lang.legacy.daemon.OCErrorAnnotator;
import com.jetbrains.cidr.lang.legacy.daemon.OCResolveAnnotator;
import com.jetbrains.cidr.lang.legacy.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.preprocessor.OCRootUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveElementsIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCImportsOptimizer
implements ImportOptimizer {
    public boolean supports(@NotNull PsiFile file) {
        return file instanceof OCFile;
    }

    @NotNull
    public Runnable processFile(@NotNull PsiFile file) {
        if (!(file instanceof OCFile) || !OCImportsOptimizer.shouldOptimizeImports(file)) {
            return EmptyRunnable.INSTANCE;
        }
        List<OCIncludeDirective> imports = OCImportsOptimizer.getUnusedImports((OCFile)file);
        OCRemoveElementsIntentionAction action = new OCRemoveElementsIntentionAction(imports, "", "");
        return () -> action.invoke(file.getProject(), null, file);
    }

    public static boolean shouldOptimizeImports(@NotNull PsiFile file) {
        return OCRootUtil.isRoot(file);
    }

    public static List<OCIncludeDirective> getUnusedImports(OCFile file) {
        return OCImportsOptimizer.runAnnotatorAndGetImports(file, Collections.singletonList(file), false, true);
    }

    public static List<OCIncludeDirective> getUnusedImports(OCFile file, Collection<? extends PsiElement> elements) {
        if (elements.isEmpty()) {
            return Collections.emptyList();
        }
        return OCImportsOptimizer.runAnnotatorAndGetImports(file, elements, false, false);
    }

    public static List<OCIncludeDirective> getUsedImports(OCFile file, Collection<? extends PsiElement> elements) {
        if (elements.isEmpty()) {
            return Collections.emptyList();
        }
        return OCImportsOptimizer.runAnnotatorAndGetImports(file, elements, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<OCIncludeDirective> runAnnotatorAndGetImports(OCFile file, Collection<? extends PsiElement> elements, boolean used, boolean requiredAsUsed) {
        final OCResolveAnnotator resolveAnnotator = new OCResolveAnnotator();
        final OCErrorAnnotator errorAnnotator = new OCErrorAnnotator();
        final OCObjCAnnotator objCAnnotator = new OCObjCAnnotator();
        final AnnotationSession session = new AnnotationSession((PsiFile)file);
        file.pushAnnotationSession(session);
        try {
            for (PsiElement psiElement : elements) {
                if (psiElement instanceof OCSymbolHolderVirtualPsiElement) {
                    OCFileSymbols.markImportNeeded(file, ((OCSymbolHolderVirtualPsiElement)psiElement).getSymbol());
                    continue;
                }
                assert (psiElement.getContainingFile() == file);
                psiElement.accept((PsiElementVisitor)new OCRecursiveVisitor(){

                    @Override
                    public void visitElement(@NotNull PsiElement element) {
                        super.visitElement(element);
                        resolveAnnotator.annotate(element, null, session);
                        errorAnnotator.annotate(element, null, session);
                        objCAnnotator.annotate(element, null, session);
                    }
                });
            }
            List<OCIncludeDirective> list = OCImportsOptimizer.doGetImports(file, used, requiredAsUsed);
            return list;
        }
        finally {
            file.popAnnotationSession();
        }
    }

    public static List<OCIncludeDirective> doGetImports(OCFile file, boolean used, boolean requiredAsUsed) {
        ArrayList<OCIncludeDirective> result = new ArrayList<OCIncludeDirective>();
        HashSet<VirtualFile> usedFiles = new HashSet<VirtualFile>();
        for (OCIncludeDirective directive : file.findIncludeDirectives()) {
            if (!OCCodeInsightUtil.isValid(directive) || !directive.isTopLevel() || !directive.getContainingFile().equals(file)) continue;
            PsiFile importedFile = directive.getIncludedFile();
            VirtualFile filePath = OCElementUtil.getFilePath(importedFile);
            if (!(importedFile instanceof OCFile) || filePath == null) continue;
            if ((OCFileSymbols.isImportUsed(file, filePath) || requiredAsUsed && OCFileSymbols.isImportRequired(file, filePath)) && !usedFiles.contains(filePath)) {
                usedFiles.add(filePath);
                if (!used) continue;
                result.add(directive);
                continue;
            }
            if (used) continue;
            result.add(directive);
        }
        return result;
    }
}

