/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.legacy.dfa;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.dfa.OCUnreachableCodeFinder;
import com.jetbrains.cidr.lang.legacy.dfa.OCConditionsList;
import com.jetbrains.cidr.lang.legacy.dfa.OCControlFlowBuilder;
import com.jetbrains.cidr.lang.legacy.dfa.OCDFAUtils;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCaseStatement;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCCastKind;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCNumber;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import com.jetbrains.sourceglider.atttributes.Attribute;
import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.relations.RelationSignature;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.utils.PrettyName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCContextSensitiveControlFlowBuilder
extends OCControlFlowBuilder {
    private static final Logger LOG = Logger.getInstance(OCContextSensitiveControlFlowBuilder.class);
    public static final String CONTEXT_SENSITIVITY = "CONTEXT_SENSITIVITY";
    public static final String GLOBAL_ANALYSIS = "GLOBAL_ANALYSIS";
    private static final int MAX_CONTEXTS_CNT = 1000000;
    private final MultiMap<OCNode, Integer> myStatementContexts = new MultiMap();
    private final Map<OCCallable, Map<Integer, OCElementsRange>> myRangesMap = new HashMap<OCCallable, Map<Integer, OCElementsRange>>();
    private Set<PsiElement> myNotUsedWrites;
    private MultiMap<OCNode, Attribute> myVariableWrites;
    private PsiFile myFile;
    private OCResolveContext myResolveContext;
    private final SymbolTable mySymbolTable;
    private boolean myContextSensitivity;
    private boolean myGlobalAnalysis;
    private int myCurContext;
    private Attribute myCallableAttribute;
    private Set<OCType> myProcessedTypes = OCTypeUtils.newTypeSet();
    private List<RelationSignature> mySignatures = new ArrayList<RelationSignature>();
    private final TuplesConsumer myConsumer;
    private Map<OCCallable, OCControlFlowGraph> myGraphs = new HashMap<OCCallable, OCControlFlowGraph>();
    private Set<OCNode> myFakeNodes = new HashSet<OCNode>();
    private Map<Integer, Integer> myFakeContexts = new HashMap<Integer, Integer>();
    private MultiMap<OCNode, Pair<RelationSignature, Attribute[]>> myFakeNodeAttributes = new MultiMap();
    private Map<PsiElement, BranchConditions> myBranchConditions = new HashMap<PsiElement, BranchConditions>();
    private Set<OCSymbol> myPrivateFields = new HashSet<OCSymbol>();
    private Set<OCSymbol> myPrivateParameters = new HashSet<OCSymbol>();
    private int myVisitorRecursiveCnt;
    private ThreadCallback myThreadCallback;
    private RelationSignature myAssignmentToVar;
    private RelationSignature myAssignmentToConstant;
    private RelationSignature myAssignmentToExpression;
    private RelationSignature myAssignmentToCall;
    private RelationSignature myNonInitializedDeclarator;
    private RelationSignature myVarArgument;
    private RelationSignature myConstArgument;
    private RelationSignature myParameter;
    private RelationSignature myPrivateMethod;
    private RelationSignature myPrivateField;
    private RelationSignature myEqualityToConstConditionalJump;
    private RelationSignature myNonEqualityToConstConditionalJump;
    private RelationSignature myEqualityToVarConditionalJump;
    private RelationSignature myNonEqualityToVarConditionalJump;
    private RelationSignature myInstanceOfConditionalJump;
    private RelationSignature myNonInstanceOfConditionalJump;
    private RelationSignature myUnconditionalJump;
    private RelationSignature myNodeJump;
    private RelationSignature myStartNode;
    private RelationSignature myConditionThenBranch;
    private RelationSignature myConditionElseBranch;
    private RelationSignature myShortCuttedBranch;
    private RelationSignature myContextInfo;
    private RelationSignature myExpressionType;
    private RelationSignature myConstantType;
    private RelationSignature myVariableType;
    private RelationSignature myMethodReturnType;
    private RelationSignature mySubType;
    private RelationSignature myUnknownSubType;
    private RelationSignature myPODType;
    private RelationSignature myPointerTypeVariable;
    private RelationSignature myComplexTypeVariable;
    private RelationSignature myCastExpression;
    private RelationSignature myDynamicCallExpression;
    private RelationSignature myGetReferenceExpression;
    private RelationSignature myDereferenceExpression;
    private RelationSignature myMessageReceiverExpression;
    private RelationSignature myCallStatement;
    private RelationSignature myExternalCallStatement;
    private RelationSignature myReturnVarStatement;
    private RelationSignature myReturnConstStatement;
    private RelationSignature myExitStatement;
    private long myUniqueUnknownExpressionAttributeId = 0L;

    public OCContextSensitiveControlFlowBuilder(@NotNull SymbolTable symbolTable, TuplesConsumer tuplesConsumer) {
        this.mySymbolTable = symbolTable;
        this.myConsumer = tuplesConsumer;
        DomainType O = symbolTable.getDomainType("Object");
        DomainType C = symbolTable.getDomainType("Constant");
        DomainType V = symbolTable.getDomainType("Variable");
        DomainType S = symbolTable.getDomainType("BigInteger");
        DomainType M = symbolTable.getDomainType("Method");
        DomainType T = symbolTable.getDomainType("Type");
        DomainType N = symbolTable.getDomainType("Integer");
        this.myAssignmentToVar = new RelationSignature("AssignmentToVar", new DomainType[]{S, V, V});
        this.mySignatures.add(this.myAssignmentToVar);
        this.myAssignmentToConstant = new RelationSignature("AssignmentToConstant", new DomainType[]{S, V, C});
        this.mySignatures.add(this.myAssignmentToConstant);
        this.myAssignmentToExpression = new RelationSignature("AssignmentToExpression", new DomainType[]{S, V, O});
        this.mySignatures.add(this.myAssignmentToExpression);
        this.myAssignmentToCall = new RelationSignature("AssignmentToCall", new DomainType[]{S, V, M});
        this.mySignatures.add(this.myAssignmentToCall);
        this.myNonInitializedDeclarator = new RelationSignature("NonInitializedDeclarator", new DomainType[]{S, V, O});
        this.mySignatures.add(this.myNonInitializedDeclarator);
        this.myEqualityToConstConditionalJump = new RelationSignature("EqualityToConstConditionalJump", new DomainType[]{S, S, V, C});
        this.mySignatures.add(this.myEqualityToConstConditionalJump);
        this.myNonEqualityToConstConditionalJump = new RelationSignature("NonEqualityToConstConditionalJump", new DomainType[]{S, S, V, C});
        this.mySignatures.add(this.myNonEqualityToConstConditionalJump);
        this.myEqualityToVarConditionalJump = new RelationSignature("EqualityToVarConditionalJump", new DomainType[]{S, S, V, V});
        this.mySignatures.add(this.myEqualityToVarConditionalJump);
        this.myNonEqualityToVarConditionalJump = new RelationSignature("NonEqualityToVarConditionalJump", new DomainType[]{S, S, V, V});
        this.mySignatures.add(this.myNonEqualityToVarConditionalJump);
        this.myInstanceOfConditionalJump = new RelationSignature("InstanceOfConditionalJump", new DomainType[]{S, S, V, T});
        this.mySignatures.add(this.myInstanceOfConditionalJump);
        this.myNonInstanceOfConditionalJump = new RelationSignature("NonInstanceOfConditionalJump", new DomainType[]{S, S, V, T});
        this.mySignatures.add(this.myNonInstanceOfConditionalJump);
        this.myUnconditionalJump = new RelationSignature("UnconditionalJump", new DomainType[]{S, S});
        this.mySignatures.add(this.myUnconditionalJump);
        this.myNodeJump = new RelationSignature("NodeJump", new DomainType[]{M, S, S});
        this.mySignatures.add(this.myNodeJump);
        this.myStartNode = new RelationSignature("StartNode", new DomainType[]{M, S});
        this.mySignatures.add(this.myStartNode);
        this.myConditionThenBranch = new RelationSignature("ConditionThenBranch", new DomainType[]{S, O});
        this.mySignatures.add(this.myConditionThenBranch);
        this.myConditionElseBranch = new RelationSignature("ConditionElseBranch", new DomainType[]{S, O});
        this.mySignatures.add(this.myConditionElseBranch);
        this.myShortCuttedBranch = new RelationSignature("ShortCuttedBranch", new DomainType[]{O});
        this.mySignatures.add(this.myShortCuttedBranch);
        this.myContextInfo = new RelationSignature("ContextInfo", new DomainType[]{M, S, S});
        this.mySignatures.add(this.myContextInfo);
        this.myVariableType = new RelationSignature("VariableType", new DomainType[]{V, T});
        this.mySignatures.add(this.myVariableType);
        this.myExpressionType = new RelationSignature("ExpressionType", new DomainType[]{O, T});
        this.mySignatures.add(this.myExpressionType);
        this.myConstantType = new RelationSignature("ConstantType", new DomainType[]{C, O, T});
        this.mySignatures.add(this.myConstantType);
        this.myCastExpression = new RelationSignature("CastExpression", new DomainType[]{S, V, T, O});
        this.mySignatures.add(this.myCastExpression);
        this.myDynamicCallExpression = new RelationSignature("DynamicCallExpression", new DomainType[]{S, V, T, O});
        this.mySignatures.add(this.myDynamicCallExpression);
        this.myGetReferenceExpression = new RelationSignature("GetReferenceExpression", new DomainType[]{S, V});
        this.mySignatures.add(this.myGetReferenceExpression);
        this.myDereferenceExpression = new RelationSignature("DereferenceExpression", new DomainType[]{S, V, O});
        this.mySignatures.add(this.myDereferenceExpression);
        this.myMessageReceiverExpression = new RelationSignature("MessageReceiverExpression", new DomainType[]{S, V, O});
        this.mySignatures.add(this.myMessageReceiverExpression);
        this.mySubType = new RelationSignature("SubType", new DomainType[]{T, T});
        this.mySignatures.add(this.mySubType);
        this.myUnknownSubType = new RelationSignature("UnknownSubType", new DomainType[]{T, T});
        this.mySignatures.add(this.myUnknownSubType);
        this.myPODType = new RelationSignature("PODType", new DomainType[]{T});
        this.mySignatures.add(this.myPODType);
        this.myPointerTypeVariable = new RelationSignature("PointerTypeVariable", new DomainType[]{V});
        this.mySignatures.add(this.myPointerTypeVariable);
        this.myComplexTypeVariable = new RelationSignature("ComplexTypeVariable", new DomainType[]{V});
        this.mySignatures.add(this.myComplexTypeVariable);
        this.myCallStatement = new RelationSignature("CallStatement", new DomainType[]{S, M});
        this.mySignatures.add(this.myCallStatement);
        this.myExternalCallStatement = new RelationSignature("ExternalCallStatement", new DomainType[]{S});
        this.mySignatures.add(this.myExternalCallStatement);
        this.myReturnVarStatement = new RelationSignature("ReturnVarStatement", new DomainType[]{S, V, M});
        this.mySignatures.add(this.myReturnVarStatement);
        this.myReturnConstStatement = new RelationSignature("ReturnConstStatement", new DomainType[]{S, C, M});
        this.mySignatures.add(this.myReturnConstStatement);
        this.myExitStatement = new RelationSignature("ExitStatement", new DomainType[]{S, M});
        this.mySignatures.add(this.myExitStatement);
        this.myVarArgument = new RelationSignature("VarArgument", new DomainType[]{S, M, N, V});
        this.mySignatures.add(this.myVarArgument);
        this.myConstArgument = new RelationSignature("ConstArgument", new DomainType[]{S, M, N, C});
        this.mySignatures.add(this.myConstArgument);
        this.myParameter = new RelationSignature("Parameter", new DomainType[]{M, N, V});
        this.mySignatures.add(this.myParameter);
        this.myPrivateMethod = new RelationSignature("PrivateMethod", new DomainType[]{M});
        this.mySignatures.add(this.myPrivateMethod);
        this.myPrivateField = new RelationSignature("PrivateField", new DomainType[]{V});
        this.mySignatures.add(this.myPrivateField);
        this.myMethodReturnType = new RelationSignature("MethodReturnType", new DomainType[]{M, T});
        this.mySignatures.add(this.myMethodReturnType);
    }

    public RelationSignature[] getOutputRelations() {
        return this.mySignatures.toArray(new RelationSignature[0]);
    }

    @Nullable
    public OCControlFlowGraph getControlFlowGraph(@NotNull OCCallable callable) {
        return this.myGraphs.get(callable);
    }

    @NotNull
    public Collection<OCControlFlowGraph> getAllControlFlowGraphs() {
        return this.myGraphs.values();
    }

    @Nullable
    public OCElementsRange getRange(@NotNull OCCallable callable, int nodeIndex) {
        return this.myRangesMap.containsKey(callable) ? this.myRangesMap.get(callable).get(nodeIndex) : null;
    }

    @NotNull
    private Attribute getAttribute(@NotNull String name, @Nullable PsiElement element, @Nullable String domainTypeName) {
        int srcPos = element != null ? element.getTextRange().getStartOffset() : 0;
        int srcLength = element != null ? element.getTextLength() : 0;
        String path = element != null ? element.getContainingFile().getVirtualFile().getPath() : "";
        DomainType domainType = domainTypeName != null ? this.mySymbolTable.getDomainType(domainTypeName) : null;
        return new Attribute(name, domainType, path, srcPos, srcLength, new PrettyName(name));
    }

    @NotNull
    private Attribute getPsiElementAttribute(@NotNull PsiElement element) {
        return this.getAttribute(element.getClass() + ":" + element.getTextOffset() + ":" + element.getTextLength(), element, null);
    }

    @NotNull
    private Attribute getIntegerAttribute(int num) {
        return this.getAttribute(String.valueOf(num), null, "Integer");
    }

    @NotNull
    private Attribute getContextAttribute(int context) {
        return this.getAttribute(String.valueOf(context), null, "BigInteger");
    }

    @NotNull
    private Attribute getConstantAttribute(@NotNull OCExpression expression, @NotNull OCType targetType) {
        return this.getConstantAttribute(OCExpressionEvaluator.evaluate(expression, targetType), expression);
    }

    @NotNull
    private Attribute getConstantAttribute(@NotNull OCExpression expression) {
        return this.getConstantAttribute(OCExpressionEvaluator.evaluate(expression), expression);
    }

    @NotNull
    private Attribute getUnknownConstAttribute() {
        return this.getAttribute("unknown const", null, null);
    }

    @NotNull
    private Attribute getUnknownExpressionAttribute() {
        return this.getAttribute("unknown expression " + this.myUniqueUnknownExpressionAttributeId++, null, null);
    }

    @NotNull
    private Attribute getConstantAttribute(@NotNull Number constant, @Nullable PsiElement element) {
        return this.getAttribute(String.valueOf(constant), element, "Constant");
    }

    @NotNull
    private Attribute getTypeAttribute(@NotNull OCType type, @NotNull PsiElement context) {
        OCResolveContext resolveContext = OCResolveContext.forPsi(context);
        return this.getAttribute(type.resolve(resolveContext).getCanonicalName(resolveContext), null, "Type");
    }

    @NotNull
    private Attribute getUnknownSubtypeAttribute(@NotNull OCType type, @NotNull PsiElement context) {
        OCResolveContext resolveContext = OCResolveContext.forPsi(context);
        return this.getAttribute("Unknown subtype of " + type.resolve(resolveContext).getCanonicalName(resolveContext), null, "Type");
    }

    @NotNull
    private Attribute getSymbolAttribute(@NotNull OCSymbol symbol, @NotNull String domainType) {
        PsiElement element = symbol.locateDefinition(this.getProject());
        element = symbol instanceof OCFunctionSymbol && element != null ? element.getParent() : element;
        return this.getAttribute(symbol.getName() + ":" + symbol.getComplexOffset(), element, domainType);
    }

    @NotNull
    private Attribute getVariableAttribute(@NotNull OCSymbol symbol) {
        return this.getSymbolAttribute(symbol, "Variable");
    }

    @NotNull
    private Attribute getCallableAttribute(@NotNull OCSymbol symbol) {
        return this.getSymbolAttribute(symbol, "Method");
    }

    @NotNull
    private Attribute getVariableAttribute(PsiElement expression) {
        OCReferenceElement element = ((OCReferenceExpression)expression).getReferenceElement();
        LOG.assertTrue(element != null);
        OCSymbol symbol = element.resolveToSymbol();
        LOG.assertTrue(symbol != null);
        return this.getVariableAttribute(symbol);
    }

    @Override
    @Contract(value="null -> false")
    protected boolean isSymbolInScope(@Nullable OCSymbol symbol) {
        return OCDFAUtils.isLocalVariable(symbol, this.myGraph) || this.myPrivateFields.contains(symbol);
    }

    @Contract(value="null -> false")
    protected boolean isSymbolInScope(@Nullable OCExpression operand) {
        if (operand instanceof OCReferenceExpression && ((OCReferenceExpression)operand).getSelfSuperToken() == null) {
            OCReferenceElement element = ((OCReferenceExpression)operand).getReferenceElement();
            return this.isSymbolInScope(element != null ? element.resolveToSymbol() : null);
        }
        return false;
    }

    public void processCallable(@NotNull OCCallable callable, @NotNull Map options, ThreadCallback threadCallback) {
        OCSymbol symbol = callable.getSymbol();
        this.myThreadCallback = threadCallback;
        if (symbol != null && callable.getBody() != null) {
            this.init(new OCControlFlowGraph(callable, null));
            this.myContextSensitivity = !OCDFAUtils.hasGotos(callable) && options.get(CONTEXT_SENSITIVITY) != Boolean.FALSE;
            this.myGlobalAnalysis = options.get(GLOBAL_ANALYSIS) == Boolean.TRUE;
            this.myFile = callable.getContainingFile();
            this.myResolveContext = OCResolveContext.forPsi(callable);
            Pair<Set<PsiElement>, OCControlFlowGraph> pair = OCDFAUtils.getNotUsedWrites(callable);
            this.myNotUsedWrites = (Set)pair.getFirst();
            this.myGraphs.put(callable, (OCControlFlowGraph)pair.getSecond());
            this.myVariableWrites = new MultiMap();
            this.myStatementContexts.clear();
            this.myCallableAttribute = this.getCallableAttribute(symbol);
            if (this.myGlobalAnalysis) {
                this.processReturnType(callable);
                this.processParameters(symbol);
                this.processPrivateFields(symbol);
            }
            this.processFirstCodeFragment(callable);
            this.addContextInfos();
            this.processDeadEnds();
        }
    }

    private void processReturnType(OCCallable callable) {
        OCType returnType = this.simplifyType(callable.getReturnType().resolve(this.myResolveContext));
        Attribute typeAttr = this.getTypeAttribute(returnType, callable);
        this.myConsumer.addTuple(this.myMethodReturnType, this.myCallableAttribute, typeAttr);
        this.processType(returnType);
    }

    private void processParameters(OCSymbol callableSymbol) {
        boolean isPrivateCallable = OCDFAUtils.isPrivateCallable(callableSymbol, this.getProject());
        if (isPrivateCallable) {
            this.myConsumer.addTuple(this.myPrivateMethod, this.myCallableAttribute);
        }
        List<OCDeclaratorSymbol> parameterSymbols = null;
        if (callableSymbol instanceof OCFunctionSymbol) {
            parameterSymbols = ((OCFunctionSymbol)callableSymbol).getParameterSymbols();
        } else if (callableSymbol instanceof OCMethodSymbol) {
            parameterSymbols = ((OCMethodSymbol)callableSymbol).getParameterSymbols();
        }
        if (parameterSymbols != null) {
            for (int i = 0; i < parameterSymbols.size(); ++i) {
                OCDeclaratorSymbol parameter = parameterSymbols.get(i);
                if (parameter == null) continue;
                this.myConsumer.addTuple(this.myParameter, this.myCallableAttribute, this.getIntegerAttribute(i + 1), this.getVariableAttribute(parameter));
                if (!isPrivateCallable) continue;
                this.myPrivateParameters.add(parameter);
            }
        }
    }

    @NotNull
    private Project getProject() {
        return this.myResolveContext.getProject();
    }

    protected void processDeadEnds() {
        new OCUnreachableCodeFinder(this.myGraph){

            @Override
            protected void processDeadEnd(@NotNull OCNode node) {
                Collection contexts = OCContextSensitiveControlFlowBuilder.this.myStatementContexts.get((Object)node);
                for (Integer context : contexts) {
                    OCContextSensitiveControlFlowBuilder.this.myConsumer.addTuple(OCContextSensitiveControlFlowBuilder.this.myExitStatement, OCContextSensitiveControlFlowBuilder.this.getContextAttribute(context), OCContextSensitiveControlFlowBuilder.this.myCallableAttribute);
                }
            }
        }.process();
    }

    private void processPrivateFields(OCSymbol callableSymbol) {
        OCSymbol parent = null;
        if (callableSymbol instanceof OCMethodSymbol) {
            parent = ((OCSymbolWithParent)callableSymbol).getParent();
        } else if (callableSymbol instanceof OCFunctionSymbol) {
            parent = ((OCFunctionSymbol)callableSymbol).getResolvedOwner(this.myResolveContext);
        }
        if (parent instanceof OCImplementationSymbol) {
            OCType type = parent.getResolvedType(this.myResolveContext);
            if (type instanceof OCObjectType) {
                ((OCObjectType)type).processMembers(OCInstanceVariableSymbol.class, symbol -> {
                    if (symbol.getVisibility().compareTo(OCVisibility.PROTECTED) >= 0) {
                        this.myConsumer.addTuple(this.myPrivateField, this.getVariableAttribute((OCSymbol)symbol));
                        this.myPrivateFields.add((OCSymbol)symbol);
                        this.processDeclarator(symbol.getResolvedType(this.myResolveContext), (OCSymbol)symbol, (PsiElement)this.myFile);
                    }
                    return true;
                });
            }
        } else if (parent instanceof OCStructSymbol) {
            ((OCStructSymbol)parent).processFields((Processor<? super OCDeclaratorSymbol>)((Processor)symbol -> {
                if (symbol.getVisibility() == OCVisibility.PRIVATE && !symbol.isFriendOrStatic()) {
                    this.myConsumer.addTuple(this.myPrivateField, this.getVariableAttribute((OCSymbol)symbol));
                    this.myPrivateFields.add((OCSymbol)symbol);
                    this.processDeclarator(symbol.getResolvedType(this.myResolveContext), (OCSymbol)symbol, (PsiElement)this.myFile);
                }
                return true;
            }));
        }
    }

    private void processDeclarator(@NotNull OCType type, @NotNull OCSymbol symbol, @NotNull PsiElement context) {
        Attribute typeAttribute = this.getTypeAttribute(type, context);
        this.processType(type);
        this.myConsumer.addTuple(this.myVariableType, this.getVariableAttribute(symbol), typeAttribute);
        this.myConsumer.addTuple(this.myExpressionType, this.getPsiElementAttribute(context), typeAttribute);
        this.processVariableType(type, symbol);
    }

    private void processVariableType(@NotNull OCType type, @NotNull OCSymbol symbol) {
        Attribute attribute = this.getVariableAttribute(symbol);
        if (type instanceof OCCppReferenceType) {
            type = ((OCCppReferenceType)type).getRefType();
        }
        if (type instanceof OCPointerType && !(type instanceof OCArrayType)) {
            this.myConsumer.addTuple(this.myPointerTypeVariable, attribute);
        } else if (type instanceof OCRealType || type instanceof OCMagicType || type instanceof OCStructType && ((OCStructType)type).getKind() == OCSymbolKind.STRUCT || type instanceof OCArrayType) {
            this.myConsumer.addTuple(this.myComplexTypeVariable, attribute);
        }
    }

    @Override
    public void visitDeclarator(OCDeclarator declarator) {
        super.visitDeclarator(declarator);
        OCSymbol symbol = declarator.getSymbol();
        PsiElement identifier = declarator.getNameIdentifier();
        if (this.isSymbolInScope(symbol) && identifier != null) {
            this.processDeclarator(this.simplifyType(declarator.getResolvedType()), symbol, identifier);
        }
    }

    @Override
    public void visitMethodSelectorPart(OCMethodSelectorPart part) {
        super.visitMethodSelectorPart(part);
        OCDeclaratorSymbol symbol = (OCDeclaratorSymbol)part.getSymbol();
        PsiElement identifier = part.getNameIdentifier();
        if (this.isSymbolInScope(symbol) && identifier != null) {
            this.processDeclarator(this.simplifyType(part.getType().resolve((PsiElement)this.myFile)), symbol, identifier);
        }
    }

    @Override
    protected void processNonInitializedDeclarator(@NotNull OCSymbol symbol, @Nullable PsiElement lValue) {
        super.processNonInitializedDeclarator(symbol, lValue);
        if (this.myPrivateParameters.contains(symbol)) {
            return;
        }
        Attribute varAttribute = this.getVariableAttribute(symbol);
        this.myVariableWrites.putValue((Object)this.myGraph.getLastAddedNode(), (Object)varAttribute);
        if (lValue != null) {
            Attribute constAttr = this.getConstantAttribute(OCNumber.valueOf(0L), null);
            this.myConsumer.addTuple(this.myConstantType, constAttr, this.getAttribute(constAttr.getKey(), lValue, "Object"), this.getTypeAttribute(symbol.getResolvedType(this.myResolveContext), lValue));
            if (OCCompilerFeaturesHelper.isArcEnabled(this.myFile) && symbol.getKind() == OCSymbolKind.LOCAL_VARIABLE && symbol.getResolvedType(this.myResolveContext).isPointerToObjectCompatible()) {
                this.addStatement(this.myAssignmentToConstant, varAttribute, constAttr);
            } else {
                this.addStatement(this.myNonInitializedDeclarator, varAttribute, this.getPsiElementAttribute(lValue));
            }
        }
    }

    @Override
    protected void addStartNode(@NotNull OCNode node) {
        super.addStartNode(node);
        this.myStatementContexts.putValue((Object)node, (Object)this.myCurContext);
        this.myConsumer.addTuple(this.myStartNode, this.myCallableAttribute, this.getContextAttribute(this.myCurContext));
        ++this.myCurContext;
    }

    private void addStatement(@NotNull RelationSignature relation, Attribute ... attrs) {
        OCNode node;
        if (this.myThreadCallback != null) {
            this.myThreadCallback.checkCancelled();
        }
        if (this.myFakeNodes.contains(node = this.myGraph.getLastAddedNode())) {
            this.myFakeNodeAttributes.putValue((Object)node, (Object)Pair.create((Object)relation, (Object)attrs));
        } else {
            Collection contexts = this.myStatementContexts.get((Object)node);
            for (Integer context : contexts) {
                if (this.myThreadCallback != null) {
                    this.myThreadCallback.checkCancelled();
                }
                this.myConsumer.addTuple(relation, (Attribute[])ArrayUtil.mergeArrays((Object[])new Attribute[]{this.getContextAttribute(context)}, (Object[])attrs));
            }
        }
    }

    private boolean needSplitContexts(@Nullable List<PsiElement> modifiedValues) {
        return modifiedValues == null || this.myContextSensitivity && OCDFAUtils.areValuesUsed(modifiedValues, this.myNotUsedWrites);
    }

    @Override
    @NotNull
    protected MyNodeState addBranch(@NotNull OCNode fromNode, @NotNull OCNode toNode, @Nullable List<PsiElement> modifiedValues, @Nullable OCControlFlowBuilder.NodeState oldFromState) {
        super.addBranch(fromNode, toNode, modifiedValues, oldFromState);
        this.addJump(new OCConditionsList.Conditions(null, null, this.myUnconditionalJump, new Attribute[0]), fromNode, toNode, this.needSplitContexts(modifiedValues) && oldFromState == null, false, (MyNodeState)oldFromState);
        return new MyNodeState(toNode);
    }

    @Override
    @Nullable
    protected OCControlFlowBuilder.NodeState addUnstructuralBranch(@NotNull OCNode fromNode, @NotNull OCNode toNode) {
        super.addUnstructuralBranch(fromNode, toNode);
        this.addJump(new OCConditionsList.Conditions(null, null, this.myUnconditionalJump, new Attribute[0]), fromNode, toNode, false, true, null);
        return new MyNodeState(toNode);
    }

    @Override
    protected OCNode getLoopBodyEndNode() {
        OCNode bodyEndNode = super.getLoopBodyEndNode();
        if (this.myStatementContexts.containsKey((Object)bodyEndNode)) {
            return bodyEndNode;
        }
        for (OCNode node : this.myContinueNodes) {
            if (!this.myStatementContexts.containsKey((Object)node)) continue;
            return node;
        }
        return bodyEndNode;
    }

    private void splitNode() {
        if (this.myGraph.isSplitNodesAllowed()) {
            OCNode prevNode = this.myGraph.getLastAddedNode();
            this.addBranch(prevNode, this.myGraph.addNode());
        }
    }

    @Override
    @NotNull
    protected MyNodeState addConditionalBranch(@NotNull OCElement condition, boolean branch, @NotNull OCNode fromNode, @NotNull OCNode toNode, @Nullable List<PsiElement> modifiedValues, @Nullable OCControlFlowBuilder.NodeState oldFromState) {
        super.addBranch(fromNode, toNode, modifiedValues, oldFromState);
        boolean splitContexts = this.needSplitContexts(modifiedValues) && oldFromState == null;
        OCConditionsList conditionsList = branch ? this.myBranchConditions.get(condition).getTrueConditions() : this.myBranchConditions.get(condition).getFalseConditions();
        for (OCConditionsList.Conditions conditions : conditionsList.getConditions()) {
            this.addJump(conditions, fromNode, toNode, splitContexts, false, (MyNodeState)oldFromState);
        }
        return new MyNodeState(toNode);
    }

    private void processType(@NotNull OCType type) {
        if (this.myThreadCallback != null) {
            this.myThreadCallback.checkCancelled();
        }
        Attribute typeAttribute = this.getTypeAttribute(type, (PsiElement)this.myFile);
        this.myConsumer.addTuple(this.myConstantType, this.getUnknownConstAttribute(), this.getUnknownConstAttribute(), typeAttribute);
        this.myConsumer.addTuple(this.myExpressionType, this.getUnknownExpressionAttribute(), typeAttribute);
        if (OCDFAUtils.processTypeHierarchy(type, (PsiElement)this.myFile, this.myProcessedTypes, (Processor<? super Pair<OCType, OCType>>)((Processor)pair -> {
            OCType superType = (OCType)pair.getSecond();
            if (superType != null) {
                this.myConsumer.addTuple(this.mySubType, this.getTypeAttribute((OCType)pair.getFirst(), (PsiElement)this.myFile), this.getTypeAttribute(superType, (PsiElement)this.myFile));
            }
            return true;
        }))) {
            this.myConsumer.addTuple(this.myUnknownSubType, this.getUnknownSubtypeAttribute(type, (PsiElement)this.myFile), typeAttribute);
        } else {
            this.myConsumer.addTuple(this.myPODType, typeAttribute);
        }
    }

    @NotNull
    private OCType simplifyType(@NotNull OCType type) {
        OCObjectType objectType;
        while (type instanceof OCCppReferenceType) {
            type = ((OCCppReferenceType)type).getRefType();
        }
        if (type.isPointerToObject() && !(objectType = (OCObjectType)type.getTerminalType()).getAllProtocols().isEmpty()) {
            type = type.isPointerToID() ? OCIdType.pointerToID() : OCPointerType.to(new OCObjectType(objectType.getInterface(), objectType.getSuperType()));
        }
        return type.cloneWithoutConstModifier(this.getProject());
    }

    private void addJump(@NotNull OCConditionsList.Conditions conditions, @NotNull OCNode fromNode, @NotNull OCNode toNode, boolean splitContexts, boolean unstructural, @Nullable MyNodeState oldFromState) {
        int fromStartContext;
        if (this.myThreadCallback != null) {
            this.myThreadCallback.checkCancelled();
        }
        List fromContexts = (List)this.myStatementContexts.get((Object)fromNode);
        List<Integer> toContexts = (List<Integer>)this.myStatementContexts.get((Object)toNode);
        int n = fromStartContext = oldFromState != null ? oldFromState.myContextsCnt : 0;
        if (!splitContexts && !fromContexts.isEmpty() && toContexts.isEmpty()) {
            this.myStatementContexts.putValue((Object)toNode, (Object)this.myCurContext);
            toContexts = Collections.singletonList(this.myCurContext);
            ++this.myCurContext;
        }
        for (int i = fromStartContext; i < fromContexts.size(); ++i) {
            int toContext;
            if (this.myThreadCallback != null) {
                this.myThreadCallback.checkCancelled();
            }
            int fromContext = (Integer)fromContexts.get(i);
            if (unstructural) {
                for (int toContext2 : toContexts) {
                    this.addJump(conditions, fromNode, toNode, fromContext, toContext2);
                }
                continue;
            }
            if (splitContexts && fromNode != toNode) {
                ++this.myCurContext;
                this.myStatementContexts.putValue((Object)toNode, (Object)toContext);
                if (this.myCurContext >= 1000000) {
                    throw new OCDFAUtils.DFAException("Too many DFA contexts used: " + this.myCurContext);
                }
            } else {
                int index = (i - fromStartContext) * toContexts.size() / (fromContexts.size() - fromStartContext);
                if (index < 0 || index >= toContexts.size()) {
                    throw new OCDFAUtils.DFAException("Too many DFA contexts used: " + this.myCurContext);
                }
                toContext = toContexts.get(index);
            }
            this.addJump(conditions, fromNode, toNode, fromContext, toContext);
        }
    }

    private void addJump(@NotNull OCConditionsList.Conditions conditions, @NotNull OCNode fromNode, @NotNull OCNode toNode, int fromContext, int toContext) {
        List<OCConditionsList.Condition> list = conditions.getConditions();
        int nextContext = fromContext;
        OCNode nextNode = fromNode;
        for (int j = 0; j < list.size(); ++j) {
            int n;
            if (this.myThreadCallback != null) {
                this.myThreadCallback.checkCancelled();
            }
            OCConditionsList.Condition condition = list.get(j);
            OCNode fakeNode = condition.getFakeNode();
            if (j < list.size() - 1) {
                int n2 = this.myCurContext;
                n = n2;
                this.myCurContext = n2 + 1;
            } else {
                n = toContext;
            }
            int tempContext = n;
            OCNode tempNode = j < list.size() - 1 ? fakeNode : toNode;
            this.addTuplesForJump(nextContext, tempContext, condition);
            if (tempNode != null) {
                this.myConsumer.addTuple(this.myNodeJump, this.myCallableAttribute, this.getContextAttribute(this.getNodeId(nextNode, nextContext)), this.getContextAttribute(this.getNodeId(tempNode, tempContext)));
            }
            nextContext = tempContext;
            nextNode = tempNode;
            if (fakeNode == null || conditions.getSkipEvaluationIndices() != null && conditions.getSkipEvaluationIndices().contains(j + 1)) continue;
            this.myStatementContexts.putValue((Object)fakeNode, (Object)nextContext);
            for (Pair pair : this.myFakeNodeAttributes.get((Object)fakeNode)) {
                this.myConsumer.addTuple((RelationSignature)pair.getFirst(), (Attribute[])ArrayUtil.mergeArrays((Object[])new Attribute[]{this.getContextAttribute(nextContext)}, (Object[])((Attribute[])pair.getSecond())));
            }
        }
    }

    private int getNodeId(@NotNull OCNode node, int context) {
        if (node.isFake()) {
            if (this.myFakeContexts.containsKey(context)) {
                return this.myFakeContexts.get(context);
            }
            int id = this.myGraph.getNextNodeId();
            this.myFakeContexts.put(context, id);
            return id;
        }
        return node.getId();
    }

    private void addTuplesForJump(int fromContext, int toContext, @NotNull OCConditionsList.Condition condition) {
        this.myConsumer.addTuple(condition.getRelation(), (Attribute[])ArrayUtil.mergeArrays((Object[])new Attribute[]{this.getContextAttribute(fromContext), this.getContextAttribute(toContext)}, (Object[])condition.getAttributes()));
        for (OCConditionsList.BranchInfo branch : condition.getBranches()) {
            RelationSignature relation = branch.isTrueBranch() ? this.myConditionThenBranch : this.myConditionElseBranch;
            Attribute conditionAttr = this.getPsiElementAttribute((PsiElement)(branch.getCondition() != null ? branch.getCondition() : this.myFile));
            this.myConsumer.addTuple(relation, (Attribute[])ArrayUtil.mergeArrays((Object[])new Attribute[]{this.getContextAttribute(toContext)}, (Object[])new Attribute[]{conditionAttr}));
            if (!branch.isCanBeShortCutted()) continue;
            this.myConsumer.addTuple(this.myShortCuttedBranch, conditionAttr);
        }
    }

    @Override
    protected OCNode acceptCondition(@Nullable OCElement condition, @NotNull OCControlFlowBuilder.KidIterator itr, boolean isLoop) {
        itr.skip(condition);
        itr.skipLeaves();
        if (!isLoop) {
            this.splitNode();
        }
        OCNode node = this.myGraph.getLastAddedNode();
        this.myGraph.forbidSplittingNodes();
        this.myBranchConditions.put(condition, this.doHandleConditionalBranch(condition));
        this.myGraph.allowSplittingNodes();
        this.removeFakeNodes(node);
        return node;
    }

    @Override
    protected void addCaseStatement(@NotNull OCCaseStatement stmt, @NotNull OCNode caseNode, @NotNull OCControlFlowBuilder.SwitchInfo info) {
        OCNode node = this.myGraph.getLastAddedNode();
        BranchConditions conditions = null;
        OCExpression caseExpression = stmt.getExpression();
        info.addCaseExpression(caseExpression);
        OCElement conditionElement = null;
        if (stmt.isDefault()) {
            OCConditionsList unconditional = OCConditionsList.singleton(null, null, this.myUnconditionalJump, new Attribute[0]);
            conditions = new BranchConditions(unconditional, unconditional);
            conditionElement = stmt;
            for (OCExpression expression : info.getCaseExpressions()) {
                BranchConditions conds = this.addEquality(info.getExpression(), expression, expression, false, false);
                OCConditionsList.BranchInfo branch = new OCConditionsList.BranchInfo(null, false, false);
                if (conds == null) continue;
                conditions = new BranchConditions(conditions.getTrueConditions().combine(conds.getFalseConditions(), branch), conditions.getFalseConditions());
            }
            conditions.getTrueConditions().clearBranches();
        } else if (caseExpression != null) {
            conditions = this.addEquality(info.getExpression(), caseExpression, caseExpression, false, false);
            conditionElement = caseExpression;
        }
        if (conditions != null) {
            this.removeFakeNodes(node);
            this.myBranchConditions.put(conditionElement, conditions);
            this.addConditionalBranch(conditionElement, true, info.getNode(), caseNode);
        } else {
            super.addCaseStatement(stmt, caseNode, info);
        }
    }

    private void removeFakeNodes(OCNode node) {
        while (this.myGraph.getLastAddedNode() != node) {
            this.myGraph.removeNode(this.myGraph.getLastAddedNode(), true);
        }
    }

    @Nullable
    private static BranchConditions negate(@Nullable BranchConditions conditions) {
        return conditions != null ? new BranchConditions(conditions.getFalseConditions(), conditions.getTrueConditions()) : null;
    }

    @NotNull
    private BranchConditions doHandleConditionalBranch(@Nullable OCElement condition) {
        return this.doHandleConditionalBranch(condition, condition, false, false);
    }

    @NotNull
    private BranchConditions doHandleConditionalBranch(@Nullable OCElement cuttedCondition, @Nullable OCElement uncuttedCondition, boolean negate, boolean canBeShortCutted) {
        BranchConditions result = null;
        OCConditionsList.BranchInfo trueBranch = new OCConditionsList.BranchInfo(uncuttedCondition, true, canBeShortCutted);
        OCConditionsList.BranchInfo falseBranch = new OCConditionsList.BranchInfo(uncuttedCondition, false, canBeShortCutted);
        if ((cuttedCondition = OCContextSensitiveControlFlowBuilder.diveIntoParenthesesAndCasts(cuttedCondition)) instanceof OCCondition) {
            OCCondition condition = (OCCondition)cuttedCondition;
            cuttedCondition = condition.getExpression();
            result = this.doHandleConditionalBranch(cuttedCondition, uncuttedCondition, negate, canBeShortCutted);
        } else if (cuttedCondition instanceof OCUnaryExpression && ((OCUnaryExpression)cuttedCondition).getOperationSign() == OCTokenTypes.EXCL) {
            OCUnaryExpression unaryExpression = (OCUnaryExpression)cuttedCondition;
            result = OCContextSensitiveControlFlowBuilder.negate(this.doHandleConditionalBranch(unaryExpression.getOperand(), uncuttedCondition, !negate, canBeShortCutted));
        } else if (cuttedCondition instanceof OCBinaryExpression) {
            OCBinaryExpression binary = (OCBinaryExpression)cuttedCondition;
            OCElementType sign = binary.getOperationSign();
            if (sign == OCTokenTypes.ANDAND || sign == OCTokenTypes.OROR || sign == OCTokenTypes.XOR) {
                BranchConditions left = this.doHandleConditionalBranch(binary.getLeft(), binary.getLeft(), false, canBeShortCutted);
                BranchConditions right = this.doHandleConditionalBranch(binary.getRight(), binary.getRight(), false, true);
                OCConditionsList a = left.getTrueConditions();
                OCConditionsList notA = left.getFalseConditions();
                OCConditionsList b = right.getTrueConditions();
                OCConditionsList notB = right.getFalseConditions();
                if (sign == OCTokenTypes.ANDAND) {
                    result = new BranchConditions(a.combine(b, trueBranch), a.combine(notB, falseBranch).merge(notA.skipEvaluation(falseBranch)));
                } else if (sign == OCTokenTypes.OROR) {
                    result = new BranchConditions(notA.combine(b, trueBranch).merge(a.skipEvaluation(trueBranch)), notA.combine(notB, falseBranch));
                } else if (sign == OCTokenTypes.XOR) {
                    result = new BranchConditions(notA.combine(b, trueBranch).merge(a.combine(notB, trueBranch)), notA.combine(notB, falseBranch).merge(a.combine(b, falseBranch)));
                }
            } else {
                ++this.myVisitorRecursiveCnt;
                cuttedCondition.accept(this);
                --this.myVisitorRecursiveCnt;
                if (sign == OCTokenTypes.EQEQ) {
                    result = this.addEquality(binary.getLeft(), binary.getRight(), uncuttedCondition, negate, canBeShortCutted);
                } else if (sign == OCTokenTypes.EXCLEQ) {
                    result = OCContextSensitiveControlFlowBuilder.negate(this.addEquality(binary.getLeft(), binary.getRight(), uncuttedCondition, !negate, canBeShortCutted));
                }
            }
        } else if (cuttedCondition != null) {
            OCDFAUtils.InstanceOf instanceOf;
            OCAssignmentExpression assignmentExpression;
            ++this.myVisitorRecursiveCnt;
            cuttedCondition.accept(this);
            --this.myVisitorRecursiveCnt;
            Attribute attribute = null;
            if (cuttedCondition instanceof OCAssignmentExpression && (assignmentExpression = (OCAssignmentExpression)cuttedCondition).getOperationSign() == OCTokenTypes.EQ) {
                attribute = this.getExpressionAttribute(assignmentExpression.getReceiverExpression());
            }
            if (attribute == null) {
                attribute = this.getExpressionAttribute(cuttedCondition);
            }
            if (attribute != null) {
                result = OCContextSensitiveControlFlowBuilder.negate(this.addEqualityToConst(cuttedCondition, attribute, this.getConstantAttribute(OCNumber.valueOf(0L), null), !negate, canBeShortCutted, OCIntType.BOOL, uncuttedCondition));
            } else if (cuttedCondition instanceof OCExpression && (instanceOf = OCDFAUtils.getInstanceofPair((OCExpression)cuttedCondition)) != null && this.isSymbolInScope(instanceOf.symbol)) {
                OCNode node = this.addFakeNode();
                Attribute varAttribute = this.getVariableAttribute(instanceOf.symbol);
                Attribute typeAttribute = this.getTypeAttribute(this.simplifyType(instanceOf.type), (PsiElement)this.myFile);
                result = OCContextSensitiveControlFlowBuilder.getBranchConditions(uncuttedCondition, negate, canBeShortCutted, node, this.myInstanceOfConditionalJump, this.myNonInstanceOfConditionalJump, varAttribute, typeAttribute);
                this.addModifiedValue(instanceOf.variable);
                this.processType(instanceOf.type);
            }
        }
        if (result != null) {
            return result;
        }
        OCConditionsList singleton = OCConditionsList.singleton(null, null, this.myUnconditionalJump, new Attribute[0]);
        return new BranchConditions(singleton, singleton);
    }

    @Override
    protected boolean doEnlargeNodes() {
        return this.myVisitorRecursiveCnt == 0;
    }

    @Nullable
    private BranchConditions addEquality(@Nullable OCExpression left, @Nullable OCExpression right, @Nullable OCElement condition, boolean negate, boolean canBeShortCutted) {
        left = OCContextSensitiveControlFlowBuilder.diveIntoParenthesesAndCasts(left);
        right = OCContextSensitiveControlFlowBuilder.diveIntoParenthesesAndCasts(right);
        Attribute leftAttr = this.getExpressionAttribute(left);
        Attribute rightAttr = this.getExpressionAttribute(right);
        if (OCDFAUtils.isConstant(left) && rightAttr != null) {
            return this.addEqualityToConst(right, rightAttr, this.getConstantAttribute(left), negate, canBeShortCutted, this.simplifyType(left.getResolvedType().getGuessedType()), condition);
        }
        if (OCDFAUtils.isConstant(right) && leftAttr != null) {
            return this.addEqualityToConst(left, leftAttr, this.getConstantAttribute(right), negate, canBeShortCutted, this.simplifyType(right.getResolvedType().getGuessedType()), condition);
        }
        if (leftAttr != null && rightAttr != null) {
            OCNode node = this.addFakeNode();
            return OCContextSensitiveControlFlowBuilder.getBranchConditions(condition, negate, canBeShortCutted, node, this.myEqualityToVarConditionalJump, this.myNonEqualityToVarConditionalJump, leftAttr, rightAttr);
        }
        return null;
    }

    private BranchConditions addEqualityToConst(@NotNull OCElement expression, @NotNull Attribute exprAttr, @NotNull Attribute constAttr, boolean negate, boolean canBeShortCutted, @NotNull OCType constType, @Nullable OCElement condition) {
        if (constAttr.getKey().equals("0") && expression instanceof OCReferenceExpression) {
            this.addModifiedValue(expression);
        }
        this.myConsumer.addTuple(this.myConstantType, constAttr, this.getAttribute(constAttr.getKey(), null, "Object"), this.getTypeAttribute(constType, expression));
        this.processType(constType);
        OCNode node = this.addFakeNode();
        return OCContextSensitiveControlFlowBuilder.getBranchConditions(condition, negate, canBeShortCutted, node, this.myEqualityToConstConditionalJump, this.myNonEqualityToConstConditionalJump, exprAttr, constAttr);
    }

    @Contract(value="null -> null")
    @Nullable
    private Attribute getExpressionAttribute(@Nullable PsiElement expression) {
        if (expression instanceof OCExpression) {
            OCSymbol callSymbol;
            if (this.isSymbolInScope((OCExpression)expression)) {
                return this.getVariableAttribute(expression);
            }
            if (this.myGlobalAnalysis && (callSymbol = OCDFAUtils.getCallSymbol(expression)) != null) {
                Attribute attribute = this.getPsiElementAttribute(expression);
                this.addStatement(this.myAssignmentToCall, attribute, this.getCallableAttribute(callSymbol));
                OCType type = this.simplifyType(((OCExpression)expression).getResolvedType().getGuessedType());
                Attribute typeAttribute = this.getTypeAttribute(type, expression);
                this.myConsumer.addTuple(this.myVariableType, attribute, typeAttribute);
                this.splitNode();
                return attribute;
            }
        }
        return null;
    }

    @NotNull
    private OCNode addFakeNode() {
        OCNode node = this.myGraph.addNode(true);
        this.myFakeNodes.add(node);
        return node;
    }

    private static BranchConditions getBranchConditions(@Nullable OCElement condition, boolean negate, boolean canBeShortCutted, @Nullable OCNode node, @NotNull RelationSignature trueRelation, @NotNull RelationSignature falseRelation, Attribute ... attributes) {
        return new BranchConditions(OCConditionsList.singleton(new OCConditionsList.BranchInfo(condition, !negate, canBeShortCutted), node, trueRelation, attributes), OCConditionsList.singleton(new OCConditionsList.BranchInfo(condition, negate, canBeShortCutted), node, falseRelation, attributes));
    }

    @Override
    protected void processAssignment(@NotNull OCSymbol symbol, @Nullable PsiElement lValue, @Nullable OCExpression rValue, boolean complexAssignment, boolean shortCircuitEvaluation) {
        super.processAssignment(symbol, lValue, rValue, complexAssignment, shortCircuitEvaluation);
        Attribute left = null;
        rValue = OCContextSensitiveControlFlowBuilder.diveIntoParenthesesAndCasts(rValue);
        if (this.isSymbolInScope(symbol)) {
            left = this.getVariableAttribute(symbol);
        }
        if (left != null) {
            Collection writes = this.myVariableWrites.get((Object)this.myGraph.getLastAddedNode());
            if (writes.contains(left) || this.isSymbolInScope(rValue) && writes.contains(this.getVariableAttribute(rValue))) {
                this.splitNode();
            }
            this.myVariableWrites.putValue((Object)this.myGraph.getLastAddedNode(), (Object)left);
            Attribute expressionAttr = null;
            Attribute constAttr = null;
            if (rValue == null) {
                this.addStatement(this.myAssignmentToExpression, left, this.getUnknownExpressionAttribute());
            } else if (complexAssignment) {
                expressionAttr = this.getPsiElementAttribute(rValue);
                this.addStatement(this.myAssignmentToExpression, left, expressionAttr);
            } else if (OCDFAUtils.isConstant(rValue)) {
                constAttr = this.getConstantAttribute(rValue, symbol.getResolvedType(this.myResolveContext));
                this.addStatement(this.myAssignmentToConstant, left, constAttr);
            } else if (rValue instanceof OCCppNewExpression && !((OCCppNewExpression)rValue).isNoThrow()) {
                constAttr = this.getPsiElementAttribute(rValue);
                this.addStatement(this.myAssignmentToConstant, left, constAttr);
            } else if (this.isSymbolInScope(rValue)) {
                this.addStatement(this.myAssignmentToVar, left, this.getVariableAttribute(rValue));
            } else if (this.myGlobalAnalysis) {
                Attribute callableAttr;
                OCSymbol callSymbol = OCDFAUtils.getCallSymbol(rValue);
                Attribute attribute = callableAttr = callSymbol != null ? this.getCallableAttribute(callSymbol) : null;
                if (callableAttr != null) {
                    this.addStatement(this.myAssignmentToCall, left, callableAttr);
                } else {
                    expressionAttr = this.getPsiElementAttribute(rValue);
                    this.addStatement(this.myAssignmentToExpression, left, expressionAttr);
                }
            } else {
                expressionAttr = this.getPsiElementAttribute(rValue);
                this.addStatement(this.myAssignmentToExpression, left, expressionAttr);
            }
            if (expressionAttr != null || constAttr != null) {
                OCType type = this.simplifyType(rValue.getResolvedType().getGuessedType());
                if (expressionAttr != null) {
                    this.myConsumer.addTuple(this.myExpressionType, expressionAttr, this.getTypeAttribute(type, rValue));
                } else {
                    this.myConsumer.addTuple(this.myConstantType, constAttr, this.getAttribute(constAttr.getKey(), rValue, "Object"), this.getTypeAttribute(type, rValue));
                }
                this.processType(type);
            }
        }
    }

    @Override
    public void visitCastExpression(OCCastExpression expression) {
        super.visitCastExpression(expression);
        OCExpression operand = expression.getOperand();
        if (this.isSymbolInScope(operand)) {
            OCType type = this.simplifyType(expression.getCastType().resolve(OCResolveContext.forPsi(expression)));
            Attribute variable = this.getVariableAttribute(operand);
            if (this.myVariableWrites.get((Object)this.myGraph.getLastAddedNode()).contains(variable)) {
                this.splitNode();
            }
            this.addStatement(this.myCastExpression, variable, this.getTypeAttribute(type, expression), this.getPsiElementAttribute(expression));
            this.processType(type);
        }
    }

    private void doProcessReference(@NotNull OCSymbol symbol) {
        OCSymbolKind symbolKind = symbol.getKind();
        if (symbolKind.isLocal()) {
            Attribute variable = this.getVariableAttribute(symbol);
            if (this.myVariableWrites.get((Object)this.myGraph.getLastAddedNode()).contains(variable)) {
                this.splitNode();
            }
            this.myVariableWrites.putValue((Object)this.myGraph.getLastAddedNode(), (Object)variable);
            this.addStatement(this.myGetReferenceExpression, variable);
        }
    }

    @Override
    protected void processReference(@NotNull PsiElement element, @NotNull OCSymbol symbol) {
        super.processReference(element, symbol);
        this.doProcessReference(symbol);
    }

    @Override
    protected void processReferenceFromBlock(@NotNull OCSymbol symbol) {
        super.processReferenceFromBlock(symbol);
        this.doProcessReference(symbol);
    }

    @Override
    protected void processDereference(@NotNull OCReferenceExpression expression) {
        super.processDereference(expression);
        if (this.isSymbolInScope(expression)) {
            Attribute variable = this.getVariableAttribute(expression);
            if (this.myVariableWrites.get((Object)this.myGraph.getLastAddedNode()).contains(variable)) {
                this.splitNode();
            }
            this.addStatement(this.myDereferenceExpression, variable, this.getPsiElementAttribute(expression));
        }
    }

    @Override
    public void visitCallExpression(OCCallExpression expression) {
        if (this.myGlobalAnalysis) {
            OCExpression funExpr = expression.getFunctionReferenceExpression();
            OCExpression receiver = null;
            OCSymbol function = null;
            if (funExpr instanceof OCReferenceExpression) {
                function = ((OCReferenceExpression)funExpr).resolveToSymbol();
            } else if (funExpr instanceof OCQualifiedExpression) {
                function = ((OCQualifiedExpression)funExpr).resolveToSymbol();
                receiver = ((OCQualifiedExpression)funExpr).getQualifier();
            }
            this.processCall(function, receiver, expression.getArguments());
        }
        super.visitCallExpression(expression);
    }

    @Override
    public void visitSendMessageExpression(OCSendMessageExpression expression) {
        OCExpression receiver = OCParenthesesUtils.diveIntoParenthesesAndCasts(expression.getReceiverExpression());
        if (this.myGlobalAnalysis) {
            this.processCall(expression.getProbableResponders().getKnownResponder(), expression.getReceiverExpression(), expression.getArgumentExpressions());
        }
        if (receiver != null && this.isSymbolInScope(receiver)) {
            OCSendMessageExpression.ProbableResponders responders = expression.getProbableResponders();
            Attribute variable = this.getVariableAttribute(receiver);
            if (this.myVariableWrites.get((Object)this.myGraph.getLastAddedNode()).contains(variable)) {
                this.splitNode();
            }
            this.addStatement(this.myMessageReceiverExpression, variable, this.getPsiElementAttribute(receiver));
            if (responders.getKnownResponder() == null && !responders.getAllResponders().isEmpty()) {
                for (OCMethodSymbol method : responders.getAllResponders()) {
                    OCType type = this.simplifyType(OCPointerType.to(method.getParent().getResolvedType(this.myResolveContext)));
                    this.addStatement(this.myDynamicCallExpression, variable, this.getTypeAttribute(type, expression), this.getPsiElementAttribute(expression));
                    this.processType(type);
                }
            }
        }
        super.visitSendMessageExpression(expression);
    }

    private void processCall(@Nullable OCSymbol callable, @Nullable OCExpression receiver, @NotNull List<OCExpression> arguments) {
        if (OCDFAUtils.isGoodCallable(this.myFile, callable)) {
            this.splitNode();
            Attribute callableAttr = this.getCallableAttribute(callable);
            Attribute attribute = this.getExpressionAttribute(receiver);
            this.addStatement(this.myCallStatement, callableAttr);
            if (attribute != null) {
                this.addStatement(this.myVarArgument, callableAttr, this.getIntegerAttribute(0), attribute);
            } else if (OCDFAUtils.isConstant(receiver)) {
                this.addStatement(this.myConstArgument, callableAttr, this.getIntegerAttribute(0), this.getConstantAttribute(receiver));
            }
            for (int i = 0; i < arguments.size(); ++i) {
                OCExpression argument = arguments.get(i);
                attribute = this.getExpressionAttribute(argument);
                if (attribute != null) {
                    this.addStatement(this.myVarArgument, callableAttr, this.getIntegerAttribute(i + 1), attribute);
                    continue;
                }
                if (!OCDFAUtils.isConstant(argument)) continue;
                this.addStatement(this.myConstArgument, callableAttr, this.getIntegerAttribute(i + 1), this.getConstantAttribute(argument));
            }
        } else {
            this.addStatement(this.myExternalCallStatement, new Attribute[0]);
        }
    }

    private static OCElement diveIntoParenthesesAndCasts(@Nullable OCElement element) {
        if (element instanceof OCExpression) {
            return OCContextSensitiveControlFlowBuilder.diveIntoParenthesesAndCasts((OCExpression)element);
        }
        return element;
    }

    private static OCExpression diveIntoParenthesesAndCasts(@Nullable OCExpression expression) {
        OCCastKind[] acceptableCasts = (OCCastKind[])ArrayUtil.remove((Object[])OCCastKind.values(), (Object)((Object)OCCastKind.DYNAMIC_CAST));
        return OCParenthesesUtils.diveIntoParenthesesAndCasts(expression, acceptableCasts);
    }

    @Override
    public void visitReturnStatement(OCReturnStatement stmt) {
        if (this.myGlobalAnalysis) {
            OCSymbol callableSymbol;
            OCExpression expression = stmt.getExpression();
            Attribute attribute = this.getExpressionAttribute(expression);
            OCCallable callable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)stmt, OCCallable.class);
            OCSymbol oCSymbol = callableSymbol = callable != null ? callable.getSymbol() : null;
            if (callableSymbol != null) {
                Attribute callableAttr = this.getCallableAttribute(callableSymbol);
                this.addStatement(this.myExitStatement, callableAttr);
                if (attribute != null) {
                    this.addStatement(this.myReturnVarStatement, attribute, callableAttr);
                } else if (OCDFAUtils.isConstant(expression)) {
                    this.addStatement(this.myReturnConstStatement, this.getConstantAttribute(expression), callableAttr);
                }
            }
        }
        super.visitReturnStatement(stmt);
    }

    public void addContextInfos() {
        OCCallable callable = (OCCallable)this.myGraph.getCodeFragment();
        Document document = PsiDocumentManager.getInstance((Project)callable.getProject()).getDocument(callable.getContainingFile());
        HashMap<Integer, OCElementsRange> map2 = new HashMap<Integer, OCElementsRange>();
        this.myRangesMap.put(callable, map2);
        if (document != null) {
            for (OCNode node : this.myStatementContexts.keySet()) {
                OCElementsRange range = node.getRange();
                if (range != null && !node.isFake()) {
                    map2.put(node.getId(), range);
                }
                Iterator iterator = this.myStatementContexts.get((Object)node).iterator();
                while (iterator.hasNext()) {
                    int context = (Integer)iterator.next();
                    if (this.myThreadCallback != null) {
                        this.myThreadCallback.checkCancelled();
                    }
                    this.myConsumer.addTuple(this.myContextInfo, this.myCallableAttribute, this.getContextAttribute(this.getNodeId(node, context)), this.getContextAttribute(context));
                }
            }
        }
    }

    static class BranchConditions {
        OCConditionsList myTrueConditions;
        OCConditionsList myFalseConditions;

        BranchConditions(@NotNull OCConditionsList trueConditions, @NotNull OCConditionsList falseConditions) {
            this.myTrueConditions = trueConditions;
            this.myFalseConditions = falseConditions;
        }

        @NotNull
        OCConditionsList getTrueConditions() {
            return this.myTrueConditions;
        }

        @NotNull
        OCConditionsList getFalseConditions() {
            return this.myFalseConditions;
        }
    }

    private final class MyNodeState
    implements OCControlFlowBuilder.NodeState {
        private final int myContextsCnt;

        private MyNodeState(OCNode node) {
            this.myContextsCnt = OCContextSensitiveControlFlowBuilder.this.myStatementContexts.get((Object)node).size();
        }
    }

    @FunctionalInterface
    public static interface TuplesConsumer {
        public void addTuple(RelationSignature var1, Attribute ... var2);
    }
}

