/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.legacy.daemon;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorSink;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorSinkWrapper;
import com.jetbrains.cidr.lang.legacy.symbols.OCVisibility;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCStructuredBindingDeclaration;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTextIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveElementsIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCStructuredBindingType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCStructuredBindingUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCStructuredBindingChecker
extends OCAnnotatorSinkWrapper {
    public OCStructuredBindingChecker(@NotNull OCAnnotatorSink impl) {
        super(impl);
    }

    public void checkStructuredBindingDeclaration(@NotNull OCStructuredBindingDeclaration declaration) {
        List<OCDeclarator> declarators;
        OCElement initializer;
        this.checkContext(declaration);
        this.checkDeclarationSpecifiers(declaration);
        OCTypeElement typeElement = declaration.getTypeElement();
        if (typeElement != null) {
            this.checkDeclarationSpecifiers(typeElement);
            this.checkTypeSpecifier(typeElement);
        }
        if ((initializer = declaration.getBindingDeclarator().getInitializer()) != null && this.checkInitializer(declaration, initializer) && (declarators = declaration.getDeclarators()).size() > 0) {
            OCType initializerType;
            OCResolveContext context = OCResolveContext.forPsi(declaration);
            OCType declaratorType = declarators.get(0).getType();
            if (declaratorType instanceof OCStructuredBindingType && (initializerType = OCStructuredBindingUtil.resolveInitializerType((OCStructuredBindingType)declaratorType, context)) != null) {
                this.checkStructuredBindingType(declaration, initializer, initializerType, context);
            }
        }
    }

    private void checkContext(@NotNull OCStructuredBindingDeclaration declaration) {
        PsiElement parent = declaration.getParent().getParent();
        if (parent instanceof OCCondition) {
            this.addErrorAnnotation(declaration, "err_decomp_decl_context", "Structured binding not allowed here");
        }
    }

    private void checkDeclarationSpecifiers(@NotNull OCElement element) {
        ASTNode[] specifiers;
        for (ASTNode specifier : specifiers = element.getNode().getChildren(OCTokenTypes.DECLARATION_SPECIFIERS_IN_TYPES)) {
            PsiElement specifierElement = specifier.getPsi();
            String text = specifierElement.getText();
            Annotation annotation = this.addErrorAnnotation(specifierElement, "err_decomp_decl_spec", "Structured binding cannot be declared with '" + text + "'");
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction(specifierElement, OCInspectionsBundle.message("intention.family.name.remove", text)));
        }
    }

    private void checkTypeSpecifier(@NotNull OCTypeElement typeElement) {
        OCType type = typeElement.getType();
        if (!(type instanceof OCAutoType)) {
            Annotation annotation = this.addErrorAnnotation(typeElement, "err_decomp_decl_type", "Structured binding must be declared with 'auto'");
            String text = typeElement.getTextWithMacros();
            this.registerQuickFix(annotation, new OCChangeTextIntentionAction(typeElement.getContainingOCFile(), typeElement.getTextOffset(), text.length(), "auto", OCInspectionsBundle.message("intention.family.name.change.type.to.auto", text)));
        }
    }

    private boolean checkInitializer(@NotNull OCStructuredBindingDeclaration declaration, @NotNull OCElement initializer) {
        List<OCExpression> expressions = null;
        if (initializer instanceof OCCompoundInitializer) {
            if (declaration.getBindingDeclarator().hasEqualsInitializer()) {
                this.addErrorAnnotation(initializer, "CIDR", "Structured binding does not allow initializer list after '='");
                return false;
            }
            expressions = ((OCCompoundInitializer)initializer).getInitializerExpressions();
        } else if (initializer instanceof OCArgumentList) {
            expressions = ((OCArgumentList)initializer).getArguments();
        }
        if (expressions != null) {
            if (expressions.size() == 0) {
                this.addErrorAnnotation(initializer, "err_auto_var_init_no_expression", "Structured binding initializer cannot be empty");
                return false;
            }
            if (expressions.size() > 1) {
                this.addErrorAnnotation(initializer, "err_auto_var_init_multiple_expressions", "Structured binding initializer requires exactly one element");
                return false;
            }
        }
        return true;
    }

    private void checkStructuredBindingType(@NotNull OCStructuredBindingDeclaration declaration, @NotNull OCElement initializer, @NotNull OCType type, @NotNull OCResolveContext context) {
        if (type instanceof OCCppReferenceType) {
            type = ((OCCppReferenceType)type).getRefType();
        }
        if (type instanceof OCArrayType) {
            this.checkArraySize(declaration, initializer, (OCArrayType)type, context);
        } else if (type instanceof OCStructType && ((OCStructType)type).getKind() == OCSymbolKind.STRUCT) {
            OCStructType classType = (OCStructType)type;
            OCStructSymbol tupleSizeSymbol = OCStructuredBindingUtil.getTupleSizeSymbol(classType, context, declaration.getContainingOCFile());
            if (tupleSizeSymbol != null) {
                this.checkTupleLikeType(declaration, initializer, type, tupleSizeSymbol, context);
            } else {
                this.checkNonUnionClassType(declaration, initializer, classType, context);
            }
        } else if (!(type instanceof OCMagicType) && !type.isUnresolved(context)) {
            this.addErrorAnnotation(initializer, "err_decomp_decl_unbindable_type", "'" + type.getName() + "' is not an array or non-union class type");
        }
    }

    private void checkNonUnionClassType(@NotNull OCStructuredBindingDeclaration declaration, @NotNull OCElement initializer, @NotNull OCStructType classType, @NotNull OCResolveContext context) {
        OCStructuredBindingUtil.MemberCollector memberCollector = new OCStructuredBindingUtil.MemberCollector();
        classType.processMembers(null, memberCollector, context);
        List<OCStructSymbol> baseClassesWithNonStaticMembers = memberCollector.getBaseClassesWithNonStaticMembers();
        if (this.checkBaseClasses(initializer, classType, baseClassesWithNonStaticMembers)) {
            this.checkMembers(declaration, initializer, classType, memberCollector);
        }
    }

    private void checkMembers(@NotNull OCStructuredBindingDeclaration declaration, @NotNull OCElement initializer, @NotNull OCStructType classType, @NotNull OCStructuredBindingUtil.MemberCollector memberCollector) {
        int expectedSize;
        if (memberCollector.hasAnonymousUnionMember()) {
            this.addErrorAnnotation(initializer, "err_decomp_decl_anon_union_member", "Cannot bind to type '" + classType.getName() + "': found anonymous union member");
            return;
        }
        OCSymbol[] members = memberCollector.getMembers();
        int size = members.length;
        if (size != (expectedSize = declaration.getBindingDeclarator().getBindingList().getNumberOfIdentifiers())) {
            this.addErrorAnnotation(initializer, "err_decomp_decl_wrong_number_bindings", String.format("'" + classType.getName() + "' has wrong number of non-static members: expected %d, got %d", expectedSize, size));
        } else {
            for (OCSymbol member : members) {
                OCVisibility.checkFieldVisibility(member, initializer, classType, this);
            }
        }
    }

    private boolean checkBaseClasses(@NotNull OCElement initializer, @NotNull OCStructType classType, @NotNull List<OCStructSymbol> baseClasses) {
        if (baseClasses.size() > 1) {
            if (baseClasses.get(0) == classType.getSymbol()) {
                this.addErrorAnnotation(initializer, "err_decomp_decl_multiple_bases_with_members", "Cannot bind to type '" + classType.getName() + "': both it and its base class '" + baseClasses.get(1).getName() + "' have non-static members");
                return false;
            }
            this.addErrorAnnotation(initializer, "err_decomp_decl_multiple_bases_with_members", "Cannot bind to type '" + classType.getName() + "': its base classes '" + baseClasses.get(0).getName() + "' and '" + baseClasses.get(1).getName() + "' have non-static members");
            return false;
        }
        return true;
    }

    private void checkTupleLikeType(@NotNull OCStructuredBindingDeclaration declaration, @NotNull OCElement initializer, @NotNull OCType type, @NotNull OCStructSymbol tupleSizeSymbol, @NotNull OCResolveContext context) {
        OCDeclaratorSymbol tupleSizeValueSymbol = OCStructuredBindingUtil.getTupleSizeValueSymbol(tupleSizeSymbol, context);
        if (tupleSizeValueSymbol == null || !(tupleSizeValueSymbol.getResolvedType(context) instanceof OCIntType)) {
            this.addErrorAnnotation(initializer, "err_decomp_decl_std_tuple_size_not_constant", "std::tuple_size<" + type.getName() + ">::value is not a valid integral constant expression");
        } else {
            int expectedSize;
            int size;
            Object resolvedValue = OCExpressionEvaluator.evaluate((OCSymbol)tupleSizeValueSymbol, context);
            if (resolvedValue instanceof Number && (size = ((Number)resolvedValue).intValue()) != (expectedSize = declaration.getBindingDeclarator().getBindingList().getNumberOfIdentifiers())) {
                this.addErrorAnnotation(initializer, "err_decomp_decl_wrong_number_bindings", String.format("std::tuple_size<" + type.getName() + ">::value does not match: expected %d, got %d", expectedSize, size));
            }
        }
    }

    private void checkArraySize(@NotNull OCStructuredBindingDeclaration declaration, @NotNull OCElement initializer, @NotNull OCArrayType arrayType, @NotNull OCResolveContext context) {
        int expectedSize;
        int size = arrayType.getLength(context);
        if (size >= 0 && size != (expectedSize = declaration.getBindingDeclarator().getBindingList().getNumberOfIdentifiers())) {
            this.addErrorAnnotation(initializer, "err_decomp_decl_wrong_number_bindings", String.format("Array size does not match: expected %d, got %d", expectedSize, size));
        }
    }
}

