/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.legacy.daemon;

import com.intellij.lang.annotation.Annotation;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.daemon.OCGetSymbolVisitor;
import com.jetbrains.cidr.lang.daemon.OCLegacyAnnotator;
import com.jetbrains.cidr.lang.daemon.OCObjCAnnotator;
import com.jetbrains.cidr.lang.editor.colors.OCHighlightingKeys;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTextIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTypeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCConvertLiteralIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCConvertTypeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCInsertCastIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveElementsIntentionAction;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCFunctionGroupSymbol;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import com.jetbrains.cidr.lang.util.OCFormatSpecifiersUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class OCFormatStringsAnnotator
extends OCLegacyAnnotator {
    @Override
    public void visitCallExpression(@NotNull OCCallExpression expr) {
        OCExpression function = OCParenthesesUtils.diveIntoParentheses(expr.getFunctionReferenceExpression());
        if (function != null) {
            OCResolveContext context = OCResolveContext.forPsi(expr);
            OCGetSymbolVisitor visitor = new OCGetSymbolVisitor(context);
            function.accept(visitor);
            OCSymbol symbol = visitor.getSymbol();
            if (!(symbol instanceof OCFunctionSymbol)) {
                return;
            }
            if (symbol instanceof OCFunctionGroupSymbol && (symbol = (OCSymbol)ContainerUtil.getOnlyItem(((OCFunctionGroupSymbol)symbol).getOverloads())) == null) {
                return;
            }
            List<OCExpression> arguments = expr.getArguments();
            this.checkFormatSpecifiers(symbol, arguments, OCArgumentsList.getArgumentList(arguments, context).getTypes(), context);
        }
    }

    @Override
    public void visitSendMessageExpression(@NotNull OCSendMessageExpression expr) {
        OCMethodSymbol target;
        OCSendMessageExpression.ProbableResponders responders = expr.getProbableResponders();
        if (!expr.getArguments().isEmpty() && !responders.isStaticnessMismatch() && (target = OCObjCAnnotator.findTargetMethod(expr, responders.getFilteredByStaticnessResponders())) != null) {
            OCResolveContext context = OCResolveContext.forPsi(expr);
            List types = ContainerUtil.mapNotNull(expr.getArguments(), argument -> {
                OCExpression argExpr = argument.getArgumentExpression();
                if (argExpr == null) {
                    return null;
                }
                return argExpr.getResolvedType(context).getGuessedType();
            });
            this.checkFormatSpecifiers(target, expr.getArgumentExpressions(), types, context);
        }
    }

    public void checkFormatSpecifiers(@NotNull OCSymbol callable, @NotNull List<OCExpression> arguments, @NotNull List<OCType> argumentTypes, @NotNull OCResolveContext context) {
        Pair<OCFormatSpecifiersUtil.FormatSpecifiersInfo, List<OCFormatSpecifiersUtil.SpecifierUsage>> formatInfo = OCFormatSpecifiersUtil.getFormatSpecifiersInfo(callable, arguments);
        if (formatInfo == null) {
            return;
        }
        List formatStringSpecifiers = (List)formatInfo.second;
        for (OCFormatSpecifiersUtil.SpecifierUsage specifier : formatStringSpecifiers) {
            TextRange specifierRange = specifier.getRange();
            if (specifierRange == null) continue;
            this.highlight(specifierRange, specifier.getType());
        }
        OCFormatSpecifiersUtil.FormatSpecifiersInfo formatSpecifiersInfo = (OCFormatSpecifiersUtil.FormatSpecifiersInfo)formatInfo.first;
        if (!formatSpecifiersInfo.formatType.needArgumentsCheck() || formatSpecifiersInfo.argumentsIndex < 0 || formatSpecifiersInfo.formatStringIndex < 0) {
            return;
        }
        OCExpression formatStringArgument = arguments.get(formatSpecifiersInfo.formatStringIndex);
        int argIndex = formatSpecifiersInfo.argumentsIndex;
        boolean skipNext = false;
        for (OCFormatSpecifiersUtil.SpecifierUsage specifier : formatStringSpecifiers) {
            TextRange specifierRange = specifier.getRange();
            if (specifier.getType() == OCHighlightingKeys.OC_VALID_STRING_ESCAPE) continue;
            if (specifier.getType() == OCHighlightingKeys.OC_INVALID_STRING_ESCAPE) {
                this.addWarningAnnotation(formatStringArgument, specifierRange, OCInspections.FormatSpecifiers.class, "warn_printf_incomplete_specifier", "Unknown, incomplete or optional format specifier", null);
                ++argIndex;
                continue;
            }
            @NonNls String existingSpecifierName = specifier.getName();
            if (formatSpecifiersInfo.formatType == OCFormatSpecifiersUtil.FormatType.SCANF && existingSpecifierName.equals("*")) {
                skipNext = true;
                continue;
            }
            if (skipNext) {
                skipNext = false;
                continue;
            }
            if ((formatSpecifiersInfo.formatType == OCFormatSpecifiersUtil.FormatType.PRINTF || formatSpecifiersInfo.formatType == OCFormatSpecifiersUtil.FormatType.PRINTF_MSVC || formatSpecifiersInfo.formatType == OCFormatSpecifiersUtil.FormatType.NSSTRING) && existingSpecifierName.equals("%m")) {
                this.addWarningAnnotation(formatStringArgument, specifierRange, OCInspections.FormatSpecifiers.class, "CIDR", "Format specifier '" + existingSpecifierName + "' is a Glibc extension", null);
                continue;
            }
            if (argIndex >= arguments.size()) {
                OCType expectedType = formatSpecifiersInfo.formatType.resolveType(existingSpecifierName, context);
                String expectedArgType = expectedType == null ? "" : expectedType.getName(context);
                this.addWarningAnnotation(formatStringArgument, specifierRange, OCInspections.FormatSpecifiers.class, "warn_printf_data_arg_not_used", "Argument missing: format specifier '" + existingSpecifierName + "' requires '" + expectedArgType + "' argument", null);
                continue;
            }
            OCExpression argument = arguments.get(argIndex);
            OCType argType = argumentTypes.get(argIndex);
            assert (argument != null);
            OCFormatSpecifiersUtil.FormatType formatType = formatSpecifiersInfo.formatType;
            String actualArgumentSpecifierName = formatType.getSpecifierForType(argType, argument);
            OCType expectedType = formatType.resolveType(existingSpecifierName, OCResolveContext.forPsi(argument));
            if (actualArgumentSpecifierName != null && expectedType != null && !formatType.isCompatible(expectedType, argType, existingSpecifierName, actualArgumentSpecifierName, argument)) {
                String message = "Format specifier '" + existingSpecifierName + "' requires '" + expectedType.getName(argument) + "' argument instead of '" + argType.getName(argument) + "'";
                if (!actualArgumentSpecifierName.equals("<pointer type required>") && specifierRange != null) {
                    Annotation formatAnnotation = this.addWarningAnnotation(formatStringArgument, specifierRange, OCInspections.FormatSpecifiers.class, "warn_format_conversion_argument_type_mismatch", message, null);
                    this.registerQuickFix(formatAnnotation, new OCChangeTextIntentionAction(argument.getContainingFile(), specifierRange.getStartOffset(), specifierRange.getLength(), actualArgumentSpecifierName, OCInspectionsBundle.message("intention.name.change.format.specifier", actualArgumentSpecifierName), OCInspectionsBundle.message("quick.fix.change.format.specifier", new Object[0])));
                }
                Annotation argAnnotation = this.addWarningAnnotation(argument, OCInspections.FormatSpecifiers.class, "warn_format_conversion_argument_type_mismatch", message);
                if (!existingSpecifierName.equals("%@")) {
                    if (formatType != OCFormatSpecifiersUtil.FormatType.SCANF) {
                        this.registerQuickFix(argAnnotation, new OCInsertCastIntentionAction(argument, expectedType));
                    }
                    if (!expectedType.isPointer()) {
                        OCChangeTypeIntentionAction.registerChangeTypeFix(argument, expectedType, argAnnotation, this);
                    }
                }
                this.registerQuickFix(argAnnotation, new OCConvertTypeIntentionAction(argument, expectedType));
                OCExpression inner = OCParenthesesUtils.diveIntoParentheses(argument);
                if (inner != null) {
                    this.registerQuickFix(argAnnotation, new OCConvertLiteralIntentionAction(inner, expectedType, argType));
                }
            }
            ++argIndex;
        }
        if (argIndex < arguments.size()) {
            OCExpression argument = arguments.get(argIndex);
            OCExpression argumentLast = arguments.get(arguments.size() - 1);
            int requiredVarargs = argIndex - formatSpecifiersInfo.argumentsIndex;
            int hasVarargs = arguments.size() - formatSpecifiersInfo.argumentsIndex;
            Annotation annotation = this.addWarningAnnotation(argument.getParent(), new OCElementsRange(argument, argumentLast).getTextRange(), OCInspections.FormatSpecifiers.class, "warn_printf_insufficient_data_args", "Too many arguments: format string requires " + requiredVarargs + ", but has " + hasVarargs + StringUtil.pluralize((String)" argument", (int)hasVarargs), null);
            String intentionName = OCInspectionsBundle.message("quick.fix.remove.arguments", new Object[0]);
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction(arguments.subList(argIndex, arguments.size()), intentionName, intentionName));
        }
    }
}

