/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.legacy.daemon;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorSink;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorSinkWrapper;
import com.jetbrains.cidr.lang.daemon.OCConstantExpressionVisitor;
import com.jetbrains.cidr.lang.daemon.clang.OCClangMessageFinder;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.legacy.daemon.OCCppChecker;
import com.jetbrains.cidr.lang.legacy.quickfixes.OCCreateFunctionPredeclarationIntentionAction;
import com.jetbrains.cidr.lang.legacy.quickfixes.OCGenerateConstructorFix;
import com.jetbrains.cidr.lang.legacy.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.legacy.types.OCTypeCheckResult;
import com.jetbrains.cidr.lang.legacy.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCConceptPlaceholderType;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCLoopStatement;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCReference;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSizeofExpression;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCStructuredBindingDeclaration;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.quickfixes.OCAddInitializerIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCAddTypeModifierIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeARCAttributeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeMethodStaticnessIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangePropertyAttributeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTextIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTypeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.quickfixes.OCMoveDefinitionIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveDeclarationButInitializerIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveDeclarationIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveElementsIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveTypeModifierIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRenameSymbolIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCReuseDeclarationIntentionAction;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.ComplexTextRange;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolBase;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCArrayToPointerChanger;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDeclaratorChecker
extends OCAnnotatorSinkWrapper {
    @NotNull
    private final OCCppChecker myCppChecker;

    public OCDeclaratorChecker(@NotNull OCAnnotatorSink impl, @NotNull OCCppChecker checker) {
        super(impl);
        this.myCppChecker = checker;
    }

    public boolean checkDuplicates(@NotNull PsiNameIdentifierOwner element) {
        return this.checkDuplicates(OCElementUtil.getSymbolName((PsiElement)element), (PsiElement)element, Collections.singletonList(element.getNameIdentifier()));
    }

    public boolean checkDuplicates(String symbolName, PsiElement contextOwner, List<? extends PsiElement> navigationElements) {
        return this.checkDuplicates(symbolName, null, contextOwner, navigationElements);
    }

    public boolean checkDuplicates(String symbolName, OCSymbol declaratorSymbol, @NotNull PsiElement contextOwner, List<? extends PsiElement> navigationElements) {
        if (symbolName == null) {
            return true;
        }
        OCResolveContext resolveContext = OCResolveContext.forPsi(contextOwner);
        List<OCSymbol> result = OCSymbolReference.getLocalReference(symbolName, contextOwner).resolveToSymbols(false, false, resolveContext);
        result.sort(Comparator.comparingLong(s -> ((OCSymbol)s).getComplexOffset()).reversed());
        if (declaratorSymbol == null) {
            for (OCSymbol symbol : result) {
                if (symbol.getComplexOffset() != OCSymbolOffsetUtil.getVirtualComplexOffset(contextOwner) || !Comparing.equal((Object)symbol.getContainingFile(), (Object)contextOwner.getContainingFile().getVirtualFile())) continue;
                declaratorSymbol = symbol;
                break;
            }
        }
        if (declaratorSymbol == null) {
            return true;
        }
        OCType declaratorType = declaratorSymbol.getType();
        OCSymbolKind declaratorKind = declaratorSymbol.getKind();
        for (OCSymbol symbol : result) {
            String message;
            OCSymbolKind symbolKind;
            if (symbol.equals(declaratorSymbol) || (symbolKind = symbol.getKind()).isStructLike() != declaratorKind.isStructLike()) continue;
            if (symbolKind == OCSymbolKind.UNDEF_MACRO) break;
            List<Annotation> annotations = null;
            List<Object> quickFixes = Collections.emptyList();
            if (OCResolveUtil.isDuplicate(symbol, declaratorSymbol, contextOwner.getProject())) {
                VirtualFile symbolFile = symbol.getContainingFile();
                Object previousFile = "";
                if (symbolFile != null && !symbolFile.equals(contextOwner.getContainingFile().getVirtualFile())) {
                    previousFile = " in '" + symbolFile.getName() + "'";
                }
                if (symbolKind.isStructLike() && declaratorKind.isStructLike() && symbolKind != declaratorKind) {
                    message = "Duplicate declaration of tag '" + OCSymbolBase.getTagOfStructLike(declaratorSymbol) + "' with different type";
                    annotations = this.addErrorAnnotations(navigationElements, OCInspections.DuplicateDeclarations.class, "err_use_with_wrong_tag", message);
                } else if (OCDeclaratorChecker.cantBeDuplicated(declaratorSymbol, contextOwner) && OCDeclaratorChecker.cantBeDuplicated(symbol, contextOwner)) {
                    boolean symbolIsTypedef;
                    boolean declaratorIsTypedef = declaratorKind == OCSymbolKind.TYPEDEF;
                    boolean bl = symbolIsTypedef = symbolKind == OCSymbolKind.TYPEDEF;
                    if (declaratorIsTypedef && symbolIsTypedef || declaratorIsTypedef && symbolKind.isStructLike() || symbolIsTypedef && declaratorKind.isStructLike()) {
                        String symbolCanonicalName;
                        String declaratorCanonicalName = declaratorIsTypedef ? declaratorSymbol.getResolvedType(resolveContext).getCanonicalName(resolveContext) : declaratorSymbol.getName();
                        String string = symbolCanonicalName = symbolIsTypedef ? symbol.getResolvedType(resolveContext).getCanonicalName(resolveContext) : symbol.getName();
                        if (!symbolCanonicalName.equals(declaratorCanonicalName)) {
                            annotations = this.addErrorAnnotations(navigationElements, OCInspections.DuplicateDeclarations.class, "err_use_of_tag_name_without_tag", "Typedef redefinition with different types");
                        }
                    } else {
                        String message2 = "Duplicate declaration of " + declaratorSymbol.getNameWithKindLowercase(resolveContext) + (String)(!((String)previousFile).isEmpty() ? "; previous one was" + (String)previousFile : "");
                        annotations = symbol instanceof OCClassSymbol && ((OCClassSymbol)symbol).getCategoryName() != null ? this.addWarningAnnotations(navigationElements, OCInspections.DuplicateDeclarations.class, "warn_dup_category_def", message2) : (symbol instanceof OCMacroSymbol ? this.addWarningAnnotations(navigationElements, OCInspections.HidesUpperScope.class, "err_redefinition", message2) : this.addErrorAnnotations(navigationElements, OCInspections.DuplicateDeclarations.class, "err_redefinition", message2));
                    }
                } else {
                    Object message3;
                    boolean checkConst;
                    OCType type = symbol.getType().resolve(resolveContext);
                    String subject = "all declarations of '" + declaratorSymbol.getName() + "'";
                    boolean bl = checkConst = !(type instanceof OCArrayType) || ((OCArrayType)type).hasLength() || !(declaratorType instanceof OCArrayType) || !(symbol instanceof OCDeclaratorSymbol) || !((OCDeclaratorSymbol)symbol).isExtern();
                    if (symbol instanceof OCTemplateSymbol && ((OCTemplateSymbol)symbol).isExplicitInstantiation() && declaratorSymbol instanceof OCTemplateSymbol && ((OCTemplateSymbol)declaratorSymbol).isExplicitInstantiation()) {
                        message3 = OCBundle.message("inspections.duplicate.explicitInstantiation", new Object[0]);
                        annotations = this.addErrorAnnotations(navigationElements, OCInspections.DuplicateDeclarations.class, "err_explicit_instantiation_duplicate", (String)message3);
                    }
                    if (symbol instanceof OCClassSymbol != declaratorSymbol instanceof OCClassSymbol) {
                        message3 = declaratorSymbol.getNameWithKindUppercase(resolveContext) + " was redeclared with different kind of symbol, previous one was \"" + symbol.getKindUppercase(resolveContext) + "\"" + (String)previousFile;
                        annotations = this.addErrorAnnotations(navigationElements, OCInspections.DuplicateDeclarations.class, "err_redefinition_different_kind", (String)message3);
                    } else if (!(symbol instanceof OCStructSymbol || declaratorSymbol instanceof OCStructSymbol || new OCTypeEqualityAfterResolvingVisitor(type, false, true, false, true, resolveContext).equal(declaratorType, checkConst))) {
                        message3 = declaratorSymbol.getNameWithKindUppercase(resolveContext) + " was redeclared with different type '" + declaratorType.getName(resolveContext) + "'; previous was '" + type.getName(resolveContext) + "'" + (String)previousFile;
                        annotations = this.addErrorAnnotations(navigationElements, OCInspections.DuplicateDeclarations.class, "err_redefinition_different_type", (String)message3);
                        if (declaratorSymbol instanceof OCSymbolWithQualifiedName && symbol instanceof OCSymbolWithQualifiedName) {
                            quickFixes = Arrays.asList(new OCChangeTypeIntentionAction(declaratorSymbol, symbol.getType(), subject, (OCCompilationContext)resolveContext), new OCChangeTypeIntentionAction(declaratorSymbol, declaratorType, subject, (OCCompilationContext)resolveContext));
                        }
                    }
                }
            } else if (declaratorSymbol instanceof OCDeclaratorSymbol) {
                annotations = this.checkDeclaratorAlias(navigationElements, declaratorSymbol, symbol, contextOwner);
            } else if (contextOwner instanceof OCMethod && declaratorSymbol instanceof OCMethodSymbol && symbol instanceof OCMethodSymbol) {
                this.checkMethodAlias((OCMethod)contextOwner, (OCMethodSymbol)declaratorSymbol, (OCMethodSymbol)symbol);
            } else if (declaratorSymbol instanceof OCPropertySymbol && symbol instanceof OCPropertySymbol && ((OCPropertySymbol)declaratorSymbol).getParent() != ((OCPropertySymbol)symbol).getParent()) {
                this.checkPropertyAlias((OCDeclaration)contextOwner.getParent(), (OCPropertySymbol)declaratorSymbol, (OCPropertySymbol)symbol);
            } else if (declaratorSymbol instanceof OCPropertySymbol && symbol instanceof OCMethodSymbol && ((OCMethodSymbol)symbol).getGeneratedFromProperty() == null) {
                PsiElement definition = symbol.locateDefinition(contextOwner.getProject());
                final OCPropertySymbol property = (OCPropertySymbol)declaratorSymbol;
                CommonProcessors.FindFirstProcessor<OCMethodSymbol> finder = new CommonProcessors.FindFirstProcessor<OCMethodSymbol>(){

                    protected boolean accept(OCMethodSymbol accessor) {
                        return accessor.getGeneratedFromProperty() == property;
                    }
                };
                property.getParent().processMembers(symbol.getName(), OCMethodSymbol.class, finder);
                if (definition instanceof OCMethod && finder.isFound()) {
                    this.checkMethodAlias((OCMethod)definition, (OCMethodSymbol)symbol, (OCMethodSymbol)finder.getFoundValue());
                }
            } else if (declaratorSymbol instanceof OCInstanceVariableSymbol && symbol instanceof OCInstanceVariableSymbol) {
                OCInstanceVariableSymbol ivar = (OCInstanceVariableSymbol)symbol;
                OCInstanceVariableSymbol declaratorIvar = (OCInstanceVariableSymbol)declaratorSymbol;
                if (!ivar.isClang4ImplicitIvar(resolveContext.getFile()) && !ivar.getParent().isSameClass(declaratorIvar.getParent()) && ivar.getVisibility() != OCVisibility.PRIVATE) {
                    message = declaratorIvar.getNameWithKindUppercase(resolveContext) + " overrides " + ivar.getNameWithKindLowercase(resolveContext) + " in inherited " + ivar.getParent().getNameWithKindLowercase(resolveContext);
                    annotations = this.addErrorAnnotations(navigationElements, OCInspections.HidesUpperScope.class, "err_duplicate_member", message);
                }
            }
            for (IntentionAction quickFix : quickFixes) {
                this.registerQuickFixes(annotations, quickFix);
            }
            if (declaratorKind == OCSymbolKind.LOCAL_VARIABLE) {
                this.registerQuickFixes(annotations, new OCReuseDeclarationIntentionAction(declaratorSymbol, OCInspectionsBundle.message("intention.name.reuse.previous.declaration", symbol.getNameWithKindLowercase(resolveContext)), resolveContext.getProject()));
            } else {
                this.registerQuickFixes(annotations, new OCRemoveDeclarationIntentionAction(declaratorSymbol, resolveContext.getProject()));
                this.registerQuickFixes(annotations, new OCRemoveDeclarationButInitializerIntentionAction(declaratorSymbol, resolveContext.getProject()));
            }
            if (symbolKind != OCSymbolKind.PARAMETER) {
                this.registerQuickFixes(annotations, new OCRemoveDeclarationIntentionAction("previous declaration of", symbol, resolveContext.getProject()));
                this.registerQuickFixes(annotations, new OCRemoveDeclarationButInitializerIntentionAction("previous declaration of", symbol, resolveContext.getProject()));
            }
            if (annotations == null) continue;
            return false;
        }
        return true;
    }

    private static boolean cantBeDuplicated(OCSymbol symbol, PsiElement context) {
        return !symbol.isPredeclaration() || symbol instanceof OCMethodSymbol || symbol instanceof OCDeclaratorSymbol && !OCCodeInsightUtil.isInPlainOldC(context) && (!((OCDeclaratorSymbol)symbol).isExtern() || ((OCDeclaratorSymbol)symbol).getInitializer() != null) || (symbol instanceof OCFunctionSymbol && !((OCFunctionSymbol)symbol).isFriend() || symbol instanceof OCDeclaratorSymbol) && ((OCSymbolWithQualifiedName)symbol).getParent() instanceof OCStructSymbol;
    }

    @Nullable
    private List<Annotation> checkDeclaratorAlias(List<? extends PsiElement> navigationElements, OCSymbol declaratorSymbol, OCSymbol symbol, @NotNull PsiElement element) {
        List<Annotation> annotations = null;
        OCCompilationContext compilationContext = OCCompilationContext.create(element);
        if (symbol instanceof OCDeclaratorSymbol && declaratorSymbol.getKind() != OCSymbolKind.STRUCT_FIELD && declaratorSymbol.getKind() != OCSymbolKind.PARAMETER) {
            ComplexTextRange declaratorScope = declaratorSymbol.getScope();
            ComplexTextRange duplicateScope = symbol.getScope();
            if (declaratorScope != null && duplicateScope != null && duplicateScope.contains(declaratorScope)) {
                annotations = this.addWarningAnnotations(navigationElements, OCInspections.HidesUpperScope.class, "warn_decl_shadow", declaratorSymbol.getNameWithKindUppercase(compilationContext) + " hides previous declaration in the upper scope");
            }
        } else if (symbol instanceof OCInstanceVariableSymbol) {
            OCClassSymbol ivarParent;
            OCInstanceVariableSymbol ivar = (OCInstanceVariableSymbol)symbol;
            OCMethod containingMethod = (OCMethod)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCMethod.class});
            if (containingMethod == null) {
                return null;
            }
            OCMethodSymbol method = (OCMethodSymbol)containingMethod.getSymbol();
            Object suffixMessage = "";
            if (method == null || method.isStatic() || !(method.getParent() instanceof OCImplementationSymbol)) {
                return null;
            }
            OCClassSymbol methodParent = method.getParent();
            if (!methodParent.isSameSymbol((OCSymbol)(ivarParent = ivar.getParent()), element.getProject())) {
                suffixMessage = " declared in " + ivarParent.getNameWithKindLowercase(compilationContext);
                if (ivar.getVisibility() == OCVisibility.PRIVATE) {
                    return null;
                }
            }
            String message = declaratorSymbol.getNameWithKindUppercase(compilationContext) + " hides the " + symbol.getKind().getNameLowercase() + " with the same name" + (String)suffixMessage;
            annotations = this.addWarningAnnotations(navigationElements, OCInspections.HidesClassScope.class, "warn_ivar_use_hidden", message);
        }
        this.registerQuickFixes(annotations, new OCRenameSymbolIntentionAction(declaratorSymbol, compilationContext));
        return annotations;
    }

    private void checkMethodAlias(@NotNull OCMethod method, OCMethodSymbol declaratorMethod, OCMethodSymbol baseMethod) {
        Object message;
        Project project = method.getProject();
        if (baseMethod.equals(declaratorMethod.getAssociatedSymbol(project))) {
            return;
        }
        if (declaratorMethod.isStatic() != baseMethod.isStatic()) {
            return;
        }
        OCPropertySymbol property = baseMethod.getGeneratedFromProperty();
        Object messageSuffix = "";
        OCCompilationContext compilationContext = OCCompilationContext.create(method);
        if (!Comparing.equal((Object)declaratorMethod.getParent(), (Object)baseMethod.getParent())) {
            messageSuffix = "; " + (property != null ? "property" : "base method") + " was declared in " + baseMethod.getParent().getNameWithKindLowercase(compilationContext);
        }
        OCType declReturnType = declaratorMethod.getReturnType(project);
        OCType baseReturnType = baseMethod.getEffectiveType(method);
        if (!baseReturnType.isSuperType(declReturnType, method)) {
            Annotation annotation;
            if (property != null && OCNameSuggester.isObjCGetter(declaratorMethod.getName())) {
                message = "Return type (" + declReturnType.getName(method) + ") of getter method for " + property.getNameWithKindLowercase(compilationContext) + " doesn't match the type (" + property.getType().getName(method) + ") of property" + (String)messageSuffix;
                annotation = this.addWarningAnnotation(method.getReturnTypeElement(), OCInspections.AssociatedTypeMismatch.class, "warn_non_covariant_overriding_ret_types", (String)message);
                this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(declaratorMethod, property.getType(), compilationContext));
                this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(property, declReturnType, compilationContext));
            } else if (property != null && OCNameSuggester.isObjCSetter(declaratorMethod.getName())) {
                message = "Return type of setter method must be 'void'";
                annotation = this.addWarningAnnotation(method.getReturnTypeElement(), OCInspections.AssociatedTypeMismatch.class, "warn_non_covariant_overriding_ret_types", (String)message);
                this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(declaratorMethod, OCVoidType.instance(), compilationContext));
            } else {
                message = "Return type (" + declReturnType.getName(method) + ") of overridden method doesn't match the return type (" + baseReturnType.getName(method) + ") of base method";
                annotation = this.addWarningAnnotation(method.getReturnTypeElement(), OCInspections.OverriddenTypeMismatch.class, "warn_non_covariant_overriding_ret_types", (String)message);
                this.registerQuickFix(annotation, new OCChangeTypeIntentionAction((OCSymbol)declaratorMethod, baseReturnType, "overridden " + declaratorMethod.getNameWithKindLowercase(compilationContext), compilationContext));
                this.registerQuickFix(annotation, new OCChangeTypeIntentionAction((OCSymbol)baseMethod, declReturnType, "base " + baseMethod.getNameWithKindLowercase(compilationContext), compilationContext));
            }
        }
        for (int i = 0; i < declaratorMethod.getSelectors().size(); ++i) {
            Annotation annotation;
            OCType baseParamType;
            OCType declParamType;
            OCDeclaratorSymbol declParameter = declaratorMethod.getSelectors().get(i).getParameter();
            OCDeclaratorSymbol baseParameter = baseMethod.getSelectors().get(i).getParameter();
            if (declParameter == null || baseParameter == null || (declParamType = declParameter.getType()).isSuperType(baseParamType = baseParameter.getEffectiveType(method), method)) continue;
            OCTypeElement typeElement = method.getParameters().get(i).getTypeElement();
            if (property != null) {
                message = "Parameter type (" + declParamType.getName(method) + ") of setter method for " + property.getNameWithKindLowercase(compilationContext) + " doesn't match the type (" + property.getType().getName(method) + ") of property" + (String)messageSuffix;
                annotation = this.addWarningAnnotation(typeElement, OCInspections.AssociatedTypeMismatch.class, "warn_non_contravariant_overriding_param_types", (String)message);
                this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(declParameter, property.getType(), compilationContext));
                this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(property, declParamType, compilationContext));
                continue;
            }
            message = "Parameter type (" + declParamType.getName(method) + ") of overridden method doesn't match the parameter type (" + baseParamType.getName(method) + ") of base method";
            annotation = this.addWarningAnnotation(typeElement, OCInspections.OverriddenTypeMismatch.class, "warn_non_contravariant_overriding_param_types", (String)message);
            this.registerQuickFix(annotation, new OCChangeTypeIntentionAction((OCSymbol)declParameter, baseParamType, "overridden " + declParameter.getNameWithKindLowercase(compilationContext), compilationContext));
            this.registerQuickFix(annotation, new OCChangeTypeIntentionAction((OCSymbol)baseParameter, declParamType, "base " + baseParameter.getNameWithKindLowercase(compilationContext), compilationContext));
        }
    }

    private void checkPropertyAlias(OCDeclaration property, OCPropertySymbol declaratorProperty, OCPropertySymbol baseProperty) {
        OCResolveContext context = OCResolveContext.forPsi(property);
        OCType declaratorPropType = declaratorProperty.getResolvedType(context);
        OCType basePropType = baseProperty.getResolvedType(context);
        this.checkPropertyTypesMatch(baseProperty, "base property", declaratorProperty, "overridden property", property.getTypeElement(), OCInspections.OverriddenTypeMismatch.class);
        OCPropertySymbol.FlagAttribute[] attrGroups = new OCPropertySymbol.FlagAttribute[]{OCPropertySymbol.PropertyAttribute.ATOMIC, OCPropertySymbol.PropertyAttribute.READWRITE, OCPropertySymbol.PropertyAttribute.STRONG};
        OCClassSymbol declParent = declaratorProperty.getParent();
        OCClassSymbol baseParent = baseProperty.getParent();
        PsiElement attributesHighlightElement = property.getParent();
        Project project = property.getProject();
        Annotation annotation = null;
        if (((OCProperty)attributesHighlightElement).getPropertyAttributesList() != null) {
            attributesHighlightElement = ((OCProperty)attributesHighlightElement).getPropertyAttributesList();
        }
        for (OCPropertySymbol.FlagAttribute attrGroup : attrGroups) {
            OCPropertySymbol.FlagAttribute declValue = declaratorProperty.getAttributeOfGroup(attrGroup, declaratorPropType, property);
            OCPropertySymbol.FlagAttribute baseValue = baseProperty.getAttributeOfGroup(attrGroup, basePropType, property);
            boolean incompatibility = false;
            boolean isError = false;
            Object message = "Overridden property is " + declValue.getTokenName() + "; the base property is " + baseValue.getTokenName();
            String clangID = "err_objc_property_attr_mutually_exclusive";
            List<OCChangePropertyAttributeIntentionAction> quickFixes = Arrays.asList(new OCChangePropertyAttributeIntentionAction(declaratorProperty, declValue, baseValue, null, "overridden property", project), new OCChangePropertyAttributeIntentionAction(baseProperty, baseValue, declValue, null, "base property", project));
            if (attrGroup == OCPropertySymbol.PropertyAttribute.ATOMIC) {
                incompatibility = declValue != baseValue;
            } else if (attrGroup == OCPropertySymbol.PropertyAttribute.READWRITE) {
                if ("".equals(declParent.getCategoryName()) && baseParent.getCategoryName() == null && declParent.getName().equals(baseParent.getName())) {
                    if (!baseProperty.isReadonly()) {
                        quickFixes = Collections.singletonList(new OCChangePropertyAttributeIntentionAction(baseProperty, OCPropertySymbol.PropertyAttribute.READWRITE, OCPropertySymbol.PropertyAttribute.READONLY, null, "base property", project));
                        message = "Overridden properties must be 'readonly' in the interface";
                        clangID = "err_use_continuation_class_redeclaration_readwrite";
                        isError = true;
                        incompatibility = true;
                    } else if (declaratorProperty.isReadonly()) {
                        quickFixes = Collections.singletonList(new OCChangePropertyAttributeIntentionAction(declaratorProperty, OCPropertySymbol.PropertyAttribute.READONLY, OCPropertySymbol.PropertyAttribute.READWRITE, null, "category property", project));
                        message = "Overridden properties must be 'readwrite' in the private category";
                        isError = true;
                        incompatibility = true;
                    }
                } else {
                    incompatibility = declaratorProperty.isReadonly() && !baseProperty.isReadonly();
                }
            } else if (attrGroup == OCPropertySymbol.PropertyAttribute.STRONG) {
                boolean bl = incompatibility = declValue.getSemanticsGroup() != baseValue.getSemanticsGroup();
            }
            if (!incompatibility) continue;
            annotation = isError ? this.addErrorAnnotation(attributesHighlightElement, OCInspections.OverriddenAttributeMismatch.class, clangID, (String)message) : this.addWarningAnnotation(attributesHighlightElement, OCInspections.OverriddenAttributeMismatch.class, clangID, (String)message);
            for (IntentionAction intentionAction : quickFixes) {
                this.registerQuickFix(annotation, intentionAction);
            }
        }
        if (annotation != null) {
            this.registerQuickFix(annotation, new OCRemoveDeclarationIntentionAction("overridden part of", declaratorProperty, project));
        }
    }

    public void checkDeclarator(@Nullable OCType lType, @Nullable OCType unresolvedLType, @NotNull PsiNameIdentifierOwner element, @Nullable OCDeclarator declarator, OCSymbol symbol) {
        OCDeclarationStatement declaration;
        OCParameterList paramsList;
        PsiElement function;
        PsiElement declaratorParent;
        String name = OCElementUtil.getSymbolName((PsiElement)element);
        if (!this.checkDuplicates(element)) {
            return;
        }
        OCResolveContext context = OCResolveContext.forPsi((PsiElement)element);
        if (PsiTreeUtil.getParentOfType((PsiElement)element, OCBlockExpression.class) == null && OCElementUtil.getSelfSuperToken(name, (PsiElement)element, context) != null) {
            Annotation annotation = this.addErrorAnnotation((PsiElement)element, "err_redefinition_different_type", "Can't create a variable with name '" + name + "' inside the method");
            this.registerQuickFix(annotation, new OCRemoveDeclarationIntentionAction(symbol, context.getProject()));
            this.registerQuickFix(annotation, new OCRemoveDeclarationButInitializerIntentionAction(symbol, context.getProject()));
            return;
        }
        if (lType == null || symbol == null) {
            return;
        }
        if (declarator != null && declarator.getParent() instanceof OCParameterDeclaration && OCTypeUtils.hasAutoInside(unresolvedLType)) {
            PsiElement parent = declarator.getParent().getParent().getParent();
            OCTypeElement typeElement = ((OCParameterDeclaration)declarator.getParent()).getTypeElement();
            if (typeElement instanceof OCConceptPlaceholderType) {
                if (!OCCompilerFeaturesHelper.supportsCxxConcepts(declarator.getContainingFile())) {
                    this.addErrorAnnotation(typeElement, "CIDR", "Concepts are not supported pre-C++20");
                }
                return;
            }
            if (parent.getParent() instanceof OCFunctionDeclaration && Arrays.stream(declarator.getNode().getChildren(null)).noneMatch(t -> t.getElementType() == OCTokenTypes.DEREF)) {
                this.addErrorAnnotation(typeElement, "err_auto_not_allowed", "'" + typeElement.getText() + "' not allowed in function prototype");
            } else if (parent instanceof OCLambdaExpression && !OCCompilerFeaturesHelper.supportsCxxGenericLambdas(declarator.getContainingFile())) {
                this.addErrorAnnotation(typeElement, "err_auto_not_allowed", "Generic lambdas are not supported by the compiler");
            }
        } else if (declarator != null && unresolvedLType instanceof OCAutoType && declarator.getInitializerList() != null) {
            OCCompoundInitializer braced = declarator.getInitializerList();
            if (declarator.getInitializer() == null) {
                if (braced.getInitializers().size() != 1) {
                    this.addErrorAnnotation(braced, "CIDR", "Direct list initialization of 'auto' requires exactly one element");
                    return;
                }
            } else if (braced.getInitializers().isEmpty()) {
                this.addErrorAnnotation(declarator, "CIDR", "Cannot deduce actual type from empty initializer list");
                return;
            }
        }
        OCFile file = (OCFile)element.getContainingFile();
        PsiElement psiElement = declaratorParent = declarator != null ? declarator.getParent() : null;
        if (this.checkUnknownStructure(lType, declarator, symbol) || lType.isUnknown()) {
            return;
        }
        if (!(declarator == null || !OCDeclaratorChecker.requiresInitializer(lType, symbol, context) || symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isExtern() || !declarator.getInitializers().isEmpty() || !declarator.getArrayLengths().isEmpty() && declarator.getParameterList() != null || declaratorParent.getParent().getParent() instanceof OCStructuredBindingDeclaration || declaratorParent.getParent().getParent() instanceof OCLoopStatement)) {
            switch (symbol.getKind()) {
                case LOCAL_VARIABLE: 
                case GLOBAL_VARIABLE: 
                case GLOBAL_VARIABLE_PREDECLARATION: {
                    String message = "Declaration of " + (lType instanceof OCCppReferenceType ? "reference" : "const") + " variable requires an initializer";
                    if (lType instanceof OCStructType) {
                        message = message + " or an explicit default constructor";
                    }
                    Annotation annotation = this.addErrorAnnotation((PsiElement)element, "err_reference_var_requires_init", message);
                    this.registerQuickFix(annotation, new OCAddInitializerIntentionAction(declarator, symbol));
                    if (!(lType instanceof OCStructType)) break;
                    this.registerQuickFix(annotation, new OCGenerateConstructorFix(((OCStructType)lType).getSymbol(), false, context.getProject()));
                    break;
                }
                case INSTANCE_VARIABLE: {
                    if (!(lType instanceof OCCppReferenceType)) break;
                    Annotation annotation1 = this.addErrorAnnotation((PsiElement)element, "err_ivar_reference_type", "Instance variables can't have reference type");
                    this.registerQuickFix(annotation1, new OCChangeTypeIntentionAction(symbol, ((OCCppReferenceType)lType).getRefType(), context));
                }
            }
        }
        if (!file.isCpp() && element.getNameIdentifier() == null && element.getParent() instanceof OCParameterDeclaration && element.getParent().getParent() instanceof OCParameterList && (function = (paramsList = (OCParameterList)element.getParent().getParent()).getParent().getParent()) instanceof OCFunctionDefinition && ((OCFunctionDefinition)function).getBody() != null && !(lType instanceof OCEllipsisType) && (!(lType instanceof OCVoidType) || paramsList.getParameterDeclarations().size() != 1)) {
            String clangId = OCClangMessageFinder.getInstance().getParameterNameOmitted();
            this.addErrorAnnotation(element.getParent(), clangId, "Parameter name is omitted");
        }
        if (!(lType instanceof OCFunctionType) && !this.checkInstanceable(lType, element.getNameIdentifier(), symbol, false)) {
            return;
        }
        if (lType instanceof OCFunctionType) {
            PsiElement errorElement;
            OCType returnType = ((OCFunctionType)lType).getReturnType();
            PsiElement psiElement2 = errorElement = element.getParent() instanceof OCFunctionDefinition ? ((OCFunctionDefinition)element.getParent()).getReturnTypeElement() : element.getNameIdentifier();
            if (!returnType.isVoid() && !this.checkInstanceable(returnType, errorElement, symbol, true)) {
                return;
            }
        }
        this.checkDuplicateDeclarator(element, symbol, file);
        if (file.isCpp() && declaratorParent instanceof OCFunctionDeclaration && symbol instanceof OCFunctionSymbol) {
            this.myCppChecker.checkCppFunction((OCFunctionDeclaration)declaratorParent, (OCFunctionSymbol)symbol);
        }
        if (!this.checkDeclaratorARCTypes(lType, element, symbol, file)) {
            return;
        }
        if (symbol instanceof OCPropertySymbol) {
            OCPropertySymbol property = (OCPropertySymbol)symbol;
            this.checkPropertyDeclarator(element, property);
        } else if (symbol instanceof OCInstanceVariableSymbol) {
            OCInstanceVariableSymbol ivar = (OCInstanceVariableSymbol)symbol;
            Project project = element.getProject();
            OCPropertySymbol property = ivar.getAssociatedProperty(project);
            if (!(property == null || OCCompilerFeaturesHelper.supportsAutosynthesis(file) && property.hasAllAccessorsImplemented(false, project))) {
                this.checkPropertyTypesMatch(property, OCSymbolKind.PROPERTY.getNameLowercase(), ivar, OCSymbolKind.INSTANCE_VARIABLE.getNameLowercase(), (PsiElement)element, OCInspections.PropertyAndIvarTypeMismatch.class);
            }
            if (OCCompilerFeaturesHelper.isArcEnabled(file)) {
                this.checkARCCompatibleAttributes(element, ivar, ivar.getARCAttribute(file, project), property);
            }
        }
        if (declarator == null) {
            return;
        }
        this.checkArrayLengths(declarator);
        if (declaratorParent.getParent() instanceof OCDeclarationStatement && (declaration = (OCDeclarationStatement)declaratorParent.getParent()).getParent() instanceof OCForeachStatement) {
            return;
        }
        if (ContainerUtil.getFirstItem(declarator.getInitializers()) instanceof OCCompoundInitializer && declarator.getArgumentList() == null) {
            this.checkDeclaratorInitializer(declarator, symbol, lType, element, true);
            return;
        }
        OCExpression initializer = declarator.getInitializer();
        if (initializer != null && !this.checkDeclaratorInitializer(declarator, symbol, lType, element, true)) {
            return;
        }
        PsiReference constructorReference = declarator.getReference();
        OCSymbol constructorSymbol = null;
        if (!(initializer != null || symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isExtern())) {
            if (file.isCpp() && constructorReference instanceof OCReference && symbol.getKind() != OCSymbolKind.PARAMETER && symbol.getKind() != OCSymbolKind.CATCH_EXCEPTION_VARIABLE && !(lType instanceof OCCppReferenceType)) {
                constructorSymbol = ((OCReference)constructorReference).resolveToSymbol();
                if (!this.myCppChecker.checkConstructorCall(declarator, declarator.getInitializers(), constructorSymbol, null)) {
                    return;
                }
            }
            this.checkDeclaratorInitializer(declarator, symbol, lType, element, constructorSymbol == null);
        }
    }

    protected static boolean requiresInitializer(OCType lType, OCSymbol declaratorSymbol, @NotNull OCResolveContext context) {
        OCDeclaratorSymbol declarationInParent;
        OCDeclaratorSymbol oCDeclaratorSymbol = declarationInParent = declaratorSymbol instanceof OCDeclaratorSymbol ? ((OCDeclaratorSymbol)declaratorSymbol).getDeclarationInParent(context) : null;
        if (declarationInParent != null && declarationInParent.getInitializer() != null) {
            return false;
        }
        if (lType instanceof OCCppReferenceType && !(((OCCppReferenceType)lType).getRefType() instanceof OCFunctionType)) {
            return true;
        }
        if (context.isCpp() && lType.isConst() && !(lType instanceof OCArrayType)) {
            return !(lType instanceof OCStructType) || ((OCStructType)lType).getSymbol().processConstructors((Processor<? super OCFunctionSymbol>)((Processor)symbol -> symbol.getNonInitializedParametersCount(context) > 0), context);
        }
        return false;
    }

    private boolean checkDeclaratorARCTypes(OCType lType, PsiNameIdentifierOwner element, OCSymbol symbol, OCFile file) {
        if (OCCompilerFeaturesHelper.isArcEnabled(file)) {
            OCResolveContext context = OCResolveContext.forPsi((PsiElement)element);
            OCType type = symbol.getResolvedType(context);
            if (symbol.getKind() == OCSymbolKind.STRUCT_FIELD && type.isPointerToObject() && !context.isCpp()) {
                while (type instanceof OCCppReferenceType) {
                    type = ((OCCppReferenceType)type).getRefType();
                }
                if (type instanceof OCPointerType && ((OCPointerType)type).getARCAttribute() == null) {
                    String clangID = OCClangMessageFinder.getInstance().getUsageOfArcObjectInStruct();
                    Annotation annotation = this.addErrorAnnotation((PsiElement)element, OCInspections.ARCIssues.class, clangID, "Object struct fields must have an attribute in ARC");
                    for (ARCAttribute attribute : ARCAttribute.values()) {
                        this.registerQuickFix(annotation, new OCChangeARCAttributeIntentionAction(symbol, attribute, OCCompilationContext.create((PsiElement)element)));
                    }
                }
                return false;
            }
            if (!this.myCppChecker.checkARCPointerTypes(lType, (PsiElement)element, symbol)) {
                return false;
            }
        }
        return true;
    }

    private static boolean isInplaceMemberFunction(@NotNull OCSymbol symbol, @NotNull OCResolveContext context) {
        return symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).getParent() instanceof OCStructSymbol && ((OCFunctionSymbol)symbol).isMember(context, true);
    }

    private void checkDuplicateDeclarator(PsiNameIdentifierOwner element, OCSymbol symbol, OCFile file) {
        Project project = element.getProject();
        OCResolveContext context = OCResolveContext.forPsi((PsiElement)element);
        if (symbol.getKind() == OCSymbolKind.FUNCTION_DECLARATION || symbol.getKind() == OCSymbolKind.CPP_CONSTRUCTOR_DECLARATION || symbol instanceof OCDeclaratorSymbol || OCDeclaratorChecker.isInplaceMemberFunction(symbol, context)) {
            symbol.processSameSymbols((Processor<OCSymbol>)((Processor)_symbol -> {
                boolean isExternDeclarator;
                if (!_symbol.isPredeclaration() || OCDeclaratorChecker.isInplaceMemberFunction(symbol, context) && OCDeclaratorChecker.isInplaceMemberFunction(_symbol, context) && ((OCFunctionSymbol)symbol).getParent() == ((OCFunctionSymbol)_symbol).getParent()) {
                    boolean isTemplate2;
                    if (symbol.equals(_symbol) || OCResolveUtil.isEarlierInCode(symbol, _symbol)) {
                        return true;
                    }
                    if (symbol instanceof OCDeclaratorSymbol && _symbol instanceof OCDeclaratorSymbol && (!((OCDeclaratorSymbol)symbol).hasInitializer() || !((OCDeclaratorSymbol)_symbol).hasInitializer())) {
                        return true;
                    }
                    OCSymbolWithQualifiedName symbol1 = (OCSymbolWithQualifiedName)symbol;
                    OCSymbolWithQualifiedName symbol2 = (OCSymbolWithQualifiedName)_symbol;
                    OCSymbolWithQualifiedName owner1 = symbol1.getResolvedOwner(context);
                    OCSymbolWithQualifiedName owner2 = symbol2.getResolvedOwner(context);
                    boolean isTemplate1 = symbol1 instanceof OCTemplateSymbol && ((OCTemplateSymbol)((Object)symbol1)).isTemplateSymbol();
                    boolean bl = isTemplate2 = symbol2 instanceof OCTemplateSymbol && ((OCTemplateSymbol)((Object)symbol2)).isTemplateSymbol();
                    if (!(!isTemplate1 && !isTemplate2 || isTemplate1 == isTemplate2 && OCResolveUtil.isDuplicate(symbol2, symbol1, project))) {
                        return true;
                    }
                    if (owner1 instanceof OCStructSymbol && owner2 instanceof OCStructSymbol ? !owner1.getType().equals(owner2.getType(), false, context) : !Comparing.equal((Object)owner1, (Object)owner2)) {
                        return true;
                    }
                    if (symbol instanceof OCFunctionSymbol && _symbol instanceof OCFunctionSymbol) {
                        OCFunctionType type = (OCFunctionType)symbol.getResolvedType(context);
                        if (!type.equals(_symbol.getResolvedType(context), false, context)) {
                            return true;
                        }
                        for (OCType paramType : type.getParameterTypes()) {
                            if (!(paramType instanceof OCTypeParameterType) || !((OCTypeParameterType)paramType).getSymbol().isSynthetic()) continue;
                            return true;
                        }
                    }
                    String kind = symbol2.getResolvedKind(context).getNameUppercase();
                    OCQualifiedName qualifiedName = symbol1.getQualifiedName();
                    Annotation annotation = this.addErrorAnnotation((PsiElement)element, OCInspections.DuplicateDeclarations.class, "err_member_redeclared", kind + " " + qualifiedName + " was redefined");
                    this.registerQuickFix(annotation, new OCRemoveDeclarationIntentionAction("previous declaration of", (OCSymbol)_symbol, project));
                }
                boolean bl = isExternDeclarator = _symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)_symbol).isExtern();
                if (isExternDeclarator || _symbol instanceof OCFunctionSymbol) {
                    OCFileSymbols.markSymbolAsUsed(file, _symbol, (PsiElement)element);
                }
                return true;
            }), project);
        }
    }

    private boolean checkUnknownStructure(OCType lType, OCDeclarator declarator, OCSymbol symbol) {
        int dimensions;
        int n = dimensions = declarator != null ? declarator.getArrayLengths().size() : 0;
        while (dimensions > 0 && lType instanceof OCPointerType) {
            --dimensions;
            lType = ((OCPointerType)lType).getRefType();
        }
        if (lType instanceof OCReferenceType && ((OCReferenceType)lType).hasElaboratedTypeSpecifier() || lType instanceof OCStructType && ((OCStructType)lType).isPredeclaration()) {
            boolean isEnumWithBase;
            boolean isExtern = symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isExtern();
            boolean bl = isEnumWithBase = lType instanceof OCStructType && ((OCStructType)lType).getKind() == OCSymbolKind.ENUM && declarator != null && !((OCStructType)lType).getSymbol().getBaseCppClasses(declarator).isEmpty();
            if (symbol.getKind() != OCSymbolKind.TYPEDEF && !isExtern && !isEnumWithBase && declarator != null && declarator.getContainingOCFile().isCpp()) {
                OCStructSymbol struct;
                OCSymbol definitionSymbol;
                Annotation annotation = this.addErrorAnnotation(declarator, OCInspections.CannotResolve.class, "err_typecheck_decl_incomplete_type", "Instantiating an unknown structure without a reference");
                if (lType instanceof OCReferenceType) {
                    lType = lType.resolve(declarator, true);
                }
                if (lType instanceof OCStructType && (definitionSymbol = (struct = ((OCStructType)lType).getStructs().get(0)).getDefinitionSymbol(declarator.getProject())) != null) {
                    OCTypeElement typeElement = ((OCDeclaration)declarator.getParent()).getTypeElement();
                    this.registerQuickFix(annotation, (IntentionAction)new OCImportSymbolFix(typeElement, definitionSymbol, false, false));
                }
                return true;
            }
        }
        return false;
    }

    private void checkPropertyDeclarator(PsiNameIdentifierOwner element, OCPropertySymbol property) {
        OCPropertySymbol categoryProperty;
        PsiFile file = element.getContainingFile();
        OCType type = property.getType().resolve((PsiElement)element);
        if (type instanceof OCArrayType || type instanceof OCFunctionType) {
            this.addErrorAnnotation((PsiElement)element, "err_property_type", "Properties can't have the array or function type");
            return;
        }
        Project project = element.getProject();
        if (!(OCCompilerFeaturesHelper.supportsExplicitAtomic(element.getContainingFile()) || !type.isPointerToObject() || property.hasAttribute(OCPropertySymbol.PropertyAttribute.STRONG) || property.hasAttribute(OCPropertySymbol.PropertyAttribute.WEAK) || property.hasAttribute(OCPropertySymbol.PropertyAttribute.ASSIGN) || property.hasAttribute(OCPropertySymbol.PropertyAttribute.RETAIN) || property.hasAttribute(OCPropertySymbol.PropertyAttribute.COPY) || property.hasAttribute(OCPropertySymbol.PropertyAttribute.UNSAFE_UNRETAINED) || property.hasAttribute(OCPropertySymbol.PropertyAttribute.READONLY))) {
            Annotation annotation = this.addWarningAnnotation(element.getParent().getParent(), OCInspections.NoAttributeForProperty.class, "warn_objc_property_no_assignment_attribute", "No 'strong', 'weak', 'assign', 'retain', or 'copy' attribute is specified - 'assign' is assumed");
            if (OCCompilerFeaturesHelper.isArcEnabled(file)) {
                this.registerQuickFix(annotation, new OCChangePropertyAttributeIntentionAction(property, null, OCPropertySymbol.PropertyAttribute.STRONG, null, project));
                this.registerQuickFix(annotation, new OCChangePropertyAttributeIntentionAction(property, null, OCPropertySymbol.PropertyAttribute.WEAK, null, project));
            }
            this.registerQuickFix(annotation, new OCChangePropertyAttributeIntentionAction(property, null, OCPropertySymbol.PropertyAttribute.ASSIGN, null, project));
            this.registerQuickFix(annotation, new OCChangePropertyAttributeIntentionAction(property, null, OCPropertySymbol.PropertyAttribute.RETAIN, null, project));
            this.registerQuickFix(annotation, new OCChangePropertyAttributeIntentionAction(property, null, OCPropertySymbol.PropertyAttribute.COPY, null, project));
        }
        if (property.getParent().getCategoryName() == null && (categoryProperty = property.getAssociatedPropertyInPrivateCategory(project)) != null) {
            this.checkPropertyAlias((OCDeclaration)element.getParent(), categoryProperty, property);
        }
        OCInstanceVariableSymbol ivar = property.getAssociatedIvar(project);
        if (OCCompilerFeaturesHelper.isArcEnabled(file)) {
            if (ivar != null) {
                this.checkARCCompatibleAttributes(element, ivar, ivar.getARCAttribute((PsiElement)file, project), property);
            }
            if (type instanceof OCPointerType) {
                this.checkARCCompatibleAttributes(element, property, ((OCPointerType)type).getARCAttribute(), property);
            }
        }
        if (!OCCompilerFeaturesHelper.supportsAutosynthesis(file) || !property.hasAllAccessorsImplemented(false, project)) {
            this.checkPropertyTypesMatch(property, OCSymbolKind.PROPERTY.getNameLowercase(), ivar, OCSymbolKind.INSTANCE_VARIABLE.getNameLowercase(), (PsiElement)element, OCInspections.PropertyAndIvarTypeMismatch.class);
        }
    }

    private void checkARCCompatibleAttributes(PsiNameIdentifierOwner element, OCSymbol symbol, ARCAttribute arcAttribute, OCPropertySymbol property) {
        OCType type;
        OCResolveContext context = OCResolveContext.forPsi((PsiElement)element);
        OCType oCType = type = property != null ? property.getResolvedType(context) : null;
        if (property != null && symbol != null && arcAttribute != null && type.isPointerToObjectCompatible()) {
            OCPropertySymbol.FlagAttribute propAttr = property.getAttributeOfGroup(OCPropertySymbol.PropertyAttribute.ASSIGN, type, (PsiElement)element);
            Project project = element.getProject();
            if (!(arcAttribute == propAttr.getIvarCompatibleARCAttribute() || propAttr == OCPropertySymbol.PropertyAttribute.ASSIGN && property.isReadonly())) {
                String clangID;
                String message;
                if (symbol instanceof OCInstanceVariableSymbol) {
                    message = "Ivar for " + propAttr.getTokenName() + " " + property.getNameWithKindLowercase(context) + " must be " + propAttr.getIvarCompatibleARCAttribute().getTokenName();
                    clangID = OCClangMessageFinder.getInstance().getWeakProperty();
                } else if (symbol instanceof OCPropertySymbol) {
                    message = "Attributes '" + propAttr.getTokenName() + "' and '" + arcAttribute.getTokenName() + "' are mutually exclusive";
                    clangID = "err_objc_property_attr_mutually_exclusive";
                } else {
                    return;
                }
                if (!OCAnnotator.isAnnotatedAsUserCode(project, symbol.getContainingFile())) {
                    return;
                }
                Annotation annotation = this.addErrorAnnotation((PsiElement)element, OCInspections.ARCIssues.class, clangID, message);
                this.registerQuickFix(annotation, new OCChangeARCAttributeIntentionAction(symbol, propAttr.getIvarCompatibleARCAttribute(), context));
                OCPropertySymbol.PropertyAttribute attribute = arcAttribute.getPropertyCompatibleSemantics(type, (PsiElement)element).getPropertyAttribute();
                this.registerQuickFix(annotation, new OCChangePropertyAttributeIntentionAction(property, propAttr, attribute, null, project));
            }
        }
    }

    private void checkPropertyTypesMatch(OCPropertySymbol baseProperty, String baseSubject, OCSymbol overriddenSymbol, String overriddenSubject, PsiElement annotationElement, Class<? extends OCInspection> inspectionClass) {
        if (baseProperty == null || overriddenSymbol == null) {
            return;
        }
        OCResolveContext context = OCResolveContext.forPsi(annotationElement);
        OCType baseType = baseProperty.getType().resolve(context);
        OCType overriddenType = overriddenSymbol.getType().resolve(context);
        String baseTypeName = baseType.getName(context);
        String overriddenTypeName = overriddenType.getName(context);
        String message = "The type of " + baseSubject + " (" + baseTypeName + ") isn't assignable from the type of " + overriddenSubject + " (" + overriddenTypeName + ")";
        OCType propertyRequiredType = overriddenType.transformType(OCArrayToPointerChanger.INSTANCE);
        OCTypeCheckResult result = OCTypeCompatibilityVisitor.checkConvertible(baseType, overriddenType, null, annotationElement, true, true, context).setDestSymbol(baseProperty).setSymbolRequiredType(propertyRequiredType).setClangID("warn_property_types_are_incompatible").setInspectionClass(inspectionClass).setSourceSymbol(overriddenSymbol).setSourceSubject(overriddenSubject).setDestSubject(baseSubject).setForcedMessage(message);
        result.annotate(this.myCppChecker);
        if (!result.getState().isOK() || baseProperty.isReadonly()) {
            return;
        }
        message = "The type of " + overriddenSubject + " (" + overriddenTypeName + ") isn't assignable from the type of " + baseSubject + " (" + baseTypeName + ") - probably you forgot to mark the " + baseSubject + " 'readonly'";
        OCType ivarRequiredType = baseType.transformType(OCArrayToPointerChanger.INSTANCE);
        OCTypeCompatibilityVisitor.checkConvertible(overriddenType, baseType, null, annotationElement, true, true, context).setDestSymbol(overriddenSymbol).setSymbolRequiredType(ivarRequiredType).setInspectionClass(inspectionClass).setSourceSymbol(baseProperty).setSourceSubject(baseSubject).setDestSubject(overriddenSubject).setForcedMessage(message).addQuickFix(new OCChangePropertyAttributeIntentionAction(baseProperty, null, OCPropertySymbol.PropertyAttribute.READONLY, null, context.getProject())).annotate(this.myCppChecker);
    }

    private boolean checkDeclaratorInitializer(OCDeclarator declarator, OCSymbol symbol, OCType lType, PsiNameIdentifierOwner element, @Deprecated boolean performAdditionalCompatibilityCheck) {
        List<OCExpression> initializers = declarator.getInitializers();
        OCExpression initializer = (OCExpression)ContainerUtil.getFirstItem(initializers);
        if (!(lType instanceof OCStructType) && initializers.size() > 1) {
            this.addErrorAnnotation(initializers.get(1), "err_excess_initializers", "Only one initializer is permitted");
        }
        if (symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isExtern()) {
            if (initializer == null || ((OCDeclaratorSymbol)symbol).isConst()) {
                return true;
            }
            Annotation annotation = this.addWarningAnnotation(initializer, OCInspections.IncompatibleInitializers.class, "warn_extern_init", "Extern variable can't have an initializer");
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)initializer, OCInspectionsBundle.message("quick.fix.remove.initializer", new Object[0])));
            return false;
        }
        if (initializer == null) {
            return false;
        }
        PsiElement parent = PsiTreeUtil.getContextOfType((PsiElement)declarator, (Class[])new Class[]{OCProperty.class, OCInstanceVariablesList.class, OCCallable.class, OCParameterList.class, OCStructLike.class});
        if (parent instanceof OCProperty) {
            Annotation annotation = this.addErrorAnnotation(initializer, OCInspections.ConstructionIsNotAllowed.class, "err_expected_semi_decl_list", "Property can't have an initializer");
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)initializer, OCInspectionsBundle.message("quick.fix.remove.initializer", new Object[0])));
            return false;
        }
        PsiElement declaration = element.getParent();
        if (initializer.getContainingOCFile().isCpp() && declaration instanceof OCFunctionDeclaration && declaration.getParent() instanceof OCStructLike) {
            return false;
        }
        if (declaration instanceof OCDeclaration && declaration.getParent() instanceof OCStructLike && ((OCStructLike)declaration.getParent()).getKind() != OCSymbolKind.ENUM && !((OCDeclaration)declaration).getContainingOCFile().isCpp()) {
            Annotation annotation = this.addErrorAnnotation(initializer, OCInspections.ConstructionIsNotAllowed.class, "CIDR", "Structure field can't have an initializer");
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)initializer, OCInspectionsBundle.message("quick.fix.remove.initializer", new Object[0])));
            return false;
        }
        if (parent instanceof OCInstanceVariablesList) {
            Annotation annotation = this.addErrorAnnotation(initializer, OCInspections.ConstructionIsNotAllowed.class, "CIDR", "Instance variable can't have an initializer");
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)initializer, OCInspectionsBundle.message("quick.fix.remove.initializer", new Object[0])));
            return false;
        }
        if (OCCodeInsightUtil.isInPlainOldC(initializer) && (!(parent instanceof OCCallable) || symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isFriendOrStatic())) {
            this.validateConstExpression(initializer, "CIDR", "Initializer of the " + (parent instanceof OCCallable ? "static " : "") + symbol.getKind().getNameLowercase() + " must be const");
        }
        if (initializers.size() == 1) {
            OCType rType = initializer.getResolvedType().getGuessedType();
            if (OCTypeUtils.isUnresolvedLambdaAutoType(rType)) {
                rType = OCTypeUtils.resolveLambdaAutoType(lType, rType, OCResolveContext.forPsi(initializer));
            }
            if (lType instanceof OCArrayType && !OCDeclaratorChecker.canBeArrayInitializer(initializer, rType, declarator.getContainingOCFile().isCpp())) {
                this.addErrorAnnotation((PsiElement)element, OCInspections.ArrayIssues.class, "err_array_init_not_init_list", "Compound array initializer is expected");
                return false;
            }
            if (performAdditionalCompatibilityCheck) {
                OCType symbolRequiredType = rType.transformType(OCArrayToPointerChanger.INSTANCE);
                return OCTypeCompatibilityVisitor.checkConvertible(lType, rType, initializer, (PsiElement)element, true, true, OCResolveContext.forPsi((PsiElement)element)).setDestSymbol(symbol).setSymbolRequiredType(symbolRequiredType).annotate(this.myCppChecker).getState().isOK();
            }
        }
        return true;
    }

    private static boolean canBeArrayInitializer(OCExpression initializer, OCType rType, boolean cpp) {
        if (initializer instanceof OCCompoundInitializer) {
            return true;
        }
        OCExpression innerInitializer = OCParenthesesUtils.diveIntoParentheses(initializer);
        if (innerInitializer instanceof OCLiteralExpression && ((OCLiteralExpression)innerInitializer).isStringLiteral()) {
            return true;
        }
        if (cpp) {
            return false;
        }
        return rType instanceof OCArrayType;
    }

    public boolean checkInstanceable(OCType type, @Nullable PsiElement errorElement, OCSymbol symbol, boolean returnTypeMode) {
        if (errorElement == null) {
            return true;
        }
        if (type instanceof OCBlockPointerType && !(((OCBlockPointerType)type).getRefType() instanceof OCFunctionType)) {
            this.addErrorAnnotation(errorElement, "err_nonfunction_block_type", "Block pointer to non-function is invalid");
            return false;
        }
        if (symbol != null && symbol.getKind() != OCSymbolKind.TYPEDEF && !type.isUnknown() && !type.isInstanceable() && (!(type instanceof OCEllipsisType) && !(type instanceof OCVariadicType) || symbol.getKind() != OCSymbolKind.PARAMETER && symbol.getKind() != OCSymbolKind.TEMPLATE_VALUE_PARAMETER)) {
            String clangID;
            String message;
            OCResolveContext context = OCResolveContext.forPsi(errorElement);
            if (symbol.isCallable()) {
                message = "Can't return type '" + type.getName(context) + "'";
                clangID = "err_object_cannot_be_passed_returned_by_value";
            } else {
                message = "Can't instantiate the variables of type '" + type.getName(context) + "'";
                clangID = "err_statically_allocated_object";
            }
            if (type instanceof OCObjectType || type instanceof OCFunctionType) {
                message = message + " (probably you forgot '*')";
            }
            Annotation annotation = this.addErrorAnnotation(errorElement, OCInspections.PointerTypeRequired.class, clangID, message);
            this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(symbol, (OCType)OCPointerType.to(type), returnTypeMode, (OCCompilationContext)context));
            return false;
        }
        return true;
    }

    private void checkArrayLengths(OCDeclarator declarator) {
        boolean isFirstLengthExpr = true;
        for (OCExpression length : declarator.getArrayLengths()) {
            Number value;
            OCResolveContext context;
            OCType type;
            if (length == null) {
                if (!isFirstLengthExpr) {
                    String clangId = OCClangMessageFinder.getInstance().getDeclArrayIncompleteType();
                    this.addErrorAnnotation(declarator, OCInspections.ArrayIssues.class, clangId, "Empty array length is allowed only at the first dimension");
                    break;
                }
                if (!(declarator.getParent() instanceof OCFunctionDeclaration) && PsiTreeUtil.getContextOfType((PsiElement)declarator, OCCallable.class, (boolean)true, (Class[])new Class[]{OCParameterList.class}) != null && declarator.getInitializer() == null && declarator.getInitializerList() == null) {
                    this.addErrorAnnotation(declarator, OCInspections.ArrayIssues.class, "err_typecheck_incomplete_array_needs_initializer", "Local incomplete array must be initialized");
                    break;
                }
                isFirstLengthExpr = false;
                continue;
            }
            if (PsiTreeUtil.getContextOfType((PsiElement)declarator, (Class[])new Class[]{OCCallable.class}) == null && PsiTreeUtil.getContextOfType((PsiElement)declarator, (Class[])new Class[]{OCParameterList.class}) == null) {
                this.validateConstExpression(length, "err_vla_decl_in_file_scope", "Array length expression must be const");
            }
            if (!(type = length.getResolvedType()).isUnknown() && !type.isIntegerCompatible(context = OCResolveContext.forPsi(declarator))) {
                String message = "Array length expression must have an integer type instead of '" + type.getName(context) + "'";
                Annotation annotation = this.addErrorAnnotation(length, OCInspections.IntegerTypeRequired.class, "err_array_size_non_int", message);
                OCChangeTypeIntentionAction.registerChangeTypeFix(length, OCIntType.CHAR, annotation, this);
            }
            if ((value = OCExpressionEvaluator.evaluate(length)) != null && OCExpressionEvaluator.singAsInC(value) < 0) {
                this.addErrorAnnotation(length, OCInspections.ArrayIssues.class, "err_decl_negative_array_size", "Array length can't be negative");
            }
            isFirstLengthExpr = false;
        }
    }

    private void validateConstExpression(OCExpression expression, final String clangID, final String message) {
        expression.accept(new OCConstantExpressionVisitor(){

            @Override
            protected void nonConstExpression(OCExpression expression) {
                OCSymbol symbol;
                Annotation annotation = OCDeclaratorChecker.this.addErrorAnnotation(expression, OCInspections.ConstExpressionRequired.class, clangID, message);
                if (expression instanceof OCReferenceExpression && (symbol = ((OCReferenceExpression)expression).resolveToSymbol()) instanceof OCDeclaratorSymbol) {
                    OCDeclaratorChecker.this.registerQuickFix(annotation, new OCAddTypeModifierIntentionAction(symbol, OCTokenTypes.CONST_KEYWORD, expression.getProject()));
                }
            }
        });
    }

    public void checkReferenceElement(final OCReferenceElement referenceElement) {
        OCSymbol accessCheckSymbol;
        Annotation annotation;
        OCSymbol symbol = referenceElement.resolveToSymbol();
        if (symbol == null) {
            return;
        }
        OCFile containingFile = referenceElement.getContainingOCFile();
        if (containingFile == null) {
            return;
        }
        if (symbol.isGlobal() || symbol instanceof OCInstanceVariableSymbol) {
            OCFileSymbols.markSymbolAsUsed(containingFile, symbol, referenceElement.getParent());
        }
        if (symbol.getKind() == OCSymbolKind.FUNCTION_DECLARATION) {
            CommonProcessors.FindFirstProcessor<OCSymbol> processor = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

                public boolean process(OCSymbol symbol) {
                    if (OCResolveUtil.isEarlierInCode(symbol, referenceElement) || OCResolveUtil.isInSameStructInCode(symbol, referenceElement)) {
                        return super.process((Object)symbol);
                    }
                    return true;
                }
            };
            if (processor.process((Object)symbol)) {
                ((OCSymbolWithQualifiedName)symbol).processSameSymbols((Processor<OCSymbol>)processor, containingFile, referenceElement.getProject());
            }
            if (!processor.isFound()) {
                annotation = null;
                if (containingFile.isCpp() && referenceElement.getParent() instanceof OCReferenceExpression) {
                    OCReferenceExpression referenceExpr = (OCReferenceExpression)referenceElement.getParent();
                    OCResolveContext context = OCResolveContext.forPsi(referenceElement);
                    if (referenceExpr.getParent() instanceof OCCallExpression && !OCResolveUtil.isDependentCode((OCExpression)referenceExpr.getParent(), context)) {
                        annotation = this.addErrorAnnotation(referenceElement, OCInspections.CannotResolve.class, "CIDR", "Undeclared function '" + symbol.getName() + "'");
                    }
                } else {
                    annotation = this.addWarningAnnotation(referenceElement, OCInspections.FunctionImplicitDeclarationInspection.class, "ext_implicit_function_decl", "Implicit declaration of function '" + symbol.getName() + "'");
                }
                if (annotation != null) {
                    this.registerQuickFix(annotation, new OCCreateFunctionPredeclarationIntentionAction(referenceElement, (OCFunctionSymbol)symbol));
                    this.registerQuickFix(annotation, new OCMoveDefinitionIntentionAction(OCSymbolKind.FUNCTION_DECLARATION, referenceElement, null, symbol, " above"));
                }
            }
        }
        if (!containingFile.isCpp() && symbol instanceof OCStructSymbol && !(referenceElement.getParent() instanceof OCStructLike)) {
            String keyword = symbol.getKind().getStructKeyword();
            annotation = this.addErrorAnnotation(referenceElement, "err_use_of_tag_name_without_tag", "Missing '" + keyword + "' keyword");
            OCChangeTextIntentionAction quickFix = new OCChangeTextIntentionAction(containingFile, referenceElement.getTextOffset(), 0, keyword + " ", OCInspectionsBundle.message("quick.fix.insert.keyword", keyword));
            this.registerQuickFix(annotation, quickFix);
            return;
        }
        OCSymbol oCSymbol = accessCheckSymbol = symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppConstructor() ? ((OCFunctionSymbol)symbol).getParent() : symbol;
        if (!com.jetbrains.cidr.lang.legacy.symbols.OCVisibility.checkFieldVisibility(accessCheckSymbol, referenceElement, null, this)) {
            return;
        }
        this.checkAccess(referenceElement, symbol);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkAccess(OCReferenceElement referenceElement, OCSymbol symbol) {
        OCResolveContext context = OCResolveContext.forPsi(referenceElement);
        if (symbol instanceof OCInstanceVariableSymbol || symbol instanceof OCPropertySymbol) {
            PsiElement parent = PsiTreeUtil.getContextOfType((PsiElement)referenceElement, (Class[])new Class[]{OCMethod.class, OCSynthesizeProperty.class});
            if (parent == null) {
                this.addErrorAnnotation(referenceElement, OCInspections.ConstructionIsNotAllowed.class, "CIDR", symbol.getNameWithKindUppercase(context) + " is accessed outside of a method");
                return;
            } else {
                if (!(parent instanceof OCMethod) || ((OCMethod)parent).isInstanceMethod()) return;
                Annotation annotation = this.addErrorAnnotation(referenceElement, OCInspections.StaticnessMismatch.class, OCClangMessageFinder.getInstance().getIvarUseInClassMethod(), symbol.getNameWithKindUppercase(context) + " is accessed from the class method");
                OCMethodSymbol methodSymbol = (OCMethodSymbol)((OCMethod)parent).getSymbol();
                if (methodSymbol == null) return;
                this.registerQuickFix(annotation, new OCChangeMethodStaticnessIntentionAction(methodSymbol, false, context.getProject()));
            }
            return;
        } else {
            OCFunctionSymbol declarationInParent;
            boolean isGetAddress;
            OCFunctionSymbol functionSymbol;
            if (referenceElement.getParent() instanceof OCCppUsingStatement) return;
            boolean isMember = false;
            OCStructSymbol declInParent = null;
            if (referenceElement.isCppThis()) {
                isMember = true;
            } else {
                if (!(symbol instanceof OCSymbolWithQualifiedName)) return;
                OCSymbolWithQualifiedName owner = ((OCSymbolWithQualifiedName)symbol).getResolvedOwner(context);
                if (!(owner instanceof OCStructSymbol)) return;
                declInParent = (OCStructSymbol)owner;
            }
            OCSymbolDeclarator parent = (OCSymbolDeclarator)PsiTreeUtil.getContextOfType((PsiElement)referenceElement, (Class[])new Class[]{OCFunctionDefinition.class, OCStruct.class});
            Object parentSymbol = parent != null ? parent.getSymbol() : null;
            OCFunctionSymbol oCFunctionSymbol = functionSymbol = parentSymbol instanceof OCFunctionSymbol ? (OCFunctionSymbol)parentSymbol : null;
            if (functionSymbol != null) {
                OCSymbolWithQualifiedName parentClass = functionSymbol.getResolvedOwner(context);
                isMember = isMember || parentClass instanceof OCStructSymbol && declInParent.isAncestor((OCStructSymbol)parentClass, context);
            } else {
                isMember = OCCompilerFeaturesHelper.supportsInClassInitialization(referenceElement.getContainingOCFile()) && parentSymbol instanceof OCStructSymbol ? isMember || declInParent.isAncestor(parentSymbol, context) : false;
            }
            PsiElement possibleGetAddress = referenceElement.getParent().getParent();
            boolean bl = isGetAddress = possibleGetAddress instanceof OCUnaryExpression && ((OCUnaryExpression)possibleGetAddress).isGetAddress();
            if (isMember && (functionSymbol == null || !functionSymbol.resolveIsFriendOrStatic(context)) || !referenceElement.isCppThis() && !OCDeclaratorChecker.mustBeStatic(symbol, context)) return;
            String message = symbol.getNameWithKindUppercase(context) + (isMember ? " is accessed from the static function" : " must be static");
            if (isGetAddress || possibleGetAddress instanceof OCSizeofExpression) return;
            Annotation annotation = this.addErrorAnnotation(referenceElement, OCInspections.StaticnessMismatch.class, "CIDR", message);
            if (isMember && (declarationInParent = functionSymbol.getDeclarationInParent(context)) != null) {
                this.registerQuickFix(annotation, new OCRemoveTypeModifierIntentionAction(declarationInParent, OCTokenTypes.STATIC_KEYWORD, context.getProject()));
            }
            if (symbol instanceof OCFunctionSymbol) {
                declarationInParent = ((OCFunctionSymbol)symbol).getDeclarationInParent(context);
                if (declarationInParent == null) return;
                this.registerQuickFix(annotation, new OCAddTypeModifierIntentionAction(declarationInParent, OCTokenTypes.STATIC_KEYWORD, context.getProject(), false));
                return;
            } else {
                if (!(symbol instanceof OCDeclaratorSymbol)) return;
                this.registerQuickFix(annotation, new OCAddTypeModifierIntentionAction(symbol, OCTokenTypes.STATIC_KEYWORD, context.getProject(), false));
            }
        }
    }

    private static boolean mustBeStatic(OCSymbol symbol, OCResolveContext context) {
        if (symbol instanceof OCFunctionSymbol && !((OCFunctionSymbol)symbol).isCppConstructor() && !((OCFunctionSymbol)symbol).isCppOperator() && !((OCFunctionSymbol)symbol).resolveIsFriendOrStatic(context)) {
            return true;
        }
        return symbol instanceof OCDeclaratorSymbol && !((OCDeclaratorSymbol)symbol).resolveIsStatic(context) && (symbol.getKind() == OCSymbolKind.STRUCT_FIELD || symbol.getKind().isGlobalVariable());
    }
}

