/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.legacy.daemon;

import com.intellij.openapi.util.Ref;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorSink;
import com.jetbrains.cidr.lang.legacy.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCThrowExpression;
import com.jetbrains.cidr.lang.resolve.OCExprValueCategory;
import com.jetbrains.cidr.lang.resolve.v2.Conversions;
import com.jetbrains.cidr.lang.resolve.v2.TypeProperties;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCConditionalExpressionTypesCalc {
    public static OCType calcAndAnnotateConditionalExprType(@NotNull OCType lTy, @NotNull OCTypeOwner lhs, @NotNull OCType rTy, @NotNull OCTypeOwner rhs, @NotNull OCTypeOwner wholeExpr, @Nullable OCAnnotatorSink sink, @NotNull OCResolveContext context) {
        lTy = OCTypeUtils.getCppReferencedType(lTy);
        rTy = OCTypeUtils.getCppReferencedType(rTy);
        CalcTypeResult result = OCConditionalExpressionTypesCalc.calcConditionalExprTypeImpl(lTy, lhs, rTy, rhs, wholeExpr, sink, context);
        if (sink != null && result.needToAnnotateIndividualParameters) {
            OCTypeCompatibilityVisitor.checkConvertible(rTy, lTy, lhs, (OCExpression)lhs, true, true, context).annotate(sink);
            OCTypeCompatibilityVisitor.checkConvertible(lTy, rTy, rhs, (OCExpression)rhs, true, true, context).annotate(sink);
        }
        return OCType.updateWithCommonGuessedType(lTy, rTy, result.type, context);
    }

    private static CalcTypeResult calcConditionalExprTypeImpl(@NotNull OCType lTy, @NotNull OCTypeOwner lhs, @NotNull OCType rTy, @NotNull OCTypeOwner rhs, @NotNull OCTypeOwner wholeExpr, @Nullable OCAnnotatorSink sink, @NotNull OCResolveContext context) {
        boolean same;
        if (lTy.isVoid() || rTy.isVoid()) {
            if (OCConditionalExpressionTypesCalc.isThrow(lhs)) {
                return CalcTypeResult.ok(rTy);
            }
            if (OCConditionalExpressionTypesCalc.isThrow(rhs)) {
                return CalcTypeResult.ok(lTy);
            }
            if (!(!context.isCpp() || lTy.isVoid() && rTy.isVoid())) {
                return CalcTypeResult.fail();
            }
            return CalcTypeResult.ok(OCVoidType.instance());
        }
        if ((lTy.isCppStructType(context) || rTy.isCppStructType(context)) && !OCConditionalExpressionTypesCalc.areLeftAndRightEqual(lTy, rTy, context)) {
            boolean haveR2L = OCConditionalExpressionTypesCalc.hasStructConversion(lTy, rTy, rhs, context);
            boolean haveL2R = OCConditionalExpressionTypesCalc.hasStructConversion(rTy, lTy, lhs, context);
            if (haveL2R && haveR2L) {
                OCConditionalExpressionTypesCalc.annotateAmbiguousStructs(lTy, rTy, (OCExpression)wholeExpr, sink, context);
                return new CalcTypeResult(OCUnknownType.INSTANCE, false);
            }
            if (haveL2R) {
                lTy = rTy;
            } else if (haveR2L) {
                rTy = lTy;
            }
        }
        OCExprValueCategory lvc = OCExprValueCategory.classify(lhs, context);
        OCExprValueCategory rvc = OCExprValueCategory.classify(rhs, context);
        if (!OCConditionalExpressionTypesCalc.areLeftAndRightEqual(lTy, rTy, context) && lvc == rvc && lvc != OCExprValueCategory.PRValue) {
            if (OCConditionalExpressionTypesCalc.areRefCompatible(lTy, rTy, context)) {
                rTy = lTy;
            } else if (OCConditionalExpressionTypesCalc.areRefCompatible(rTy, lTy, context)) {
                lTy = rTy;
            }
        }
        if ((same = OCConditionalExpressionTypesCalc.areLeftAndRightEqual(lTy, rTy, context)) && lvc == rvc && lvc != OCExprValueCategory.PRValue) {
            return CalcTypeResult.ok(lTy.isMagicInside(context) ? lTy : rTy);
        }
        if ((lTy.isCppStructType(context) || rTy.isCppStructType(context)) && !same) {
            return CalcTypeResult.fail();
        }
        if (OCConditionalExpressionTypesCalc.areLeftAndRightEqual(lTy = OCTypeUtils.decayType(lTy, context.getProject(), false), rTy = OCTypeUtils.decayType(rTy, context.getProject(), false), context)) {
            return CalcTypeResult.ok(lTy.isMagicInside(context) ? lTy : rTy);
        }
        if (TypeProperties.isArithmeticType(lTy) && TypeProperties.isArithmeticType(rTy)) {
            return CalcTypeResult.ok(lTy.getLeastCommonType(rTy, context));
        }
        if (lTy.isPointer() && OCExpressionEvaluator.isLikeNil(rhs, context)) {
            return CalcTypeResult.ok(lTy);
        }
        if (rTy.isPointer() && OCExpressionEvaluator.isLikeNil(lhs, context)) {
            return CalcTypeResult.ok(rTy);
        }
        if (lTy.isPointer() || rTy.isPointer()) {
            return OCConditionalExpressionTypesCalc.getCommonPointerType(lTy, rTy, context);
        }
        return CalcTypeResult.fail();
    }

    private static boolean hasStructConversion(@NotNull OCType destType, @NotNull OCType sourceType, @NotNull OCTypeOwner sourceExpr, @NotNull OCResolveContext context) {
        return sourceType.getCVQualifiers().isSuperset(destType.getCVQualifiers()) && !destType.checkCompatible(sourceType, sourceExpr, context.getElement(), true, context).getState().isError(context.getElement());
    }

    private static void annotateAmbiguousStructs(@NotNull OCType LTy, @NotNull OCType RTy, @NotNull OCExpression wholeExpr, @Nullable OCAnnotatorSink sink, @NotNull OCResolveContext context) {
        if (sink != null) {
            sink.addErrorAnnotation(wholeExpr, "err_conditional_ambiguous", String.format("Ambiguous conditional operator: '%s' and '%s' can be converted to each other", LTy.getName(context), RTy.getName(context)));
        }
    }

    private static boolean areRefCompatible(@NotNull OCType LTy, @NotNull OCType RTy, @NotNull OCResolveContext context) {
        Ref objCLifetimeConversion;
        Ref objCConversion;
        Ref derivedToBase = Ref.create();
        Conversions.ReferenceCompareResult refRel = Conversions.CompareReferenceRelationship(LTy, RTy, (Ref<Boolean>)derivedToBase, (Ref<Boolean>)(objCConversion = Ref.create()), (Ref<Boolean>)(objCLifetimeConversion = Ref.create()), context);
        return refRel.compareTo(Conversions.ReferenceCompareResult.Ref_Compatible_With_Added_Qualification) >= 0 && (Boolean)derivedToBase.get() == false && (Boolean)objCConversion.get() == false && (Boolean)objCLifetimeConversion.get() == false;
    }

    @NotNull
    private static CalcTypeResult getCommonPointerType(@NotNull OCType lTy, @NotNull OCType rTy, @NotNull OCResolveContext context) {
        assert (lTy.isPointer() || rTy.isPointer());
        if (lTy.isPointerToObject() && rTy.isPointerToObject()) {
            return new CalcTypeResult(lTy.getLeastCommonType(rTy, context), true);
        }
        if (lTy.isPointer() && rTy.isPointer()) {
            OCType rPointee;
            OCPointerType lp = (OCPointerType)lTy;
            OCPointerType rp = (OCPointerType)rTy;
            OCType lPointee = lp.getRefType();
            OCType commonUnqualifiedPointee = OCConditionalExpressionTypesCalc.getBaseType(lPointee, rPointee = rp.getRefType(), context);
            if (commonUnqualifiedPointee != null) {
                CVQualifiers mergedPointeesCV = lPointee.getCVQualifiers().or(rPointee.getCVQualifiers());
                CVQualifiers mergedPointersCV = lp.getCVQualifiers().or(rp.getCVQualifiers());
                OCType commonQualifiedPointee = commonUnqualifiedPointee.cloneWithAddedCVQualifiers(mergedPointeesCV, context.getProject());
                OCPointerType resultType = OCPointerType.to(commonQualifiedPointee, lp.getARCAttribute(), lp.getClassQualifier(), lp.getNullability(), mergedPointersCV.isConst(), mergedPointersCV.isVolatile());
                return CalcTypeResult.ok(resultType);
            }
        }
        if (!context.isCpp()) {
            if (lTy.isNumberCompatible(context)) {
                return new CalcTypeResult(rTy, true);
            }
            if (rTy.isNumberCompatible(context)) {
                return new CalcTypeResult(lTy, true);
            }
        }
        return CalcTypeResult.fail();
    }

    @Nullable
    private static OCType getBaseType(@NotNull OCType lPointee, @NotNull OCType rPointee, @NotNull OCResolveContext context) {
        if (TypeProperties.hasSameUnqualifiedType(lPointee, rPointee, context) || TypeProperties.IsDerivedFrom(rPointee, lPointee, context)) {
            return lPointee.cloneWithoutCVQualifiers(context.getProject());
        }
        if (TypeProperties.IsDerivedFrom(lPointee, rPointee, context)) {
            return rPointee.cloneWithoutCVQualifiers(context.getProject());
        }
        if (lPointee.isVoid() || rPointee.isVoid()) {
            return OCVoidType.instance();
        }
        return null;
    }

    private static boolean areLeftAndRightEqual(@NotNull OCType LTy, @NotNull OCType RTy, @NotNull OCResolveContext context) {
        return new OCTypeEqualityVisitor(RTy, true, false, context).equal(LTy);
    }

    private static boolean isThrow(@NotNull OCTypeOwner expr) {
        OCTypeOwner inner = OCParenthesesUtils.diveIntoParentheses(expr);
        return inner instanceof OCThrowExpression;
    }

    private static class CalcTypeResult {
        public final OCType type;
        public final boolean needToAnnotateIndividualParameters;

        CalcTypeResult(OCType type, boolean needToAnnotateIndividualParameters) {
            this.type = type;
            this.needToAnnotateIndividualParameters = needToAnnotateIndividualParameters;
        }

        public static CalcTypeResult ok(OCType type) {
            return new CalcTypeResult(type, false);
        }

        public static CalcTypeResult fail() {
            return new CalcTypeResult(OCUnknownType.INSTANCE, true);
        }
    }
}

