/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.generate.handlers.OCGenerateIvarsHandler;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSynthesizePropertyIntentionAction
extends OCGenerateIvarsHandler
implements IntentionAction {
    @NotNull
    public String getText() {
        return OCInspectionsBundle.message("intentions.synthesize.property", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    @Nullable
    protected OCPropertySymbol locateCandidate(@NotNull Project project, Editor editor, PsiFile file) {
        PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
        OCDeclarator parent = OCElementUtil.getAdjacentParentOfType(at, OCDeclarator.class);
        if (parent != null) {
            OCSymbol symbol = parent.getSymbol();
            return symbol instanceof OCPropertySymbol && OCGenerateIvarsHandler.isPropertyDefective((OCPropertySymbol)symbol, project) ? (OCPropertySymbol)symbol : null;
        }
        return null;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (!FileSymbolTablesCache.areSymbolsLoaded(project)) {
            return false;
        }
        return OCCompilerFeaturesHelper.supportsAutosynthesis(file) && OCSearchScope.isInProjectSources(this.locateCandidate(project, editor, file), project);
    }

    @Override
    protected OCClassSymbol getParent(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        OCPropertySymbol prop = this.locateCandidate(project, editor, file);
        return prop != null ? prop.getParent().getMainInterface(project) : null;
    }

    @Override
    protected boolean replaceAllProperties() {
        return false;
    }

    @Override
    protected boolean enableChooseDialog(Collection<OCPropertySymbol> candidates) {
        return false;
    }
}

