/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.editor.surround.OCIfRespondsToSurrounder;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import org.jetbrains.annotations.NotNull;

public class OCSurroundWithIfRespondsIntentionAction
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getText() {
        return OCInspectionsBundle.message("intentions.surround.with.if.responds", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        OCSendMessageExpression sendMessage = (OCSendMessageExpression)PsiTreeUtil.getParentOfType((PsiElement)element, OCSendMessageExpression.class, (boolean)false);
        if (sendMessage != null) {
            OCSendMessageExpression.ProbableResponders responders = sendMessage.getProbableResponders();
            OCMethodSymbol responder = responders.getKnownResponder();
            return responder == null || responder.isOptional() || responder.getParent().getName().equals("NSObject") && responder.getParent().getCategoryName() != null;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        OCSendMessageExpression sendMessage = (OCSendMessageExpression)PsiTreeUtil.getParentOfType((PsiElement)element, OCSendMessageExpression.class, (boolean)false);
        OCStatement statement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)sendMessage, OCStatement.class);
        if (statement != null) {
            new OCIfRespondsToSurrounder().doSurroundElements(project, new PsiElement[]{statement}, sendMessage);
        }
    }
}

