/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.intentions.OCBraceToggleBaseIntentionAction;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCStatementWithoutBracesIntentionAction
extends OCBraceToggleBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance(OCStatementWithoutBracesIntentionAction.class);

    @NotNull
    public String getFamilyName() {
        return OCInspectionsBundle.message("intentions.add.braces.statement", this.getStatementName());
    }

    @Override
    protected void doRun(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        OCStatement statement = OCStatementWithoutBracesIntentionAction.getParentStatement(element);
        LOG.assertTrue(statement != null);
        PsiElement bodyElement = this.getBodyElement(statement, element);
        LOG.assertTrue(bodyElement != null);
        int moveCaretBy = OCStatementWithoutBracesIntentionAction.getCaretAdjustment(bodyElement, editor);
        OCBlockStatement newBodyElement = OCStatementWithoutBracesIntentionAction.surroundByBracesAndReplace(bodyElement);
        LOG.assertTrue(newBodyElement.getStatements().size() == 1);
        OCStatementWithoutBracesIntentionAction.adjustCaret(newBodyElement, editor, moveCaretBy);
        OCStatementWithoutBracesIntentionAction.reformat(project, editor.getDocument(), statement);
    }

    @Override
    protected boolean isValidElement(@NotNull OCStatement statement, @NotNull PsiElement element) {
        OCExpression nextExpr;
        PsiElement nextSibling;
        PsiElement expr = this.getBodyElement(statement, element);
        if (expr == null) {
            return false;
        }
        if (expr.getPrevSibling() instanceof OCMacroCall && (nextSibling = statement.getNextSibling()) instanceof OCExpressionStatement && OCElementUtil.isPartOfMacroSubstitution(nextExpr = ((OCExpressionStatement)nextSibling).getExpression())) {
            return false;
        }
        return !(expr instanceof OCBlockStatement);
    }

    @NotNull
    private static OCBlockStatement surroundByBracesAndReplace(@NotNull PsiElement bodyElement) {
        PsiElement leftMostSibling = OCStatementWithoutBracesIntentionAction.getLeftMostMacroCallOrWhiteSpaceSibling(bodyElement);
        OCBlockStatement blockStatement = (OCBlockStatement)OCElementFactory.statementFromText("{}", bodyElement);
        PsiElement rightMostSibling = OCStatementWithoutBracesIntentionAction.getRightMostMacroCallOrWhiteSpaceSibling(bodyElement);
        blockStatement.addRangeAfter(leftMostSibling, rightMostSibling, blockStatement.getOpeningBrace());
        if (leftMostSibling != bodyElement) {
            bodyElement.getParent().deleteChildRange(leftMostSibling, bodyElement.getPrevSibling());
        }
        if (rightMostSibling != bodyElement) {
            bodyElement.getParent().deleteChildRange(bodyElement.getNextSibling(), rightMostSibling);
        }
        return (OCBlockStatement)bodyElement.replace((PsiElement)blockStatement);
    }

    private static int getCaretAdjustment(@NotNull PsiElement bodyElement, @NotNull Editor editor) {
        PsiElement prevSibling = bodyElement.getPrevSibling();
        PsiElement nestedExpr = OCStatementWithoutBracesIntentionAction.getMacroOrElement(bodyElement, prevSibling);
        CaretModel caretModel = editor.getCaretModel();
        return OCStatementWithoutBracesIntentionAction.getCaretAdjustment(caretModel, nestedExpr);
    }

    private static void adjustCaret(@NotNull OCBlockStatement newElement, @NotNull Editor editor, int moveCaretBy) {
        PsiElement bodyElement = newElement.getStatements().get(0);
        PsiElement caretAnchor = OCStatementWithoutBracesIntentionAction.getMacroOrElement(bodyElement);
        OCStatementWithoutBracesIntentionAction.moveCaret(editor.getCaretModel(), moveCaretBy, caretAnchor);
    }
}

