/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMoveIvarsToImplementationIntentionAction
implements IntentionAction {
    @NotNull
    public String getText() {
        return OCInspectionsBundle.message("intentions.move.instance.variables", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        Pair<OCInstanceVariablesList, OCInstanceVariablesList> pair = this.locateCandidate(editor, file);
        return OCCompilerFeaturesHelper.supportsIvarsInImplementation() && pair != null && OCCodeInsightUtil.isValid((PsiElement)pair.getFirst()) && OCCodeInsightUtil.isValid((PsiElement)pair.getSecond()) && !((OCInstanceVariablesList)pair.getFirst()).isEmpty() && ((OCInstanceVariablesList)pair.getSecond()).isEmpty();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        Pair<OCInstanceVariablesList, OCInstanceVariablesList> pair = this.locateCandidate(editor, file);
        if (pair != null) {
            PsiFile srcFile = ((OCInstanceVariablesList)pair.getFirst()).getContainingFile();
            if (!FileModificationService.getInstance().prepareFileForWrite(srcFile)) {
                return;
            }
            PsiFile dstFile = ((OCInstanceVariablesList)pair.getSecond()).getContainingFile();
            if (!FileModificationService.getInstance().prepareFileForWrite(dstFile)) {
                return;
            }
            OCChangeUtil.changeText(project, dstFile, ((OCInstanceVariablesList)pair.getSecond()).getTextOffset(), 0, ((OCInstanceVariablesList)pair.getFirst()).getTextWithMacros(), true);
            OCChangeUtil.changeText(project, srcFile, ((OCInstanceVariablesList)pair.getFirst()).getTextOffset(), ((OCInstanceVariablesList)pair.getFirst()).getTextLength(), "", true);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nullable
    protected Pair<OCInstanceVariablesList, OCInstanceVariablesList> locateCandidate(Editor editor, PsiFile file) {
        PsiElement implementation;
        PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
        OCInstanceVariablesList intfList = OCElementUtil.getAdjacentParentOfType(at, OCInstanceVariablesList.class);
        OCInterface anInterface = (OCInterface)PsiTreeUtil.getParentOfType((PsiElement)intfList, OCInterface.class);
        if (anInterface == null) {
            return null;
        }
        OCInterfaceSymbol interfaceSymbol = anInterface.getSymbol();
        Project project = file.getProject();
        OCImplementationSymbol implementationSymbol = interfaceSymbol != null ? interfaceSymbol.getImplementation(project) : null;
        PsiElement psiElement = implementation = implementationSymbol != null ? implementationSymbol.locateDefinition(project) : null;
        if (implementation instanceof OCClassDeclaration) {
            return Pair.create((Object)intfList, (Object)((OCClassDeclaration)implementation).getInstanceVariablesList());
        }
        return null;
    }
}

