/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class OCMergeElseIfIntention
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        OCStatement statement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)element, OCStatement.class);
        if (statement == null) {
            return false;
        }
        if (this.checkStatement(statement)) {
            return OCMergeElseIfIntention.checkCursorAtElseKeyword(editor, (OCIfStatement)statement);
        }
        OCStatement parentStatement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, OCStatement.class);
        if (parentStatement instanceof OCBlockStatement) {
            while (parentStatement instanceof OCBlockStatement) {
                parentStatement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)parentStatement, OCStatement.class);
            }
            return this.checkStatement(parentStatement) && OCMergeElseIfIntention.checkCursorInAppropriatePosition(editor, statement);
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        return OCInspectionsBundle.message("intentions.merge.if.else", new Object[0]);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        OCStatement parentStatement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)element, OCStatement.class);
        if (parentStatement == null) {
            return;
        }
        if (!this.checkStatement(parentStatement)) {
            parentStatement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)parentStatement, OCIfStatement.class);
        }
        if (parentStatement == null) {
            return;
        }
        OCIfStatement parentIfStatement = (OCIfStatement)parentStatement;
        OCStatement childStatement = OCParenthesesUtils.stripBraces(parentIfStatement.getElseBranch());
        if (!(childStatement instanceof OCIfStatement)) {
            return;
        }
        parentIfStatement.getElseBranch().replace(childStatement);
    }

    public static boolean checkCursorInAppropriatePosition(@NotNull Editor editor, OCStatement statement) {
        if (statement instanceof OCIfStatement) {
            OCIfStatement ifStatement = (OCIfStatement)statement;
            ASTNode rParenth = ifStatement.getRParenth();
            ASTNode elseKeyword = ifStatement.getElseKeyword();
            int offset = editor.getCaretModel().getOffset();
            return rParenth != null && offset <= rParenth.getStartOffset() || elseKeyword != null && offset >= elseKeyword.getStartOffset() && offset <= elseKeyword.getStartOffset() + elseKeyword.getTextLength();
        }
        return false;
    }

    public static boolean checkCursorAtElseKeyword(@NotNull Editor editor, OCIfStatement statement) {
        ASTNode elseKeyword = statement.getElseKeyword();
        int offset = editor.getCaretModel().getOffset();
        return elseKeyword != null && offset >= elseKeyword.getStartOffset() && offset <= elseKeyword.getStartOffset() + elseKeyword.getTextLength();
    }

    private boolean checkStatement(OCStatement statement) {
        if (statement instanceof OCIfStatement) {
            this.setText(this.getFamilyName());
            OCIfStatement ifStatement = (OCIfStatement)statement;
            OCStatement elseBranch = ifStatement.getElseBranch();
            if (elseBranch instanceof OCIfStatement) {
                return false;
            }
            elseBranch = OCParenthesesUtils.stripBraces(elseBranch);
            return elseBranch instanceof OCIfStatement;
        }
        return false;
    }
}

