/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCIntroduceTypeDefIntentionAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        OCDeclarator declarator = (OCDeclarator)PsiTreeUtil.getParentOfType((PsiElement)element, OCDeclarator.class, (boolean)false);
        if (declarator == null) {
            return false;
        }
        OCDeclaration declaration = (OCDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, OCDeclaration.class, (boolean)false);
        if (declaration == null || declaration instanceof OCFunctionDefinition || declaration instanceof OCParameterDeclaration) {
            return false;
        }
        if (declarator.getParameterList() != null) {
            return false;
        }
        List<OCDeclarator> declarators = declaration.getDeclarators();
        if (declarators.size() != 1) {
            return false;
        }
        OCType type = declarator.getType();
        if (OCIntroduceTypeDefIntentionAction.isComplexType(type, false, false)) {
            this.setText(OCInspectionsBundle.message("intentions.introduce.typedef.for.type", type.getBestNameInContext(element)));
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        OCDeclarator declarator = (OCDeclarator)PsiTreeUtil.getParentOfType((PsiElement)element, OCDeclarator.class, (boolean)false);
        if (declarator != null) {
            String name = declarator.getName();
            if (declarator.getParent() instanceof OCDeclaration) {
                OCDeclaration declaration = (OCDeclaration)declarator.getParent();
                OCDeclaration typedefDeclaration = (OCDeclaration)declaration.copy();
                PsiFile psiFile = element.getContainingFile();
                PsiElement typedef = OCElementFactory.typeElementFromText("typedef int", (PsiElement)psiFile).getFirstChild();
                typedefDeclaration.addBefore(typedef.getNextSibling(), typedefDeclaration.getFirstChild());
                typedefDeclaration.addBefore(typedef, typedefDeclaration.getFirstChild());
                OCChangeUtil.addBefore((PsiElement)psiFile, typedefDeclaration, declaration);
                OCTypeElement type = OCElementFactory.typeElementFromText(name, declaration);
                declaration.replace(OCElementFactory.declarationByNameAndType(name, type.getType(), declaration));
            }
        }
    }

    private static boolean isComplexType(@NotNull OCType type, boolean hasPointer, boolean hasArray) {
        if (type instanceof OCPointerType) {
            if (hasArray) {
                return true;
            }
            if (hasPointer) {
                return true;
            }
            return OCIntroduceTypeDefIntentionAction.isComplexType(((OCPointerType)type).getRefType(), true, hasArray);
        }
        if (type instanceof OCReferenceType) {
            return false;
        }
        return type instanceof OCFunctionType;
    }

    @NotNull
    public String getFamilyName() {
        return OCInspectionsBundle.message("intentions.introduce.typedef", new Object[0]);
    }
}

