/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.generate.actions.OCOverrideImplementActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCGenerateIvarsHandler;
import com.jetbrains.cidr.lang.generate.handlers.implement.OCImplementOCMethodsHandler;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCImplementPropertyAccessorsIntentionAction
extends OCImplementOCMethodsHandler
implements IntentionAction {
    @NotNull
    public String getText() {
        return OCInspectionsBundle.message("intentions.implement.accessor.methods", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Nullable
    protected static OCPropertySymbol locateProperty(@NotNull Project project, @Nullable Editor editor, PsiFile file) {
        if (editor == null) {
            return null;
        }
        PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
        OCDeclarator parent = OCElementUtil.getAdjacentParentOfType(at, OCDeclarator.class);
        if (parent != null) {
            OCSymbol symbol = parent.getSymbol();
            return symbol instanceof OCPropertySymbol && OCGenerateIvarsHandler.isPropertyDefective((OCPropertySymbol)symbol, project) ? (OCPropertySymbol)symbol : null;
        }
        return null;
    }

    @Override
    protected boolean defaultShowSynthesizedAccessors() {
        return true;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (!FileSymbolTablesCache.areSymbolsLoaded(project)) {
            return false;
        }
        return OCCompilerFeaturesHelper.supportsAutosynthesis(file) && OCSearchScope.isInProjectSources(OCImplementPropertyAccessorsIntentionAction.locateProperty(project, editor, file), project);
    }

    @Override
    protected OCClassSymbol getParent(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        OCPropertySymbol prop = OCImplementPropertyAccessorsIntentionAction.locateProperty(project, editor, file);
        return prop != null ? prop.getParent().getMainInterface(project) : null;
    }

    @Override
    @NotNull
    protected Collection<OCMethodSymbol> getSelectedCandidates(@NotNull OCOverrideImplementActionContext context, @Nullable Editor editor, @NotNull PsiFile file, @NotNull List<OCMethodSymbol> candidates) {
        PsiElement elementContext = context.getContext();
        final OCPropertySymbol property = OCImplementPropertyAccessorsIntentionAction.locateProperty(elementContext.getProject(), editor, elementContext.getContainingFile());
        CommonProcessors.CollectProcessor<OCMethodSymbol> collector = new CommonProcessors.CollectProcessor<OCMethodSymbol>(){

            public boolean process(OCMethodSymbol method) {
                if (method.getGeneratedFromProperty() == property) {
                    return super.process((Object)method);
                }
                return true;
            }
        };
        if (property != null) {
            property.getParent().processMembers(OCMethodSymbol.class, collector);
        }
        return collector.getResults();
    }
}

