/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateDefinitionActionHandler;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.ui.OCLongActionUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCGenerateDefinitionsIntentionActionBase
implements IntentionAction {
    @Nls
    @NotNull
    public String getFamilyName() {
        return OCBundle.message("generate.definitions.intention.familyName", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        assert (editor != null);
        OCFunctionSymbol function = OCGenerateDefinitionsIntentionActionBase.findSuitableFunction(editor, file);
        if (function == null) {
            return false;
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            Boolean result = (Boolean)OCLongActionUtil.runReadActionInBackgroundAndWait(() -> OCGenerateDefinitionsIntentionActionBase.shouldGenerateDefinitionFor(function, project), 1000L);
            return result != null ? result : true;
        }
        return OCGenerateDefinitionsIntentionActionBase.shouldGenerateDefinitionFor(function, project);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        OCFunctionSymbol symbol = OCGenerateDefinitionsIntentionActionBase.findSuitableFunction(editor, file);
        if (symbol == null) {
            return;
        }
        new OCGenerateDefinitionActionHandler(project, file, symbol, OCCppDefinitionsUtil.InlinePolicy.get(this.isInline()), true).invoke();
    }

    public boolean startInWriteAction() {
        return false;
    }

    protected abstract boolean isInline();

    @Nullable
    private static OCFunctionSymbol findSuitableFunction(@NotNull Editor editor, @NotNull PsiFile file) {
        PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
        OCFunctionDeclaration function = (OCFunctionDeclaration)PsiTreeUtil.getParentOfType((PsiElement)at, OCFunctionDeclaration.class);
        OCSymbolWithQualifiedName symbol = function != null ? (OCSymbolWithQualifiedName)function.getSymbol() : null;
        OCFunctionSymbol functionSymbol = (OCFunctionSymbol)ObjectUtils.tryCast((Object)symbol, OCFunctionSymbol.class);
        if (functionSymbol == null || functionSymbol.getParent() instanceof OCStructSymbol) {
            return null;
        }
        if (functionSymbol.getQualifier() != null) {
            return null;
        }
        return functionSymbol;
    }

    private static boolean shouldGenerateDefinitionFor(OCFunctionSymbol function, @NotNull Project project) {
        return function != null && OCCppDefinitionsUtil.shouldGenerateDefinitionsFor(function, true, project) == OCCppDefinitionsUtil.SHOULD_GENERATE_DEFINITION.POSSIBLE;
    }
}

