/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.intentions.OCConvertToIfIntentionActionBase;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCExtractIfIntentionAction
extends OCConvertToIfIntentionActionBase {
    @NotNull
    public String getFamilyName() {
        return OCInspectionsBundle.message("intentions.extract.if", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        OCExpression expression = OCExtractIfIntentionAction.findExpression(editor, element);
        if (expression != null) {
            this.setText(OCInspectionsBundle.message("intentions.extract.if.with.text", expression.getTextWithMacros()));
            return true;
        }
        return false;
    }

    @Nullable
    private static OCExpression findExpression(Editor editor, PsiElement element) {
        for (PsiElement parent = element.getParent(); parent != null; parent = parent.getParent()) {
            if (element instanceof OCExpression && parent instanceof OCBinaryExpression && OCTokenTypes.LOGIC_OPERATIONS.contains((IElementType)((OCBinaryExpression)parent).getOperationSign()) && element.getTextRange().getStartOffset() <= editor.getSelectionModel().getSelectionStart() && element.getTextRange().getEndOffset() >= editor.getSelectionModel().getSelectionEnd()) {
                return (OCExpression)element;
            }
            element = parent;
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        OCExpression expression = OCExtractIfIntentionAction.findExpression(editor, element);
        if (expression != null) {
            OCExpression falseExpr = OCElementFactory.expressionFromText("0", element);
            OCExpression trueExpr = OCElementFactory.expressionFromText("1", element);
            this.invoke(expression, expression, trueExpr, falseExpr);
        }
    }
}

