/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.generate.handlers.OCDeclareActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCDeclareMembersHandler;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDeclareMethodInInterfaceIntentionAction
extends OCDeclareMembersHandler
implements IntentionAction {
    @NotNull
    public String getText() {
        return OCInspectionsBundle.message("intentions.declare.method.in.interface", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    @Nullable
    protected OCMethodSymbol locateCandidate(@NotNull Project project, Editor editor, PsiFile file) {
        PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
        OCMethod method = (OCMethod)PsiTreeUtil.getParentOfType((PsiElement)at, OCMethod.class, (boolean)false, (Class[])new Class[]{OCBlockStatement.class});
        return method != null ? (OCMethodSymbol)method.getSymbol() : null;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        OCMethodSymbol method = this.locateCandidate(project, editor, file);
        return method != null && OCSearchScope.isInProjectSources(method, project) && method.isDefinition() && method.getAssociatedSymbol(project) == null;
    }

    @Override
    protected boolean enableChooseDialog(Collection<OCMemberSymbol> candidates) {
        return false;
    }

    @Override
    @NotNull
    protected OCDeclareActionContext evaluateActionContext(OCClassSymbol parent, @NotNull PsiElement element) {
        OCDeclareActionContext context = super.evaluateActionContext(parent, element);
        context.setTarget(OCDeclareActionContext.Target.INTERFACE);
        return context;
    }
}

