/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDeMorganIntentionAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        OCBinaryExpression expression = (OCBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, OCBinaryExpression.class, (boolean)false);
        if (expression != null && expression.getRight() != null) {
            if (expression.getOperationSign() == OCTokenTypes.ANDAND) {
                this.setText(OCInspectionsBundle.message("intentions.replace.and.with.or", new Object[0]));
                return true;
            }
            if (expression.getOperationSign() == OCTokenTypes.OROR) {
                this.setText(OCInspectionsBundle.message("intentions.replace.or.with.and", new Object[0]));
                return true;
            }
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        return OCInspectionsBundle.message("intentions.deMorgan.law", new Object[0]);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        OCBinaryExpression binaryExpression = (OCBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, OCBinaryExpression.class, (boolean)false);
        if (binaryExpression != null) {
            OCElementType operationSign = binaryExpression.getOperationSign();
            PsiElement parent = binaryExpression.getParent();
            while (OCDeMorganIntentionAction.isConjunctionExpression(parent, operationSign)) {
                binaryExpression = (OCBinaryExpression)parent;
                parent = binaryExpression.getParent();
            }
            OCExpression newExpression = OCDeMorganIntentionAction.convertConjunctionExpression(binaryExpression, operationSign);
            if (newExpression != null) {
                OCDeMorganIntentionAction.replaceExpression(newExpression, binaryExpression);
            }
        }
    }

    @Nullable
    private static OCExpression convertConjunctionExpression(@NotNull OCBinaryExpression expression, @NotNull OCElementType operatorSign) {
        OCExpression leftExpression = OCDeMorganIntentionAction.convertExpressionPart(expression.getLeft(), operatorSign);
        OCExpression rightExpression = OCDeMorganIntentionAction.convertExpressionPart(expression.getRight(), operatorSign);
        if (leftExpression == null || rightExpression == null) {
            return null;
        }
        int leftPrecedence = OCParenthesesUtils.getPrecedence(leftExpression, false);
        int rightPrecedence = OCParenthesesUtils.getPrecedence(rightExpression, false);
        OCElementType operator = OCCodeInsightUtil.getInversedLogicalOperator(operatorSign);
        int operatorPrecedence = OCParenthesesUtils.getPrecedence(operator);
        if (leftPrecedence > operatorPrecedence) {
            leftExpression = OCParenthesesUtils.appendParentheses(leftExpression);
        }
        if (rightPrecedence > operatorPrecedence) {
            rightExpression = OCParenthesesUtils.appendParentheses(rightExpression);
        }
        return OCElementFactory.binaryExpression(leftExpression, rightExpression, operator);
    }

    @Nullable
    private static OCExpression convertExpressionPart(@Nullable OCExpression expression, @NotNull OCElementType operatorSign) {
        if (expression == null) {
            return null;
        }
        if (OCDeMorganIntentionAction.isConjunctionExpression(expression, operatorSign)) {
            return OCDeMorganIntentionAction.convertConjunctionExpression((OCBinaryExpression)expression, operatorSign);
        }
        return OCDeMorganIntentionAction.convertLeafExpression(expression);
    }

    @Nullable
    private static OCExpression convertLeafExpression(@NotNull OCExpression expression) {
        OCBinaryExpression binaryExpression;
        OCElementType operationSign;
        OCElementType oppositeOperator;
        if (OCDeMorganIntentionAction.isNegated(expression)) {
            OCExpression negated = OCDeMorganIntentionAction.stripNegation((OCUnaryExpression)expression);
            if (negated == null) {
                return null;
            }
            if (OCParenthesesUtils.getPrecedence(negated, false) > 15) {
                return OCParenthesesUtils.appendParentheses(negated);
            }
            return negated;
        }
        if (expression instanceof OCBinaryExpression && (oppositeOperator = OCCodeInsightUtil.getOppositeOperator(operationSign = (binaryExpression = (OCBinaryExpression)expression).getOperationSign())) != null) {
            OCExpression left = binaryExpression.getLeft();
            OCExpression right = binaryExpression.getRight();
            return left != null && right != null ? OCElementFactory.binaryExpression(left, right, oppositeOperator) : null;
        }
        boolean appendParentheses = OCParenthesesUtils.getPrecedence(expression, false) > 4;
        return OCElementFactory.unaryExpression(appendParentheses ? OCParenthesesUtils.appendParentheses(expression) : expression, (OCElementType)OCTokenTypes.EXCL);
    }

    private static boolean isConjunctionExpression(@Nullable PsiElement element, @NotNull OCElementType operatorSign) {
        if (element instanceof OCBinaryExpression) {
            OCBinaryExpression binaryExpression = (OCBinaryExpression)element;
            OCElementType tokenType = binaryExpression.getOperationSign();
            return tokenType.equals(operatorSign);
        }
        return false;
    }

    private static void replaceExpression(@NotNull OCExpression newExpression, @NotNull OCExpression oldExpression) throws IncorrectOperationException {
        boolean parenthesesAreRequired;
        OCExpression expressionToReplace;
        OCExpression negatedParent = OCDeMorganIntentionAction.findFirstNegatedParent(oldExpression);
        OCExpression oCExpression = expressionToReplace = negatedParent != null ? negatedParent : oldExpression;
        if (negatedParent == null) {
            newExpression = OCElementFactory.unaryExpression(OCParenthesesUtils.appendParentheses(newExpression), (OCElementType)OCTokenTypes.EXCL);
        }
        if (parenthesesAreRequired = OCDeMorganIntentionAction.parenthesesAreRequired(newExpression, expressionToReplace)) {
            newExpression = OCParenthesesUtils.appendParentheses(newExpression);
        }
        OCChangeUtil.replaceHandlingMacros(expressionToReplace, newExpression);
    }

    @Nullable
    private static OCExpression findFirstNegatedParent(@NotNull OCExpression expression) {
        OCUnaryExpression prefixAncestor;
        OCExpression ancestor = expression;
        while (ancestor.getParent() instanceof OCParenthesizedExpression) {
            ancestor = (OCExpression)ancestor.getParent();
        }
        if (ancestor.getParent() instanceof OCUnaryExpression && OCTokenTypes.EXCL == (prefixAncestor = (OCUnaryExpression)ancestor.getParent()).getOperationSign()) {
            return prefixAncestor;
        }
        return null;
    }

    private static boolean isNegated(@Nullable OCExpression expression) {
        if (expression instanceof OCUnaryExpression) {
            OCUnaryExpression unary = (OCUnaryExpression)expression;
            return unary.getOperationSign() == OCTokenTypes.EXCL;
        }
        return false;
    }

    @Nullable
    private static OCExpression stripNegation(@NotNull OCUnaryExpression expression) {
        if (OCElementUtil.isPartOfMacroSubstitution(expression)) {
            return null;
        }
        OCExpression operand = expression.getOperand();
        if (operand != null) {
            return OCElementUtil.isPartOfMacroSubstitution(operand) ? operand : OCParenthesesUtils.diveIntoParentheses(operand);
        }
        return null;
    }

    private static boolean parenthesesAreRequired(@NotNull OCExpression newExpression, @NotNull OCExpression sourceExpression) {
        if (newExpression instanceof OCParenthesizedExpression) {
            return false;
        }
        PsiElement parent = sourceExpression.getParent();
        if (!(parent instanceof OCExpression)) {
            return false;
        }
        OCExpression parentExpression = (OCExpression)parent;
        int newExpressionPrecedence = OCParenthesesUtils.getPrecedence(newExpression, false);
        int parentExpressionPrecedence = OCParenthesesUtils.getPrecedence(parentExpression, false);
        if (newExpressionPrecedence <= 0 || parentExpressionPrecedence <= 0) {
            return false;
        }
        return newExpressionPrecedence > parentExpressionPrecedence;
    }
}

