/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.OCRefactoringBundle;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateFromIvarsActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCGeneratePropertiesHandler;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.introduce.OCBaseLocalConvertibleHandler;
import com.jetbrains.cidr.lang.refactoring.introduce.OCPropertyInplaceIntroducer;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCConvertToPropertyIntentionAction
extends OCGeneratePropertiesHandler
implements IntentionAction {
    @NotNull
    public String getText() {
        return OCInspectionsBundle.message("intentions.convert.to.property", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    @Nullable
    public OCInstanceVariableSymbol locateCandidate(@NotNull Project project, Editor editor, PsiFile file) {
        PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
        Object parent = OCElementUtil.getAdjacentParentOfType(at, OCReferenceElement.class, OCDeclarator.class, OCQualifiedExpression.class);
        OCSymbol symbol = null;
        if (parent instanceof OCReferenceElement) {
            symbol = ((OCReferenceElement)parent).resolveToSymbol();
        } else if (parent instanceof OCDeclarator) {
            symbol = ((OCDeclarator)parent).getSymbol();
        } else if (parent instanceof OCQualifiedExpression) {
            symbol = ((OCQualifiedExpression)parent).resolveToSymbol();
        }
        return symbol instanceof OCInstanceVariableSymbol ? (OCInstanceVariableSymbol)symbol : null;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return OCSearchScope.isInProjectSources(this.locateCandidate(project, editor, file), project);
    }

    @Override
    protected OCClassSymbol getParent(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        OCInstanceVariableSymbol ivar = this.locateCandidate(project, editor, file);
        return ivar != null ? ivar.getParent().getMainInterface(project) : null;
    }

    @Override
    protected boolean replaceAllIvars() {
        return true;
    }

    @Override
    protected boolean enableChooseDialog(Collection<OCInstanceVariableSymbol> candidates) {
        return false;
    }

    @Override
    @NotNull
    protected Condition<OCInstanceVariableSymbol> getCandidatesFilter(@NotNull OCGenerateFromIvarsActionContext actionContext) {
        return Conditions.alwaysTrue();
    }

    @Override
    protected void performAction(@NotNull Project project, Editor editor, final @NotNull PsiFile file, final @NotNull OCGenerateFromIvarsActionContext context, final @NotNull List<OCInstanceVariableSymbol> ivars) {
        final OCInstanceVariableSymbol ivar = this.locateCandidate(project, editor, file);
        if (ivar == null) {
            return;
        }
        OCPropertySymbol associatedProperty = ivar.getAssociatedProperty(project);
        PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
        final OCElement element = (OCElement)OCElementUtil.getAdjacentParentOfType(at, OCReferenceElement.class, OCDeclarator.class, OCQualifiedExpression.class);
        final String propName = associatedProperty != null ? associatedProperty.getName() : OCNameSuggester.getNonCollidingName(ivar, true, project);
        final SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)element);
        OCBaseLocalConvertibleHandler handler = new OCBaseLocalConvertibleHandler(OCRefactoringBundle.message("refactoring.introduce.property.name", new Object[0])){

            protected OCPropertyInplaceIntroducer createIntroducer(Project project, final Editor editor, PsiElement expression, List<PsiElement> occurrences, @NlsContexts.Command String refactoringName) {
                return new OCPropertyInplaceIntroducer(project, editor, expression, occurrences, refactoringName){

                    @Override
                    public PsiElement evaluateAnchor() {
                        return element;
                    }

                    public PsiElement[] getOccurrences() {
                        PsiElement[] psiElementArray;
                        PsiElement occurrence = pointer.getElement();
                        if (occurrence != null) {
                            PsiElement[] psiElementArray2 = new PsiElement[1];
                            psiElementArray = psiElementArray2;
                            psiElementArray2[0] = occurrence;
                        } else {
                            psiElementArray = PsiElement.EMPTY_ARRAY;
                        }
                        return psiElementArray;
                    }

                    @Override
                    protected void performIntroduce() {
                        OCConvertToPropertyIntentionAction.this.performAction(file, context, ivars, this.getInputName(), (OCPropertySymbol.PropertySemantics)((Object)this.mySemantics.compute()), this.myReadonly, this.isConvertUsages(), this.myPutToPrivateCategoryCB != null && this.myPutToPrivateCategoryCB.isSelected());
                    }

                    @Override
                    protected boolean askToGenerateSynthesize() {
                        return false;
                    }

                    @Override
                    protected boolean askToConvertUsages() {
                        if (!OCCompilerFeaturesHelper.supportsAutosynthesis(file)) {
                            return false;
                        }
                        PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
                        Object parent = OCElementUtil.getAdjacentParentOfType(at, OCReferenceElement.class, OCDeclarator.class, OCQualifiedExpression.class);
                        return !(parent instanceof OCQualifiedExpression);
                    }

                    @Override
                    protected String[] suggestNames(boolean replaceAll, @Nullable OCDeclarator variable) {
                        if (!propName.equals(ivar.getName())) {
                            return new String[]{propName, ivar.getName()};
                        }
                        return new String[]{propName};
                    }
                };
            }

            @Override
            @NotNull
            protected String getFeatureID() {
                return "refactoring.convertToProperty";
            }
        };
        handler.invoke(project, editor, element, ivar.getResolvedType(OCResolveContext.forPsi((PsiElement)file)), true, false, propName, ivar.getParent());
    }
}

