/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.util.EditorScrollingPositionKeeper;
import com.intellij.openapi.editor.impl.ImaginaryEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.MathUtil;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCatchSection;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStatementWithExpression;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCBraceToggleBaseIntentionAction
extends PsiElementBaseIntentionAction {
    @NonNls
    protected String myKeywordName = "";

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @Nullable
    protected PsiElement getBodyElement(@NotNull OCStatement statement, @NotNull PsiElement element) {
        OCStatement expr = null;
        if (statement instanceof OCStatementWithExpression && !(statement instanceof OCCatchSection)) {
            OCStatementWithExpression stmtWithExpr = (OCStatementWithExpression)statement;
            expr = stmtWithExpr.getBody();
        } else if (statement instanceof OCIfStatement) {
            OCIfStatement ifStatement = (OCIfStatement)statement;
            expr = OCBraceToggleBaseIntentionAction.isAfterElse(ifStatement, element) ? ifStatement.getElseBranch() : ifStatement.getThenBranch();
        }
        return expr;
    }

    @NonNls
    @NotNull
    protected String getStatementName() {
        return this.myKeywordName;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        OCStatement statement = OCBraceToggleBaseIntentionAction.getParentStatement(element);
        if (statement == null || statement instanceof OCCatchSection) {
            return false;
        }
        this.myKeywordName = OCBraceToggleBaseIntentionAction.getKeywordName(statement, element);
        return this.isValidElement(statement, element);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (editor instanceof ImaginaryEditor) {
            this.doRun(project, editor, element);
        } else {
            EditorScrollingPositionKeeper.perform((Editor)editor, (boolean)false, () -> this.doRun(project, editor, element));
        }
    }

    protected abstract boolean isValidElement(@NotNull OCStatement var1, @NotNull PsiElement var2);

    protected abstract void doRun(@NotNull Project var1, Editor var2, @NotNull PsiElement var3) throws IncorrectOperationException;

    @NotNull
    protected static PsiElement getMacroOrElement(@NotNull PsiElement elem) {
        return OCBraceToggleBaseIntentionAction.getMacroOrElement(elem, elem.getPrevSibling());
    }

    @NotNull
    protected static PsiElement getMacroOrElement(@NotNull PsiElement element, @Nullable PsiElement prevSibling) {
        return prevSibling instanceof OCMacroCall ? prevSibling : element;
    }

    private static boolean isAfterElse(@NotNull OCIfStatement ifStmt, @NotNull PsiElement start) {
        if (start.getNode().getElementType() == OCTokenTypes.ELSE_KEYWORD) {
            return true;
        }
        ASTNode elseKeyword = ifStmt.getElseKeyword();
        if (elseKeyword == null) {
            return false;
        }
        int elseOffset = elseKeyword.getStartOffset();
        return start.getTextOffset() >= elseOffset;
    }

    @NotNull
    private static String getKeywordName(@NotNull OCStatement statement, @NotNull PsiElement element) {
        if (statement instanceof OCStatementWithExpression) {
            OCStatementWithExpression stmtWithExpr = (OCStatementWithExpression)statement;
            return stmtWithExpr.getKeywordType().getName();
        }
        if (statement instanceof OCIfStatement) {
            OCIfStatement ifStmt = (OCIfStatement)statement;
            return OCBraceToggleBaseIntentionAction.isAfterElse(ifStmt, element) ? OCTokenTypes.ELSE_KEYWORD.getName() : OCTokenTypes.IF_KEYWORD.getName();
        }
        return "";
    }

    @Nullable
    protected static OCStatement getParentStatement(@NotNull PsiElement element) {
        return (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{OCStatementWithExpression.class, OCIfStatement.class});
    }

    @NotNull
    protected static PsiElement getRightMostMacroCallOrWhiteSpaceSibling(@NotNull PsiElement element) {
        PsiElement result = element;
        while (result.getNextSibling() != null && OCBraceToggleBaseIntentionAction.isMacroCallOrWhiteSpace(result.getNextSibling())) {
            result = result.getNextSibling();
        }
        return result;
    }

    @NotNull
    protected static PsiElement getLeftMostMacroCallOrWhiteSpaceSibling(@NotNull PsiElement element) {
        PsiElement result = element;
        while (result.getPrevSibling() != null && OCBraceToggleBaseIntentionAction.isMacroCallOrWhiteSpace(result.getPrevSibling())) {
            result = result.getPrevSibling();
        }
        return result;
    }

    private static boolean isMacroCallOrWhiteSpace(@NotNull PsiElement element) {
        return element instanceof OCMacroCall || OCLexerTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(OCElementUtil.getElementType(element));
    }

    @NotNull
    protected static PsiElement getFirstMacroElement(@NotNull PsiElement elem) {
        PsiElement cur = elem;
        while (cur.getPrevSibling() instanceof OCMacroCall) {
            cur = cur.getPrevSibling();
        }
        return cur;
    }

    protected static int getCaretAdjustment(@NotNull CaretModel caretModel, @NotNull PsiElement element) {
        PsiElement offsetAnchor = OCBraceToggleBaseIntentionAction.getFirstMacroElement(element);
        int caretOffset = caretModel.getOffset();
        return Math.max(0, caretOffset - offsetAnchor.getTextOffset());
    }

    protected static void moveCaret(@NotNull CaretModel caretModel, int moveCaretBy, @NotNull PsiElement insertedElem) {
        if (caretModel.getCaretCount() != 1) {
            return;
        }
        PsiElement offsetAnchor = OCBraceToggleBaseIntentionAction.getFirstMacroElement(insertedElem);
        TextRange elemRange = offsetAnchor.getTextRange();
        int startOffset = elemRange.getStartOffset();
        int endOffset = elemRange.getEndOffset();
        int newCaretOffset = MathUtil.clamp((int)(startOffset + moveCaretBy), (int)startOffset, (int)endOffset);
        caretModel.moveToOffset(newCaretOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void reformat(@NotNull Project project, @NotNull Document document, @NotNull OCStatement statement) {
        RangeMarker formatRange = document.createRangeMarker(statement.getTextRange());
        try {
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
            OCFile file = statement.getContainingOCFile();
            OCChangeUtil.processPostponedFormatIfNeed(file);
            if (formatRange.isValid()) {
                codeStyleManager.reformatText((PsiFile)file, formatRange.getStartOffset(), formatRange.getEndOffset());
            }
        }
        finally {
            formatRange.dispose();
        }
    }
}

