/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateMethodActionContext;
import com.jetbrains.cidr.lang.generate.actions.OCObjCActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCClassActionHandlerBase;
import com.jetbrains.cidr.lang.generate.handlers.OCGenerateInitWithHandler;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCReleaseVariablesIntentionAction;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCParameterInfo;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAddParametersToInitWithIntentionAction
extends OCClassActionHandlerBase<OCClassSymbol, OCMethodSymbol, OCObjCActionContext<OCMethodSymbol>>
implements IntentionAction {
    @NotNull
    public String getText() {
        return OCInspectionsBundle.message("intentions.add.parameter.initWith", new Object[0]);
    }

    @Override
    @NotNull
    protected String getActionTitle() {
        return OCBundle.message("command.name.add.parameter.to.initwith", new Object[0]);
    }

    @Override
    protected String getMembersChooserTitle() {
        return OCBundle.message("dialog.title.select.initwith.method.to.update", new Object[0]);
    }

    @Override
    protected Class<? extends OCSymbolDeclarator> getParentClass() {
        return OCClassDeclaration.class;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return OCAddParametersToInitWithIntentionAction.getInstanceVariable(editor, file) != null;
    }

    @Nullable
    private static OCInstanceVariableSymbol getInstanceVariable(Editor editor, PsiFile file) {
        OCDeclaration declaration;
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        OCDeclarator declarator = OCElementUtil.getAdjacentParentOfType(element, OCDeclarator.class);
        if (declarator == null && (declaration = (OCDeclaration)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCDeclaration.class})) != null && declaration.getDeclarators().size() > 0) {
            declarator = declaration.getDeclarators().get(0);
        }
        if (declarator == null) {
            return null;
        }
        OCSymbol symbol = declarator.getSymbol();
        if (symbol instanceof OCInstanceVariableSymbol) {
            return (OCInstanceVariableSymbol)symbol;
        }
        if (symbol instanceof OCPropertySymbol) {
            return ((OCPropertySymbol)symbol).getAssociatedIvar(file.getProject());
        }
        return null;
    }

    @Nullable
    private static PsiElement getTargetInitializationBlock(OCMethod method) {
        if (method == null) {
            return null;
        }
        OCBlockStatement body = method.getBody();
        if (body == null) {
            return null;
        }
        List<OCStatement> statements = body.getStatements();
        if (statements.size() < 2 || !(statements.get(1) instanceof OCIfStatement)) {
            return null;
        }
        OCIfStatement ifStmt = (OCIfStatement)statements.get(1);
        if (ifStmt.getThenBranch() instanceof OCBlockStatement) {
            return ifStmt.getThenBranch();
        }
        return null;
    }

    @Override
    protected boolean enableChooseDialog(Collection<OCMethodSymbol> candidates) {
        return candidates.size() > 1;
    }

    @Override
    protected boolean allowMultiSelection(OCObjCActionContext<OCMethodSymbol> context) {
        return false;
    }

    @Override
    protected boolean allowEmptySelection(OCObjCActionContext<OCMethodSymbol> context) {
        return true;
    }

    @Override
    @NotNull
    protected OCObjCActionContext<OCMethodSymbol> evaluateActionContext(OCClassSymbol parent, @NotNull PsiElement element) {
        return new OCObjCActionContext<OCMethodSymbol>(parent, element, parent.getResolvedType(OCResolveContext.forPsi(element), true)){

            @Override
            @NotNull
            protected Class<OCMethodSymbol> getMemberSymbolClass() {
                return OCMethodSymbol.class;
            }

            @Override
            @NotNull
            public Collection<OCMethodSymbol> getMemberCandidates() {
                CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
                this.getImplementationSymbol().processMembers(this.getMemberSymbolClass(), (Processor)collector);
                return collector.getResults();
            }
        };
    }

    @Override
    @NotNull
    protected Condition<OCMethodSymbol> getCandidatesFilter(@NotNull OCObjCActionContext<OCMethodSymbol> actionContext) {
        return methodSymbol -> {
            if (!methodSymbol.getName().startsWith("initWith")) {
                return false;
            }
            PsiElement method = methodSymbol.locateDefinition(actionContext.getProject());
            return method instanceof OCMethod && OCAddParametersToInitWithIntentionAction.getTargetInitializationBlock((OCMethod)method) != null;
        };
    }

    @Override
    protected void performAction(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file, @NotNull OCObjCActionContext<OCMethodSymbol> context, @NotNull List<OCMethodSymbol> chosenCandidates) {
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        final OCInstanceVariableSymbol ivar = OCAddParametersToInitWithIntentionAction.getInstanceVariable(editor, file);
        if (ivar == null) {
            return;
        }
        if (chosenCandidates.size() == 0) {
            new OCGenerateInitWithHandler(){

                @Override
                @NotNull
                protected OCGenerateMethodActionContext evaluateActionContext(OCClassSymbol parent, @NotNull PsiElement element) {
                    OCGenerateMethodActionContext superContext = super.evaluateActionContext(parent, element);
                    return new OCGenerateMethodActionContext((OCClassSymbol)superContext.getParent(), Collections.singletonList(superContext.getBaseMethod()), superContext.getType(), element){

                        @Override
                        @NotNull
                        public Collection<OCInstanceVariableSymbol> getMemberCandidates() {
                            return Collections.singletonList(ivar);
                        }
                    };
                }

                @Override
                protected boolean enableChooseDialog(Collection<OCInstanceVariableSymbol> candidates) {
                    return false;
                }
            }.invoke(project, editor, file);
            return;
        }
        assert (chosenCandidates.size() == 1);
        PsiElement method = chosenCandidates.get(0).locateDefinition(project);
        if (!(method instanceof OCMethod)) {
            return;
        }
        OCClassDeclaration methodParent = (OCClassDeclaration)PsiTreeUtil.getParentOfType((PsiElement)method, OCClassDeclaration.class);
        OCChangeSignatureHandler handler = OCChangeSignatureActionHandler.getHandler((OCCallable)method, method);
        final OCParameterInfo newParameter = handler.addParameter(OCNameSuggester.getNonCollidingName(ivar, true, project), OCNameSuggester.getNonCollidingName(ivar, project), ivar.getType(), -1, false);
        handler.getGeneratedInfo().runOnSuccess(() -> {
            for (final OCCallable callable : handler.getNewCallables()) {
                if (methodParent != PsiTreeUtil.getParentOfType((PsiElement)callable, OCClassDeclaration.class)) continue;
                PsiElement block = OCAddParametersToInitWithIntentionAction.getTargetInitializationBlock((OCMethod)callable);
                if (block != null) {
                    OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, OCCodeStyleSettings.class);
                    ArrayList<OCInstanceVariableSymbol> nonReleasedIvars = new ArrayList<OCInstanceVariableSymbol>();
                    boolean useSetters = settings.USE_SETTERS_IN_CONSTRUCTOR;
                    boolean retainObjects = settings.RETAIN_OBJECT_PARAMETERS_IN_CONSTRUCTOR;
                    PsiFile file1 = block.getContainingFile();
                    String text = OCGenerateInitWithHandler.getInitializerText(Collections.singletonList(ivar), Collections.singletonList(newParameter), newParameter.getOldIndex(), file1, useSetters, retainObjects, nonReleasedIvars);
                    OCChangeUtil.add(block, OCElementFactory.statementFromText(text, block));
                    if (!nonReleasedIvars.isEmpty()) {
                        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file1);
                        if (document != null) {
                            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
                        }
                        new OCReleaseVariablesIntentionAction(nonReleasedIvars, project).invoke(project, editor, file1);
                    }
                }
                List<OCMethodSelectorPart> parameters = ((OCMethod)callable).getParameters();
                int index = -1;
                for (int i = 0; i < parameters.size(); ++i) {
                    if (!newParameter.getName().equals(parameters.get(i).getParameterName())) continue;
                    index = i;
                }
                if (index == -1) {
                    return;
                }
                String objectMethodName = OCGenerateInitWithHandler.getObjectMethodSignature(((OCMethod)method).getSelector(), false, context.getType(), OCResolveContext.forPsi(method));
                for (PsiElement child : methodParent.getChildren()) {
                    if (!(child instanceof OCMethod) || !((OCMethod)child).getSelector().equals(objectMethodName)) continue;
                    final int finalIndex = index;
                    child.accept((PsiElementVisitor)new OCRecursiveVisitor(){

                        @Override
                        public void visitSendMessageExpression(OCSendMessageExpression expression) {
                            List<OCExpression> params;
                            if (expression.getMessageSelector().equals(((OCMethod)callable).getSelector()) && (params = expression.getArgumentExpressions()).size() > finalIndex) {
                                OCChangeUtil.replaceHandlingMacros(params.get(finalIndex), OCElementFactory.expressionFromText(newParameter.getName(), expression));
                            }
                        }
                    });
                    OCChangeSignatureHandler objectHandler = OCChangeSignatureActionHandler.getHandler((OCCallable)child, child, true);
                    objectHandler.insertParameter(newParameter.getSelector(), newParameter.getName(), newParameter.getType(), finalIndex, -1, false);
                    objectHandler.invokeSynchronously();
                }
                return;
            }
        });
        handler.setTitle(this.getActionTitle());
        handler.invoke();
    }
}

