/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.jetbrains.cidr.lang.inspections.OCUnusedCppInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedVisitor;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OCUnusedStructInspection
extends OCUnusedCppInspection {
    private static final Set<String> specialStructNames = Set.of("tuple_size", "tuple_element");

    @Override
    @NotNull
    public OCUnusedVisitor buildVisitor() {
        return new OCUnusedVisitor(this){

            @Override
            public void visitStructLike(OCStructLike struct) {
                OCSymbol symbol = this.getSymbol(struct);
                if (symbol != null && !struct.isElaboratedTypeDeclaration() && !specialStructNames.contains(symbol.getName())) {
                    this.checkSymbolUsed(struct, symbol);
                }
            }
        };
    }

    public boolean runForWholeFile() {
        return true;
    }
}

