/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.inspections.OCUnusedObjCInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedVisitor;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import org.jetbrains.annotations.NotNull;

public class OCUnusedPropertyInspection
extends OCUnusedObjCInspection {
    @Override
    @NotNull
    public OCUnusedVisitor buildVisitor() {
        return new OCUnusedVisitor(this){

            @Override
            public void visitProperty(OCProperty property) {
                OCDeclaration declaration = property.getDeclaration();
                if (declaration == null) {
                    return;
                }
                for (OCDeclarator declarator : declaration.getDeclarators()) {
                    this.checkSymbolUsed(declarator, declarator.getSymbol());
                }
            }

            @Override
            public void checkFromBatchMode(@NotNull OCSymbol symbol, @NotNull PsiElement declarator) {
                if (symbol.getKind() == OCSymbolKind.PROPERTY) {
                    this.checkSymbolUsed(declarator, symbol);
                }
            }
        };
    }

    public boolean runForWholeFile() {
        return true;
    }
}

