/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.inspections.OCUnusedCppInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedTemplateParameterInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedVisitor;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.search.OCFunctionAncestorsQuery;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OCUnusedGlobalDeclarationInspection
extends OCUnusedCppInspection {
    private static final Set<String> specialFunctionNames = Set.of("begin", "end", "get_return_object_on_allocation_failure", "get_return_object", "initial_suspend", "final_suspend", "unhandled_exception", "return_void", "return_value", "yield_value", "await_transform");

    @Override
    @NotNull
    public OCUnusedVisitor buildVisitor() {
        return new OCUnusedVisitor(this){

            @Override
            public void visitDeclarator(OCDeclarator declarator) {
                final OCSymbol symbol = this.getSymbol(declarator);
                if (symbol != null && OCUnusedGlobalDeclarationInspection.processDeclaratorAsNonLocal(symbol)) {
                    if (!this.myOnTheFly && (symbol instanceof OCDeclaratorSymbol || symbol instanceof OCFunctionSymbol) && !symbol.processSameSymbols((Processor<OCSymbol>)new CommonProcessors.FindFirstProcessor<OCSymbol>(){

                        protected boolean accept(OCSymbol sameSymbol) {
                            return symbol instanceof OCFunctionSymbol && symbol.isDefinition() && sameSymbol.isPredeclaration() || symbol instanceof OCDeclaratorSymbol && symbol.isPredeclaration() && sameSymbol.isDefinition() || sameSymbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)sameSymbol).isExtern();
                        }
                    }, declarator.getProject())) {
                        return;
                    }
                    if (symbol instanceof OCFunctionSymbol && OCUnusedGlobalDeclarationInspection.isFunctionUsed((OCFunctionSymbol)symbol, declarator)) {
                        return;
                    }
                    if (declarator.getParent() instanceof OCParameterDeclaration && declarator.getParent().getParent() instanceof OCTemplateParameterList && OCUnusedTemplateParameterInspection.isTraitTemplateParameter((OCTemplateParameterList)declarator.getParent().getParent())) {
                        return;
                    }
                    if (symbol.getKind() == OCSymbolKind.STRUCT_FIELD) {
                        OCStructSymbol structSymbol;
                        OCResolveContext context = OCResolveContext.forPsi(declarator);
                        OCType declaratorType = symbol.getType().resolve(context);
                        if (declaratorType instanceof OCStructType && ((structSymbol = ((OCStructType)declaratorType).getSymbol()).isUnused() || !structSymbol.hasTrivialDestructor(context))) {
                            return;
                        }
                    }
                    this.checkSymbolUsed(declarator, symbol);
                }
            }
        };
    }

    private static boolean processDeclaratorAsNonLocal(@NotNull OCSymbol symbol) {
        return symbol.isGlobal() || symbol.getKind() == OCSymbolKind.TEMPLATE_VALUE_PARAMETER;
    }

    private static boolean isFunctionUsed(OCFunctionSymbol symbol, @NotNull PsiElement context) {
        if (specialFunctionNames.contains(symbol.getName())) {
            return true;
        }
        if (symbol.getName().equals("get") && !symbol.getTemplateParameters().isEmpty() && symbol.getTemplateParameters().get(0) instanceof OCTypeParameterValueSymbol) {
            return true;
        }
        if (symbol.isMainFunction()) {
            return true;
        }
        OCFile file = symbol.getContainingOCFile(context.getProject());
        if (file == null || file.isCpp()) {
            if (symbol.isCppOperator() || symbol.isSpecialConstructor(OCResolveContext.forPsi(context)) || symbol.isCppDestructor()) {
                return true;
            }
            if (OCFunctionAncestorsQuery.findFirstVirtual(symbol, false, context.getProject()) != null) {
                return true;
            }
        }
        return false;
    }

    public boolean runForWholeFile() {
        return true;
    }
}

