/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.application.options.CodeStyle;
import com.intellij.application.options.CodeStyleConfigurableWrapper;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.lang.CidrLangUtil;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderGuardDetector;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderGuardInfo;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.impl.OCDefineDirectiveImpl;
import com.jetbrains.cidr.lang.psi.impl.OCMacroReferenceElementImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.OCNamingConventionUtil;
import com.jetbrains.cidr.lang.refactoring.rename.OCInplaceRenameHandler;
import com.jetbrains.cidr.lang.refactoring.rename.OCInplaceRenamer;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettingsProvider;
import com.jetbrains.cidr.lang.settings.OCNamingConventionConfigurable;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.util.OCHeaderGuardUtil;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInconsistentNamingInspection
extends OCInspections.GeneralCpp {
    public static final Key<Boolean> INCONSISTENT_NAMING_UNIT_TEST_MODE = Key.create((String)"INCONSISTENT_NAMING_UNIT_TEST_MODE");

    @Nls
    @NotNull
    public String getDisplayName() {
        return OCInspectionsBundle.message("inspection.inconsistent.naming", new Object[0]);
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        return HighlightDisplayLevel.WEAK_WARNING;
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    public boolean worksWithClangd() {
        return true;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBag bag = new GridBag().setDefaultWeightX(1.0).setDefaultWeightY(1.0).setDefaultInsets((Insets)JBUI.insets((int)5)).setDefaultAnchor(18);
        panel2.add((Component)CidrLangUtil.createLinkToConfigurable((String)OCInspectionsBundle.message("inspection.naming.convention.edit.settings.link", new Object[0]), CodeStyleConfigurableWrapper.class, c -> ((CodeStyleConfigurableWrapper)c).getOriginalClass() == OCCodeStyleSettingsProvider.class, c -> ((CodeStyleConfigurableWrapper)c).selectTab(OCNamingConventionConfigurable.getTitle())), bag.nextLine());
        return panel2;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiFile file = holder.getFile();
        if (ApplicationManager.getApplication().isUnitTestMode() && file.getUserData(INCONSISTENT_NAMING_UNIT_TEST_MODE) != Boolean.TRUE && holder.getProject().getUserData(INCONSISTENT_NAMING_UNIT_TEST_MODE) != Boolean.TRUE) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return file instanceof OCFile && ((OCFile)file).isInProjectSources() ? new Visitor((OCFile)file, holder) : PsiElementVisitor.EMPTY_VISITOR;
    }

    @InspectionMessage
    private static String getInspectionMessage(@NotNull String suggestedName) {
        return OCInspectionsBundle.message("inspection.naming.convention.rename.fix", StringUtil.wrapWithDoubleQuote((String)suggestedName));
    }

    @InspectionMessage
    private static String getRenameHeaderGuardMessage(@NotNull String suggestedHeaderGuardName) {
        return OCInspectionsBundle.message("inspection.naming.convention.rename.header.guard.fix", StringUtil.wrapWithDoubleQuote((String)suggestedHeaderGuardName));
    }

    static class RenameElementFix
    extends OCPsiElementQuickFix<PsiElement> {
        @NotNull
        private final String myNewName;
        @NotNull
        @IntentionFamilyName
        private final String myMessage;

        RenameElementFix(@NotNull PsiElement elementToRename, @NotNull String newName, @NotNull @IntentionFamilyName String message) {
            super(elementToRename);
            this.myNewName = newName;
            this.myMessage = message;
        }

        @NotNull
        public String getFamilyName() {
            return this.myMessage;
        }

        @Override
        protected String getTextInternal() {
            return this.myMessage;
        }

        @Override
        protected void invoke(PsiFile file, @NotNull PsiElement element) {
            Editor editor = FileEditorManager.getInstance((Project)file.getProject()).getSelectedTextEditor();
            if (editor == null) {
                return;
            }
            OCInplaceRenamer renamer = (OCInplaceRenamer)new OCInplaceRenameHandler().createRenamer(element, editor);
            if (renamer != null) {
                renamer.performRenameInner(element, this.myNewName);
            }
        }

        @Override
        public boolean startInWriteAction() {
            return false;
        }
    }

    private class Visitor
    extends OCVisitor {
        private final ProblemsHolder myHolder;
        private final OCHeaderGuardInfo myHeaderGuardInfo;

        Visitor(@NotNull OCFile file, ProblemsHolder holder) {
            this.myHeaderGuardInfo = ApplicationManager.getApplication().isUnitTestMode() || file.isHeader() ? OCHeaderGuardDetector.findCachedHeaderGuard(file, true) : null;
            this.myHolder = holder;
        }

        @Override
        public void visitDeclarator(OCDeclarator declarator) {
            this.validateNamingConvention(declarator.getName(), declarator, declarator.getNameIdentifier());
        }

        @Override
        public void visitNamespace(OCCppNamespace namespace) {
            this.validateNamingConvention(namespace.getName(), namespace, namespace.getNameIdentifier());
        }

        @Override
        public void visitStructLike(OCStructLike struct) {
            this.validateNamingConvention(struct.getName(), struct, struct.getNameIdentifier());
        }

        @Override
        public void visitDefineDirective(OCDefineDirectiveImpl directive) {
            if (this.myHeaderGuardInfo != null && this.myHeaderGuardInfo.getDefineDirective() == directive) {
                this.validateHeaderGuardStylePattern(directive);
            } else {
                this.validateNamingConvention(directive.getName(), directive, directive.getNameIdentifier());
            }
        }

        @Override
        public void visitUsingStatement(OCCppUsingStatement usingStatement) {
            if (!usingStatement.isNamespaceUsing()) {
                this.validateNamingConvention(usingStatement.getName(), usingStatement, usingStatement.getNameIdentifier());
            }
        }

        private void validateNamingConvention(@Nullable String name, @NotNull OCSymbolDeclarator<?> symbolDeclarator, @Nullable PsiElement nameIdentifier) {
            String suggestedName;
            Object symbol = symbolDeclarator.getSymbol();
            if (symbol == null || OCNamingConventionUtil.shouldIgnoreNamingConventionForSymbol(symbol) || StringUtil.isEmpty((String)name) || nameIdentifier == null) {
                return;
            }
            OCResolveContext resolveContext = OCResolveContext.forPsi(symbolDeclarator);
            if (symbol instanceof OCFunctionSymbol && this.isOverrideMemberFunction((OCFunctionSymbol)symbol, resolveContext)) {
                return;
            }
            Project project = symbolDeclarator.getProject();
            OCSymbolKind symbolKind = symbol.getKind();
            if (!OCNamingConventionUtil.matchesToNamingConvention(name, symbolKind, symbol, resolveContext, project) && !(suggestedName = OCNamingConventionUtil.applyNamingConvention(name, symbolKind, symbol, resolveContext, project)).isEmpty()) {
                String message = OCInconsistentNamingInspection.getInspectionMessage(suggestedName);
                OCInconsistentNamingInspection.this.registerProblem(this.myHolder, null, null, this.myHolder.isOnTheFly(), nameIdentifier, message, "CIDR", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new RenameElementFix(symbolDeclarator, suggestedName, message));
            }
        }

        private void validateHeaderGuardStylePattern(@NotNull OCDefineDirective defineDirective) {
            PsiFile file = defineDirective.getContainingFile();
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            String filePath = virtualFile.getPath();
            Project project = this.myHolder.getProject();
            String headerGuardStylePattern = ((OCCodeStyleSettings)CodeStyle.getSettings((Project)project).getCustomSettings(OCCodeStyleSettings.class)).HEADER_GUARD_STYLE_PATTERN;
            if (!OCHeaderGuardUtil.headerGuardMatchesPattern((String)this.myHeaderGuardInfo.getHeaderGuardName(), (String)headerGuardStylePattern, (String)filePath, (Project)project)) {
                String suggestedHeaderGuardName = OCHeaderGuardUtil.buildHeaderGuardName((String)headerGuardStylePattern, (String)filePath, (Project)project);
                PsiElement macroReference = PsiTreeUtil.findChildOfType((PsiElement)this.myHeaderGuardInfo.getBeginIfndefDirective(), OCMacroReferenceElementImpl.class);
                if (StringUtil.isNotEmpty((String)suggestedHeaderGuardName) && macroReference != null) {
                    String message = OCInconsistentNamingInspection.getRenameHeaderGuardMessage(suggestedHeaderGuardName);
                    OCInconsistentNamingInspection.this.registerProblem(this.myHolder, null, null, this.myHolder.isOnTheFly(), macroReference, message, "CIDR", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new RenameElementFix(defineDirective, suggestedHeaderGuardName, message));
                }
            }
        }

        private boolean isOverrideMemberFunction(@NotNull OCFunctionSymbol functionSymbol, @NotNull OCResolveContext context) {
            if (functionSymbol.isOverride()) {
                return true;
            }
            OCSymbolWithQualifiedName functionSymbolOwner = functionSymbol.getResolvedOwner(context);
            if (!(functionSymbolOwner instanceof OCStructSymbol)) {
                return false;
            }
            Ref isOverrideMemberFunction = Ref.create((Object)false);
            OCType functionType = functionSymbol.getResolvedType(context);
            OCStructType.processMembersInBaseTypes((OCStructSymbol)functionSymbolOwner, functionSymbol.getName(), false, false, (Condition<? super OCSymbol>)((Condition)parentMember -> {
                if (parentMember instanceof OCFunctionSymbol) {
                    OCFunctionSymbol parentMemberFunction = (OCFunctionSymbol)parentMember;
                    OCTypeEqualityVisitor equalityVisitor = new OCTypeEqualityVisitor(parentMemberFunction.getResolvedType(context), true, context);
                    if (parentMemberFunction.isVirtual() && equalityVisitor.isFunctionSignatureEqual(functionType)) {
                        return true;
                    }
                }
                return false;
            }), (Processor<? super OCSymbol>)((Processor)parentMember -> {
                isOverrideMemberFunction.set((Object)true);
                return true;
            }), context);
            return (Boolean)isOverrideMemberFunction.get();
        }
    }
}

