/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.structureVIew;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.TreeAnchorizer;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNamedElement;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.EmptyIcon;
import com.jetbrains.cidr.lang.hierarchy.structureVIew.OCElementNameUtil;
import com.jetbrains.cidr.lang.hierarchy.structureVIew.OCMark;
import com.jetbrains.cidr.lang.hierarchy.structureVIew.OCMarkedStructureViewElement;
import com.jetbrains.cidr.lang.hierarchy.structureVIew.OCStructureViewModel;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCStructureViewElement
implements StructureViewTreeElement,
OCMarkedStructureViewElement {
    public static final TextAttributesKey OC_PRAGMA_MARK = TextAttributesKey.createTextAttributesKey((String)"OC_PRAGMA_MARK", (TextAttributes)new TextAttributes(JBColor.foreground(), null, null, null, 1));
    @Nullable
    private final Object myElementAnchor;
    @Nullable
    private final Object myContextAnchor;
    @Nullable
    private final Object myParentMarkAnchor;
    @Nullable
    private String myPresentableQN = null;
    @Nullable
    private OCStructureViewModel myViewModel;

    public OCStructureViewElement(@NotNull PsiElement element, @Nullable PsiElement context) {
        this(null, element, context, null);
    }

    protected OCStructureViewElement(@Nullable OCStructureViewModel viewModel, @Nullable PsiElement element, @Nullable PsiElement context, @Nullable PsiElement parentMark) {
        this.myViewModel = viewModel;
        TreeAnchorizer service = TreeAnchorizer.getService();
        this.myElementAnchor = element != null ? service.createAnchor((Object)element) : null;
        this.myContextAnchor = context != null ? service.createAnchor((Object)context) : null;
        this.myParentMarkAnchor = parentMark != null ? service.createAnchor((Object)parentMark) : null;
    }

    public void setViewModel(@Nullable OCStructureViewModel viewModel) {
        this.myViewModel = viewModel;
    }

    @Nullable
    public OCStructureViewModel getViewModel() {
        return this.myViewModel;
    }

    @Nullable
    public String getFullQN() {
        Pair<String, Boolean> pair = OCElementNameUtil.getPresentableNameAndQNOwnership(this.getValue(), true);
        return (Boolean)pair.second != false ? OCElementNameUtil.stripLastID((String)pair.first) : null;
    }

    @Nullable
    public PsiElement getValue() {
        return this.myElementAnchor != null ? (PsiElement)TreeAnchorizer.getService().retrieveElement(this.myElementAnchor) : null;
    }

    @Nullable
    private PsiElement getContext() {
        return this.myContextAnchor != null ? (PsiElement)TreeAnchorizer.getService().retrieveElement(this.myContextAnchor) : null;
    }

    @Override
    @Nullable
    public PsiElement getParentMarkElement() {
        return this.myParentMarkAnchor != null ? (PsiElement)TreeAnchorizer.getService().retrieveElement(this.myParentMarkAnchor) : null;
    }

    public boolean isAllowInheritorsAndCategories() {
        return this.myContextAnchor == null;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return new OCItemPresentation(this.getValue(), this.getPresentableQN());
    }

    public boolean showQualifiedNames() {
        if (this.myViewModel == null) {
            return false;
        }
        return this.myViewModel.showQualifiedNames();
    }

    public TreeElement @NotNull [] getChildren() {
        PsiElement element = this.getValue();
        if (element == null || element instanceof OCDeclarator || element instanceof OCFunctionDefinition || element instanceof OCMethod) {
            return StructureViewTreeElement.EMPTY_ARRAY;
        }
        PsiElement context = this.getContext();
        if (this.myContextAnchor != null && context == null) {
            return EMPTY_ARRAY;
        }
        final ArrayList children = new ArrayList();
        element.acceptChildren((PsiElementVisitor)new OCVisitor(){

            @Override
            public void visitOCElement(OCElement elem) {
                if (OCStructureViewElement.this.worthyElement(elem)) {
                    children.add(elem);
                } else if (!this.notWorthyElement(elem)) {
                    elem.acceptChildren(this);
                }
            }

            public void visitComment(@NotNull PsiComment comment) {
                children.add(comment);
            }

            @Override
            public void visitPragma(OCPragma pragma) {
                children.add(pragma);
            }

            private boolean notWorthyElement(OCElement elem) {
                return elem instanceof OCTemplateParameterList;
            }
        });
        ArrayList<OCStructureViewElement> result = new ArrayList<OCStructureViewElement>();
        PsiElement previousMark = null;
        for (PsiElement o : children) {
            Object symbol;
            if (!(o instanceof OCCppNamespace) && o instanceof PsiNamedElement && ((PsiNamedElement)o).getName() == null || o instanceof OCSymbolDeclarator && context != null && (symbol = ((OCSymbolDeclarator)o).getSymbol()) != null && !OCVisibility.isVisible(symbol, context, null, o.getProject())) continue;
            if (o instanceof OCPragma || o instanceof PsiComment) {
                OCMark mark;
                if (!this.addPragmasAndComments() || (mark = OCMark.createFromElement(o)) == null) continue;
                previousMark = o;
                if (mark.getText() == null) continue;
                result.add(this.createChildElement(o, context, o));
                continue;
            }
            result.add(this.createChildElement(o, context, previousMark));
        }
        return result.toArray(TreeElement.EMPTY_ARRAY);
    }

    @NotNull
    protected OCStructureViewElement createChildElement(@NotNull PsiElement element, @Nullable PsiElement context, @Nullable PsiElement previousMark) {
        return new OCStructureViewElement(this.myViewModel, element, context, previousMark);
    }

    protected boolean addPragmasAndComments() {
        return true;
    }

    protected boolean worthyElement(OCElement element) {
        return element instanceof OCDefineDirective || element instanceof OCDeclarator || element instanceof OCFunctionDefinition || element instanceof OCCppNamespace || element instanceof OCStructLike || element instanceof OCMethod || element instanceof OCInterface || element instanceof OCImplementation || element instanceof OCProtocol || element instanceof OCCppUsingStatement && !((OCCppUsingStatement)element).isNamespaceUsing();
    }

    public void navigate(boolean requestFocus2) {
        PsiElement element = this.getValue();
        if (element instanceof Navigatable) {
            ((Navigatable)element).navigate(requestFocus2);
        }
    }

    public boolean canNavigate() {
        PsiElement element = this.getValue();
        return element instanceof Navigatable && ((Navigatable)element).canNavigate();
    }

    public boolean canNavigateToSource() {
        PsiElement element = this.getValue();
        return element instanceof Navigatable && ((Navigatable)element).canNavigateToSource();
    }

    public void setPresentableQN(@NotNull String presentableQNAfterGrouping) {
        this.myPresentableQN = presentableQNAfterGrouping;
    }

    @Nullable
    public String getPresentableQN() {
        return this.myPresentableQN;
    }

    protected static class OCItemPresentation
    implements ColoredItemPresentation {
        protected final PsiElement myElement;
        private final String myPresentableQN;

        protected OCItemPresentation(@Nullable PsiElement element, @Nullable String presentableQN) {
            this.myElement = element;
            this.myPresentableQN = presentableQN;
        }

        public String getPresentableText() {
            boolean withFullQN = this.myPresentableQN == null;
            Pair<String, Boolean> p = OCElementNameUtil.getPresentableNameAndQNOwnership(this.myElement, withFullQN);
            return withFullQN ? (String)p.first : (this.myPresentableQN.isEmpty() ? (String)p.first : this.myPresentableQN + "::" + (String)p.first);
        }

        public Icon getIcon(boolean open) {
            return OCElementNameUtil.isMark(this.myElement) ? EmptyIcon.ICON_16 : (this.myElement != null && this.myElement.isValid() ? this.myElement.getIcon(0) : null);
        }

        public TextAttributesKey getTextAttributesKey() {
            return OCElementNameUtil.isMark(this.myElement) ? OC_PRAGMA_MARK : null;
        }
    }
}

