/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.structureVIew;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.hierarchy.structureVIew.OCMark$Companion$WhenMappings;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCPragma;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000f\u001a\u00020\u0005H\u0016R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\nR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/lang/hierarchy/structureVIew/OCMark;", "", "isSeparatorBefore", "", "text", "", "isSeparatorAfter", "kind", "Lcom/jetbrains/cidr/lang/hierarchy/structureVIew/OCMark$Kind;", "(ZLjava/lang/String;ZLcom/jetbrains/cidr/lang/hierarchy/structureVIew/OCMark$Kind;)V", "()Z", "getKind", "()Lcom/jetbrains/cidr/lang/hierarchy/structureVIew/OCMark$Kind;", "getText", "()Ljava/lang/String;", "toString", "Companion", "Kind", "intellij.c"})
public final class OCMark {
    private final boolean isSeparatorBefore;
    @Nullable
    private final String text;
    private final boolean isSeparatorAfter;
    @NotNull
    private final Kind kind;
    @NotNull
    private static final OCMark SEPARATOR;
    @NotNull
    private static final OCMark TODO_SEPARATOR;
    @NotNull
    private static final OCMark FIXME_SEPARATOR;
    @NotNull
    private static final Kind DEFAULT_MARK_KIND;
    private static final Pattern COMMENT_PATTERN;
    private static final Pattern MARK_PATTERN;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public String toString() {
        Object object;
        if (this.isSeparatorBefore) {
            object = "-";
        } else {
            String string = this.text;
            if (string == null) {
                string = "";
            }
            object = string + (this.isSeparatorAfter ? "-" : "");
        }
        return object;
    }

    public final boolean isSeparatorBefore() {
        return this.isSeparatorBefore;
    }

    @Nullable
    public final String getText() {
        return this.text;
    }

    public final boolean isSeparatorAfter() {
        return this.isSeparatorAfter;
    }

    @NotNull
    public final Kind getKind() {
        return this.kind;
    }

    public OCMark(boolean isSeparatorBefore, @NlsSafe @Nullable String text, boolean isSeparatorAfter, @NotNull Kind kind) {
        this.isSeparatorBefore = isSeparatorBefore;
        this.text = text;
        this.isSeparatorAfter = isSeparatorAfter;
        this.kind = kind;
    }

    static {
        Companion = new Companion(null);
        SEPARATOR = new OCMark(true, null, false, Kind.MARK);
        TODO_SEPARATOR = new OCMark(true, "TODO", false, Kind.TODO);
        FIXME_SEPARATOR = new OCMark(true, "FIXME", false, Kind.FIXME);
        DEFAULT_MARK_KIND = Kind.MARK;
        COMMENT_PATTERN = Pattern.compile(".*(MARK|TODO|FIXME):([^*]+?)\\s*(\\*|$)", 8);
        MARK_PATTERN = Pattern.compile("^\\s*(MARK|TODO|FIXME):(.*?)\\s*$", 8);
    }

    @NotNull
    public static final OCMark getSEPARATOR() {
        Companion companion = Companion;
        return SEPARATOR;
    }

    @NotNull
    public static final OCMark getTODO_SEPARATOR() {
        Companion companion = Companion;
        return TODO_SEPARATOR;
    }

    @NotNull
    public static final OCMark getFIXME_SEPARATOR() {
        Companion companion = Companion;
        return FIXME_SEPARATOR;
    }

    @NotNull
    public static final Kind getDEFAULT_MARK_KIND() {
        Companion companion = Companion;
        return DEFAULT_MARK_KIND;
    }

    @JvmStatic
    public static final boolean isMarkElement(@Nullable Object element) {
        return Companion.isMarkElement(element);
    }

    @JvmStatic
    @Nullable
    public static final OCMark createFromElement(@NotNull PsiElement element) {
        return Companion.createFromElement(element);
    }

    @JvmStatic
    @NotNull
    public static final OCMark createFromPragmaMarkText(@NotNull String pragmaText) {
        return Companion.createFromPragmaMarkText(pragmaText);
    }

    @JvmStatic
    @Nullable
    public static final OCMark createFromCommentText(@NotNull String commentText) {
        return Companion.createFromCommentText(commentText);
    }

    @JvmStatic
    public static final boolean isMarkCommentText(@NotNull String commentText) {
        return Companion.isMarkCommentText(commentText);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/lang/hierarchy/structureVIew/OCMark$Kind;", "", "(Ljava/lang/String;I)V", "MARK", "TODO", "FIXME", "intellij.c"})
    public static final class Kind
    extends Enum<Kind> {
        public static final /* enum */ Kind MARK;
        public static final /* enum */ Kind TODO;
        public static final /* enum */ Kind FIXME;
        private static final /* synthetic */ Kind[] $VALUES;

        static {
            Kind[] kindArray = new Kind[3];
            Kind[] kindArray2 = kindArray;
            kindArray[0] = MARK = new Kind();
            kindArray[1] = TODO = new Kind();
            kindArray[2] = FIXME = new Kind();
            $VALUES = kindArray;
        }

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String string) {
            return Enum.valueOf(Kind.class, string);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u0018H\u0007J\u0018\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0018H\u0002J\u001a\u0010!\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u0004H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0012\u0010%\u001a\u00020$2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0007J\u0010\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0011\u0010\u0002\u001a\u0004\b\u0012\u0010\u000eR\u001c\u0010\u0013\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u0002\u001a\u0004\b\u0015\u0010\u000e\u00a8\u0006("}, d2={"Lcom/jetbrains/cidr/lang/hierarchy/structureVIew/OCMark$Companion;", "", "()V", "COMMENT_PATTERN", "Ljava/util/regex/Pattern;", "DEFAULT_MARK_KIND", "Lcom/jetbrains/cidr/lang/hierarchy/structureVIew/OCMark$Kind;", "getDEFAULT_MARK_KIND$annotations", "getDEFAULT_MARK_KIND", "()Lcom/jetbrains/cidr/lang/hierarchy/structureVIew/OCMark$Kind;", "FIXME_SEPARATOR", "Lcom/jetbrains/cidr/lang/hierarchy/structureVIew/OCMark;", "getFIXME_SEPARATOR$annotations", "getFIXME_SEPARATOR", "()Lcom/jetbrains/cidr/lang/hierarchy/structureVIew/OCMark;", "MARK_PATTERN", "SEPARATOR", "getSEPARATOR$annotations", "getSEPARATOR", "TODO_SEPARATOR", "getTODO_SEPARATOR$annotations", "getTODO_SEPARATOR", "createFromCommentText", "commentText", "", "createFromElement", "element", "Lcom/intellij/psi/PsiElement;", "createFromPragmaMarkText", "pragmaText", "createFromText", "kind", "text", "extractTextUsingPattern", "pattern", "isMarkCommentText", "", "isMarkElement", "separator", "markKind", "intellij.c"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getSEPARATOR$annotations() {
        }

        @NotNull
        public final OCMark getSEPARATOR() {
            return SEPARATOR;
        }

        @JvmStatic
        public static /* synthetic */ void getTODO_SEPARATOR$annotations() {
        }

        @NotNull
        public final OCMark getTODO_SEPARATOR() {
            return TODO_SEPARATOR;
        }

        @JvmStatic
        public static /* synthetic */ void getFIXME_SEPARATOR$annotations() {
        }

        @NotNull
        public final OCMark getFIXME_SEPARATOR() {
            return FIXME_SEPARATOR;
        }

        @JvmStatic
        public static /* synthetic */ void getDEFAULT_MARK_KIND$annotations() {
        }

        @NotNull
        public final Kind getDEFAULT_MARK_KIND() {
            return DEFAULT_MARK_KIND;
        }

        @JvmStatic
        public final boolean isMarkElement(@Nullable Object element) {
            return element instanceof PsiElement && this.createFromElement((PsiElement)element) != null;
        }

        @JvmStatic
        @Nullable
        public final OCMark createFromElement(@NotNull PsiElement element) {
            ASTNode mark;
            if (element instanceof PsiComment) {
                return this.createFromCommentText(((PsiComment)element).getText());
            }
            if (element instanceof OCPragma && (mark = ((OCPragma)element).getNode().findChildByType((IElementType)OCTokenTypes.PRAGMA_MARK_LITERAL)) != null) {
                String string = (String)((OCPragma)element).getContent((PsiElement)mark.getPsi(), (boolean)true).first;
                if (string == null) {
                    string = "";
                }
                return this.createFromPragmaMarkText(string);
            }
            return null;
        }

        @JvmStatic
        @NotNull
        public final OCMark createFromPragmaMarkText(@NotNull String pragmaText) {
            OCMark oCMark = this.extractTextUsingPattern(pragmaText, MARK_PATTERN);
            if (oCMark == null) {
                oCMark = this.createFromText(Kind.MARK, pragmaText);
            }
            return oCMark;
        }

        @JvmStatic
        @Nullable
        public final OCMark createFromCommentText(@NotNull String commentText) {
            return this.extractTextUsingPattern(commentText, COMMENT_PATTERN);
        }

        @JvmStatic
        public final boolean isMarkCommentText(@NotNull String commentText) {
            return COMMENT_PATTERN.matcher(commentText).find();
        }

        private final OCMark extractTextUsingPattern(String commentText, Pattern pattern) {
            Matcher matcher = pattern.matcher(commentText);
            if (matcher.find()) {
                Kind markKind = Kind.valueOf(matcher.group(1));
                String origText = matcher.group(2);
                return this.createFromText(markKind, origText);
            }
            return null;
        }

        private final OCMark createFromText(Kind kind, String text) {
            if (StringsKt.isBlank((CharSequence)text)) {
                return this.separator(kind);
            }
            String string = text;
            String trimmed = ((Object)StringsKt.trim((CharSequence)string)).toString();
            if (Intrinsics.areEqual((Object)"-", (Object)trimmed)) {
                return this.separator(kind);
            }
            String string2 = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)trimmed, (CharSequence)"- "), (CharSequence)" -");
            Object label = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            if (kind != this.getDEFAULT_MARK_KIND()) {
                label = kind.toString() + ": " + (String)label;
            }
            return new OCMark(StringsKt.startsWith$default((String)trimmed, (String)"- ", (boolean)false, (int)2, null), (String)label, StringsKt.endsWith$default((String)trimmed, (String)" -", (boolean)false, (int)2, null), kind);
        }

        private final OCMark separator(Kind markKind) {
            OCMark oCMark;
            switch (OCMark$Companion$WhenMappings.$EnumSwitchMapping$0[markKind.ordinal()]) {
                case 1: {
                    oCMark = this.getTODO_SEPARATOR();
                    break;
                }
                case 2: {
                    oCMark = this.getFIXME_SEPARATOR();
                    break;
                }
                default: {
                    oCMark = this.getSEPARATOR();
                }
            }
            return oCMark;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

