/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.structureVIew;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewBundle;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.hierarchy.structureVIew.OCStructureViewElement;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public final class OCKindSorter
implements Sorter {
    public static final Sorter INSTANCE = new OCKindSorter();

    private OCKindSorter() {
    }

    public Comparator getComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                return Integer.compare(this.getWeight(o1), this.getWeight(o2));
            }

            private int getWeight(Object tro) {
                if (!(tro instanceof OCStructureViewElement)) {
                    return Weights.QNGroup.ordinal();
                }
                PsiElement o = ((OCStructureViewElement)tro).getValue();
                if (o instanceof OCCppNamespace) {
                    return Weights.CppNamespace.ordinal();
                }
                if (o instanceof OCStructLike) {
                    return Weights.StructLike.ordinal();
                }
                if (o instanceof OCClassDeclaration) {
                    return Weights.ClassDeclaration.ordinal();
                }
                if (o instanceof OCFunctionDefinition) {
                    OCFunctionSymbol symbol = ((OCFunctionDefinition)o).getSymbol();
                    if (symbol != null) {
                        if (symbol.isCppConstructor()) {
                            return Weights.Constructor.ordinal();
                        }
                        if (symbol.isCppDestructor()) {
                            return Weights.Destructor.ordinal();
                        }
                    }
                    if (o.getParent() instanceof OCClassDeclaration) {
                        return Weights.ChildInClassDeclaration.ordinal();
                    }
                    return Weights.FunctionDefinition.ordinal();
                }
                if (o instanceof OCMethod) {
                    OCMethodSymbol symbol = (OCMethodSymbol)((OCMethod)o).getSymbol();
                    if (symbol != null && symbol.isConstructorMethod()) {
                        return Weights.Constructor.ordinal();
                    }
                    return Weights.FunctionDefinition.ordinal();
                }
                if (o instanceof OCDeclarator) {
                    OCSymbol symbol = ((OCDeclarator)o).getSymbol();
                    if (symbol != null) {
                        switch (symbol.getKind()) {
                            case CPP_CONSTRUCTOR_DECLARATION: 
                            case CPP_CONSTRUCTOR_PREDECLARATION: {
                                return Weights.Constructor.ordinal();
                            }
                            case FUNCTION_DECLARATION: 
                            case FUNCTION_PREDECLARATION: {
                                return Weights.FunctionDefinition.ordinal();
                            }
                            case PROPERTY: {
                                return Weights.Property.ordinal();
                            }
                            case INSTANCE_VARIABLE: 
                            case STRUCT_FIELD: {
                                return Weights.LocalVariable.ordinal();
                            }
                            case TYPEDEF: {
                                return Weights.Typedef.ordinal();
                            }
                            case GLOBAL_VARIABLE: 
                            case GLOBAL_VARIABLE_PREDECLARATION: {
                                return Weights.GlobalVariable.ordinal();
                            }
                        }
                    }
                    return Weights.Declarator.ordinal();
                }
                if (o instanceof OCDirective) {
                    return Weights.Directive.ordinal();
                }
                return Integer.MAX_VALUE;
            }
        };
    }

    public boolean isVisible() {
        return true;
    }

    @NotNull
    public ActionPresentation getPresentation() {
        return new ActionPresentationData(StructureViewBundle.message((String)"action.sort.by.type", (Object[])new Object[0]), "", AllIcons.ObjectBrowser.SortByType);
    }

    @NotNull
    public String getName() {
        return "KIND";
    }

    static enum Weights {
        CppNamespace,
        StructLike,
        ClassDeclaration,
        QNGroup,
        Constructor,
        Destructor,
        FunctionDefinition,
        Property,
        LocalVariable,
        Typedef,
        ChildInClassDeclaration,
        GlobalVariable,
        Declarator,
        Directive;

    }
}

