/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.structureVIew;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.jetbrains.cidr.lang.hierarchy.structureVIew.OCMark;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCAliasUsingSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCElementNameUtil {
    @NlsSafe
    private static final String UNKNOWN = "<unknown>";
    public static final String QSEP = "::";

    @Nullable
    public static OCSymbol getSymbolIfAny(@Nullable PsiElement element) {
        return element != null && FileSymbolTablesCache.getInstance(element.getProject()).areSymbolsLoaded() && element instanceof OCSymbolDeclarator && element.isValid() ? (OCSymbol)((OCSymbolDeclarator)element).getSymbol() : null;
    }

    @NotNull
    public static Pair<String, Boolean> getPresentableNameAndQNOwnership(@Nullable PsiElement element, boolean showQualifiedNames) {
        OCSymbol symbol = OCElementNameUtil.getSymbolIfAny(element);
        if (symbol instanceof OCMacroSymbol) {
            return OCElementNameUtil.ignoreQNOwnership(((OCMacroSymbol)symbol).getPresentableSignature());
        }
        if (symbol instanceof OCFunctionSymbol) {
            return OCElementNameUtil.checkQNOwnership(OCElementNameUtil.getFunctionName((OCFunctionSymbol)symbol, element, showQualifiedNames));
        }
        if (symbol instanceof OCDeclaratorSymbol) {
            return OCElementNameUtil.checkQNOwnership(OCElementNameUtil.getPresentableText((OCDeclaratorSymbol)symbol, element, showQualifiedNames));
        }
        if (symbol instanceof OCStructSymbol) {
            return OCElementNameUtil.ignoreQNOwnership(OCElementNameUtil.getStructName((OCStructSymbol)symbol, element, showQualifiedNames));
        }
        if (element instanceof PsiFile) {
            return OCElementNameUtil.ignoreQNOwnership(((PsiFile)element).getName());
        }
        if (element instanceof OCMethod) {
            return OCElementNameUtil.ignoreQNOwnership(((OCMethod)element).getSelector());
        }
        if (symbol instanceof OCAliasUsingSymbol) {
            return OCElementNameUtil.ignoreQNOwnership(OCElementNameUtil.getPresentableText((OCAliasUsingSymbol)symbol, element));
        }
        if (element instanceof OCClassDeclaration) {
            OCClassDeclaration cls = (OCClassDeclaration)element;
            String name = cls.getName();
            if (name == null) {
                return OCElementNameUtil.ignoreQNOwnership("<unnamed>");
            }
            return OCElementNameUtil.ignoreQNOwnership(OCCodeInsightUtil.getClassNameWithCategory(name, cls.getCategory()));
        }
        if (OCElementNameUtil.isMark(element)) {
            OCMark mark = OCMark.createFromElement(element);
            return OCElementNameUtil.ignoreQNOwnership(mark != null && mark.getText() != null ? mark.getText() : "<unnamed>");
        }
        if (element instanceof PsiNameIdentifierOwner) {
            String name = ((PsiNameIdentifierOwner)element).getName();
            if (name == null && element instanceof OCEnum) {
                @NlsSafe StringBuilder builder2 = new StringBuilder("enum {");
                boolean first = true;
                for (OCDeclaration field : ((OCEnum)element).getFields()) {
                    if (first) {
                        first = false;
                    } else {
                        builder2.append(", ");
                    }
                    if (builder2.length() > 30) {
                        builder2.append("...");
                        break;
                    }
                    builder2.append(field.getDeclarators().get(0).getName());
                }
                builder2.append("}");
                return OCElementNameUtil.ignoreQNOwnership(builder2.toString());
            }
            return OCElementNameUtil.ignoreQNOwnership(name == null ? "<unnamed>" : name);
        }
        return OCElementNameUtil.ignoreQNOwnership(UNKNOWN);
    }

    private static Pair<String, Boolean> checkQNOwnership(@NotNull String name) {
        return Pair.create((Object)name, (Object)(name.lastIndexOf(QSEP) >= 0 ? 1 : 0));
    }

    private static Pair<String, Boolean> ignoreQNOwnership(@NotNull String name) {
        return Pair.create((Object)name, (Object)false);
    }

    @NotNull
    static String getFunctionName(@NotNull OCFunctionSymbol symbol, @NotNull PsiElement element, boolean showQualifiedNames) {
        OCNamespaceSymbol nsSymbol;
        PsiElement gparent;
        PsiElement parent = element;
        if (parent instanceof OCDeclarator) {
            parent = parent.getParent();
        }
        if ((gparent = parent.getParent()) instanceof OCStructLike) {
            return symbol.getSignatureWithoutParamNames();
        }
        String fullQName = symbol.getSignatureWithoutParamNames(true, true, OCResolveContext.forPsi(element));
        if (gparent instanceof OCCppNamespace && (nsSymbol = (OCNamespaceSymbol)((OCCppNamespace)gparent).getSymbol()) != null) {
            String nsPrefix = nsSymbol.getName() + QSEP;
            fullQName = StringUtil.trimStart((String)fullQName, (String)nsPrefix);
        }
        return OCElementNameUtil.convertNameByOptions(showQualifiedNames, fullQName);
    }

    @NotNull
    static String getStructName(@NotNull OCStructSymbol symbol, @NotNull PsiElement element, boolean showQualifiedNames) {
        StringBuilder result = new StringBuilder(OCElementNameUtil.convertNameByOptions(showQualifiedNames, symbol.getQualifiedName().toString()));
        List<OCTypeArgument> specialization = symbol.getTemplateSpecialization();
        if (specialization != null && !specialization.isEmpty()) {
            boolean first = true;
            result.append('<');
            for (OCTypeArgument argument : specialization) {
                if (first) {
                    first = false;
                } else {
                    result.append(", ");
                }
                result.append(argument.getShortName(0));
            }
            result.append('>');
        } else {
            List<OCTypeParameterSymbol> parameters = symbol.getTemplateParameters();
            if (!parameters.isEmpty()) {
                boolean first = true;
                result.append('<');
                for (OCTypeParameterSymbol parameter : parameters) {
                    if (first) {
                        first = false;
                    } else {
                        result.append(", ");
                    }
                    result.append(parameter.getName());
                }
                result.append('>');
            }
        }
        return result.toString();
    }

    @NotNull
    private static String getPresentableText(@NotNull OCAliasUsingSymbol symbol, @Nullable PsiElement element) {
        StringBuilder buffer = new StringBuilder();
        String symbolName = element != null ? symbol.getQualifiedName().getFullName(OCResolveContext.forPsi(element)) : symbol.getQualifiedName().getNameWithParent();
        String typeName = symbol.getType().getName();
        buffer.append(symbolName).append(" : ").append(typeName);
        return buffer.toString();
    }

    @NotNull
    static String getPresentableText(@NotNull OCDeclaratorSymbol symbol, @NotNull PsiElement element, boolean showQualifiedNames) {
        String typeName;
        StringBuilder buffer = new StringBuilder();
        OCResolveContext context = OCResolveContext.forPsi(element);
        String symbolName = symbol.getQualifiedName().getFullName(context);
        buffer.append(OCElementNameUtil.convertNameByOptions(showQualifiedNames, symbolName));
        if (symbol.getKind() != OCSymbolKind.ENUM_CONST && !Objects.equals(typeName = symbol.getType().getName(context), symbolName)) {
            buffer.append(" : ");
            buffer.append(typeName);
        }
        return buffer.toString();
    }

    static boolean isMark(PsiElement element) {
        return element instanceof OCPragma || element instanceof PsiComment;
    }

    @NotNull
    static String convertNameByOptions(boolean showQualifiedNames, @NotNull String fullQName) {
        if (showQualifiedNames) {
            return fullQName;
        }
        int pos = fullQName.lastIndexOf(QSEP);
        if (pos < 0) {
            return fullQName;
        }
        return fullQName.substring(pos + QSEP.length());
    }

    @NotNull
    public static String stripLastID(@NotNull String fullQNameWithID) {
        int pos = fullQNameWithID.lastIndexOf(QSEP);
        if (pos < 0) {
            return fullQNameWithID;
        }
        return fullQNameWithID.substring(0, pos + QSEP.length());
    }
}

