/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.struct;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.TypeHierarchyBrowserBase;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.hierarchy.OCClassHierarchyNodeDescriptor;
import com.jetbrains.cidr.lang.hierarchy.struct.OCStructSubTypesHierarchyTreeStructure;
import com.jetbrains.cidr.lang.hierarchy.struct.OCStructSuperTypesHierarchyTreeStructure;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import java.util.Comparator;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JTree;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class OCStructTypeHierarchyBrowser
extends TypeHierarchyBrowserBase {
    private static final Logger LOG = Logger.getInstance(OCStructTypeHierarchyBrowser.class);

    public OCStructTypeHierarchyBrowser(Project project, OCStruct struct) {
        super(project, (PsiElement)struct);
    }

    protected boolean isInterface(@NotNull PsiElement psiElement) {
        return true;
    }

    protected void createTrees(@NotNull Map<? super @Nls String, ? super JTree> trees) {
        this.createTreeAndSetupCommonActions(trees, "TypeHierarchyPopupMenu");
    }

    protected JPanel createLegendPanel() {
        return null;
    }

    protected PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor) {
        if (!(descriptor instanceof OCClassHierarchyNodeDescriptor)) {
            return null;
        }
        return ((OCClassHierarchyNodeDescriptor)descriptor).getType();
    }

    protected boolean isApplicableElement(@NotNull PsiElement element) {
        return element instanceof OCStruct;
    }

    protected Comparator<NodeDescriptor<?>> getComparator() {
        return AlphaComparator.INSTANCE;
    }

    protected HierarchyTreeStructure createHierarchyTreeStructure(@NotNull String typeName, @NotNull PsiElement element) {
        if (element instanceof OCStruct) {
            if (OCStructTypeHierarchyBrowser.getSupertypesHierarchyType().equals(typeName)) {
                return new OCStructSuperTypesHierarchyTreeStructure(this.myProject, (OCStruct)element);
            }
            if (OCStructTypeHierarchyBrowser.getSubtypesHierarchyType().equals(typeName)) {
                return new OCStructSubTypesHierarchyTreeStructure(this.myProject, (OCStruct)element);
            }
        }
        LOG.error("unexpected type: " + typeName);
        return null;
    }

    protected boolean canBeDeleted(PsiElement psiElement) {
        return false;
    }

    protected String getQualifiedName(PsiElement psiElement) {
        Object symbol;
        if (psiElement instanceof OCSymbolDeclarator && (symbol = ((OCSymbolDeclarator)psiElement).getSymbol()) instanceof OCSymbolWithQualifiedName) {
            OCQualifiedName resolvedQualifiedName = ((OCSymbolWithQualifiedName)symbol).getResolvedQualifiedName(OCResolveContext.forPsi(psiElement));
            if (resolvedQualifiedName != null) {
                return resolvedQualifiedName.toString();
            }
            return ((OCSymbolWithQualifiedName)symbol).getQualifiedName().toString();
        }
        return "";
    }
}

