/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.polyglot;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.hierarchy.polyglot.PolyglotHierarchyNodeDescriptor;
import com.jetbrains.cidr.lang.hierarchy.polyglot.PolyglotTypeStructureProvider;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PolyglotTypeStructure
extends LanguageExtension<PolyglotTypeStructureProvider> {
    private static final PolyglotTypeStructure INSTANCE = new PolyglotTypeStructure();

    public PolyglotTypeStructure() {
        super("cidr.lang.typeStructureProvider");
    }

    @NotNull
    public static String getQualifiedName(@Nullable PsiElement element) {
        if (element == null) {
            return "";
        }
        return PolyglotTypeStructure.getNotNullProvider(element).getQualifiedName(element);
    }

    @Nullable
    private static PolyglotTypeStructureProvider getProvider(@NotNull PsiElement element) {
        Language language = element.getLanguage();
        return (PolyglotTypeStructureProvider)INSTANCE.forLanguage(language);
    }

    @NotNull
    private static PolyglotTypeStructureProvider getNotNullProvider(@NotNull PsiElement element) {
        PolyglotTypeStructureProvider provider2 = PolyglotTypeStructure.getProvider(element);
        if (provider2 == null) {
            throw new AssertionError((Object)("Missing type structure provider for " + element + ", language: " + element.getLanguage()));
        }
        return provider2;
    }

    @Nullable
    public static PolyglotHierarchyNodeDescriptor createNodeDescriptor(@NotNull PsiElement element, @Nullable PolyglotHierarchyNodeDescriptor parent, boolean isBase) {
        return PolyglotTypeStructure.getNotNullProvider(element).createNodeDescriptor(element, parent, isBase);
    }

    @NotNull
    public static List<? extends PsiElement> getInheritors(@NotNull PsiElement declaration) {
        return PolyglotTypeStructure.getNotNullProvider(declaration).getInheritors(declaration);
    }

    @NotNull
    public static List<? extends PsiElement> getSuperTypes(@NotNull PsiElement declaration) {
        return PolyglotTypeStructure.getNotNullProvider(declaration).getSuperTypes(declaration);
    }

    @Nullable
    public static PsiElement getSuperClass(@NotNull PsiElement cur) {
        return PolyglotTypeStructure.getNotNullProvider(cur).getSuperClass(cur);
    }

    public static boolean isTypeHierarchyAvailable(@NotNull PsiElement element) {
        PolyglotTypeStructureProvider provider2 = PolyglotTypeStructure.getProvider(element);
        return provider2 != null && provider2.isTypeHierarchyAvailable(element);
    }

    @Nullable
    public static String getHierarchyType(@NotNull PsiElement base) {
        return PolyglotTypeStructure.getNotNullProvider(base).getHierarchyType(base);
    }

    public static boolean isInterface(@NotNull PsiElement psiElement) {
        return PolyglotTypeStructure.getNotNullProvider(psiElement).isInterface(psiElement);
    }
}

