/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.include;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.hierarchy.OCClassHierarchyNodeDescriptor;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCImportSuperHierarchyTreeStructure
extends HierarchyTreeStructure {
    private static final HierarchyNodeDescriptor[] EMPTY_DESCRIPTORS = new HierarchyNodeDescriptor[0];
    private static final boolean DISPLAY_LOCATION = !ApplicationManager.getApplication().isUnitTestMode();

    public OCImportSuperHierarchyTreeStructure(@NotNull Project project, @NotNull OCFile file) {
        super(project, OCImportSuperHierarchyTreeStructure.createDescriptor(project, null, file, true, DISPLAY_LOCATION));
    }

    protected Object @NotNull [] buildChildren(@NotNull HierarchyNodeDescriptor nodeDescriptor) {
        OCClassHierarchyNodeDescriptor descriptor = (OCClassHierarchyNodeDescriptor)nodeDescriptor;
        OCFile file = (OCFile)descriptor.getType();
        FileSymbolTablesCache.getInstance(this.myProject).ensurePendingFilesProcessed();
        if (file == null) {
            return EMPTY_DESCRIPTORS;
        }
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            return EMPTY_DESCRIPTORS;
        }
        OCImportGraph importGraph = OCImportGraph.getInstance(this.myProject);
        Collection<VirtualFile> includingFiles = importGraph.findImmediateIncludingFiles(vFile, false);
        List answer = PsiUtilCore.toPsiFiles((PsiManager)PsiManager.getInstance((Project)this.myProject), includingFiles);
        return OCImportSuperHierarchyTreeStructure.convertToDescriptors(this.myProject, descriptor, answer, DISPLAY_LOCATION);
    }

    public static HierarchyNodeDescriptor @NotNull [] convertToDescriptors(@NotNull Project project, @Nullable OCClassHierarchyNodeDescriptor<OCFile> parent, @NotNull Collection<PsiFile> files, boolean displayLocation) {
        HierarchyNodeDescriptor[] descriptors = new HierarchyNodeDescriptor[files.size()];
        int i = 0;
        for (PsiFile superFile : files) {
            OCFile ocFile = OCLanguageUtils.asOCFile(superFile);
            OCLog.LOG.assertTrue(ocFile != null, (Object)superFile);
            descriptors[i] = OCImportSuperHierarchyTreeStructure.createDescriptor(project, parent, ocFile, false, displayLocation);
            ++i;
        }
        return descriptors;
    }

    @NotNull
    public static HierarchyNodeDescriptor createDescriptor(@NotNull Project project, @Nullable OCClassHierarchyNodeDescriptor<OCFile> parent, @NotNull OCFile superFile, boolean isBase, boolean displayLocation) {
        return new OCClassHierarchyNodeDescriptor<OCFile>(project, parent, superFile, isBase, displayLocation);
    }
}

