/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCGenerateBundle;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.generate.OCMemberChooser;
import com.jetbrains.cidr.lang.generate.OCMemberChooserObject;
import com.jetbrains.cidr.lang.generate.actions.OCActionContext;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCClassActionHandlerBase<P extends OCMembersContainer, M extends OCSymbolWithParent, C extends OCActionContext<P, M>>
implements LanguageCodeInsightActionHandler {
    public boolean isValidFor(Editor editor, PsiFile file) {
        Project project = file.getProject();
        if (DumbService.isDumb((Project)project)) {
            return false;
        }
        C context = this.evaluateActionContext(project, editor, file);
        return context != null && ((OCActionContext)context).isValid();
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        C context = this.evaluateActionContext(project, editor, file);
        if (this.checkContext(project, editor, context)) {
            this.invoke(project, editor, file, context);
        }
    }

    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file, @NotNull C context) {
        HashMap<OCOption, Object> defaultCheckboxStates = new HashMap<OCOption, Object>();
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, OCCodeStyleSettings.class);
        ArrayList<Pair<OCOption, Object>> options = new ArrayList<Pair<OCOption, Object>>();
        this.loadOptions(file, editor, context, settings, options);
        for (Pair<OCOption, Object> pair : options) {
            defaultCheckboxStates.put((OCOption)pair.getFirst(), pair.getSecond());
        }
        ((OCActionContext)context).setOptionValues(defaultCheckboxStates);
        for (OCSymbol symbol : ((OCActionContext)context).getSymbolsToModify()) {
            if (symbol == null || OCSearchScope.isInProjectSources(symbol, project)) continue;
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.message((String)"error.out.of.project.element", (Object[])new Object[]{symbol.getNameWithKindLowercase(OCCompilationContext.create((PsiElement)file))}), (String)this.getActionTitle(), null);
            return;
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite((Collection)ContainerUtil.mapNotNull(((OCActionContext)context).getSymbolsToModify(), p -> p != null ? p.getContainingOCFile(project) : null))) {
            return;
        }
        M oneCandidate = this.locateCandidate(project, editor, file);
        List candidates = oneCandidate == null ? new ArrayList(((OCActionContext)context).getMemberCandidates()) : Collections.singletonList(oneCandidate);
        candidates = this.filterCandidates(candidates, this.getCandidatesFilter(context));
        candidates = this.sortCandidates(candidates, project);
        if (oneCandidate == null && !this.allowEmptySelection(context) && candidates.isEmpty()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)this.getNoMembersMessage(context), (String)this.getActionTitle(), null);
            return;
        }
        HashSet selectedCandidates = new HashSet(this.getSelectedCandidates(context, editor, file, candidates));
        selectedCandidates.retainAll(candidates);
        List chosenCandidates = this.chooseCandidates(file, editor, candidates, selectedCandidates, context, settings);
        if (chosenCandidates != null && (this.allowEmptySelection(context) || !chosenCandidates.isEmpty())) {
            this.performAction(project, editor, file, context, chosenCandidates);
        }
    }

    @Contract(value="_, _, null -> false")
    protected boolean checkContext(@NotNull Project project, @Nullable Editor editor, @Nullable C context) {
        if (context == null || !((OCActionContext)context).isValid()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)OCGenerateBundle.message("class.action.handler.invalid.for.selection", new Object[0]), (String)this.getActionTitle(), null);
            return false;
        }
        return true;
    }

    protected abstract void performAction(@NotNull Project var1, @Nullable Editor var2, @NotNull PsiFile var3, @NotNull C var4, @NotNull List<M> var5);

    @Nullable
    protected P getParent(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            return (P)((OCMembersContainer)((Object)((OCFile)file).getSameNamedClass()));
        }
        PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
        OCSymbolDeclarator parent = (OCSymbolDeclarator)PsiTreeUtil.getContextOfType((PsiElement)at, (Class[])new Class[]{this.getParentClass()});
        return (P)(parent != null ? (OCMembersContainer)parent.getSymbol() : null);
    }

    protected boolean enableChooseDialog(Collection<M> candidates) {
        return true;
    }

    protected void loadOptions(PsiFile file, @Nullable Editor editor, @NotNull C actionContext, @Nullable OCCodeStyleSettings settings, @NotNull List<Pair<OCOption, Object>> options) {
    }

    protected static <T, Comp extends JComponent> T getOption(Map<OCOption, Object> optionSelections, OCOption<T, Comp> option) {
        return (T)optionSelections.get(option);
    }

    protected <T, Comp extends JComponent> T getOption(C context, OCOption<T, Comp> option) {
        return OCClassActionHandlerBase.getOption(((OCActionContext)context).getOptionValues(), option);
    }

    protected void saveOptions(PsiFile file, @NotNull OCCodeStyleSettings settings, Map<OCOption, Object> optionValues) {
    }

    @Nullable
    protected C evaluateActionContext(Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        P parent = this.getParent(project, editor, file);
        return parent != null && OCSearchScope.isInProjectSources((PsiElement)parent.getContainingPsiFile(project)) ? (C)this.evaluateActionContext(parent, OCGenerateUtil.getElementAt(editor, file)) : null;
    }

    @Nullable
    protected abstract C evaluateActionContext(P var1, @NotNull PsiElement var2);

    protected boolean allowEmptySelection(C context) {
        return false;
    }

    protected boolean allowMultiSelection(C context) {
        return true;
    }

    @Nullable
    @NlsActions.ActionText
    public String getActionName() {
        return null;
    }

    @Nullable
    @NlsActions.ActionDescription
    public String getActionDescription() {
        return null;
    }

    @NotNull
    @NlsContexts.Command
    protected abstract String getActionTitle();

    @NlsContexts.DialogTitle
    protected abstract String getMembersChooserTitle();

    protected abstract Class<? extends OCSymbolDeclarator> getParentClass();

    @NlsContexts.DialogMessage
    protected String getNoMembersMessage(@NotNull C context) {
        String parentName = ((OCActionContext)context).getParentNameUppercase();
        String actionTitle = StringUtil.decapitalize((String)this.getActionTitle());
        return OCGenerateBundle.message("class.action.handler.no.members.message", parentName, actionTitle);
    }

    @NotNull
    protected Condition<M> getCandidatesFilter(@NotNull C actionContext) {
        return Conditions.alwaysTrue();
    }

    @Nullable
    protected M locateCandidate(@NotNull Project project, Editor editor, PsiFile file) {
        return null;
    }

    @NotNull
    protected Collection<M> getSelectedCandidates(@NotNull C actionContext, @Nullable Editor editor, @NotNull PsiFile file, @NotNull List<M> candidates) {
        OCSymbol symbol;
        if (editor == null) {
            return Collections.emptyList();
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        Project project = ((OCActionContext)actionContext).getProject();
        if (selectionModel.hasSelection()) {
            TextRange selectionRange = new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
            return ContainerUtil.filter(candidates, m -> {
                PsiElement element = m.locateDefinition(project);
                OCSymbol associatedSymbol = m.getAssociatedSymbol(project);
                PsiElement associatedElement = associatedSymbol != null ? associatedSymbol.locateDefinition(project) : null;
                return element != null && selectionRange.contains(element.getTextRange()) || associatedElement != null && selectionRange.contains(associatedElement.getTextRange());
            });
        }
        PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
        OCSymbolDeclarator declarator = (OCSymbolDeclarator)PsiTreeUtil.getParentOfType((PsiElement)at, OCSymbolDeclarator.class);
        if (declarator instanceof OCMethodSelectorPart) {
            declarator = (OCMethod)declarator.getParent();
        }
        OCSymbol oCSymbol = symbol = declarator != null ? (OCSymbol)declarator.getSymbol() : null;
        if (symbol != null) {
            if (candidates.contains(symbol)) {
                return Collections.singletonList((OCSymbolWithParent)symbol);
            }
            if ((symbol = symbol.getAssociatedSymbol(project)) != null && candidates.contains(symbol)) {
                return Collections.singletonList((OCSymbolWithParent)symbol);
            }
        }
        return Collections.emptyList();
    }

    @NotNull
    private List<M> filterCandidates(@NotNull List<? extends M> candidates, @NotNull Condition<? super M> filter) {
        ArrayList<OCSymbolWithParent> result = new ArrayList<OCSymbolWithParent>(candidates.size());
        HashSet<OCSymbolWithParent> set = new HashSet<OCSymbolWithParent>();
        for (OCSymbolWithParent elem : candidates) {
            if (set.contains(elem) || !filter.value((Object)elem)) continue;
            result.add(elem);
            set.add(elem);
        }
        return result;
    }

    @NotNull
    private List<M> sortCandidates(@NotNull List<? extends M> candidates, @NotNull Project project) {
        ArrayList<M> result = new ArrayList<M>(candidates);
        HashMap<OCSymbolWithParent, Integer> originalOrder = new HashMap<OCSymbolWithParent, Integer>();
        for (int i = 0; i < candidates.size(); ++i) {
            originalOrder.put((OCSymbolWithParent)candidates.get(i), i);
        }
        result.sort((symbol1, symbol2) -> {
            if (symbol1.getParent() != symbol2.getParent()) {
                return (Integer)originalOrder.get(symbol1) - (Integer)originalOrder.get(symbol2);
            }
            if (symbol1 instanceof OCInstanceVariableSymbol && symbol1.isSynthetic()) {
                symbol1 = ((OCInstanceVariableSymbol)symbol1).getAssociatedProperty(project);
            }
            if (symbol2 instanceof OCInstanceVariableSymbol && symbol2.isSynthetic()) {
                symbol2 = ((OCInstanceVariableSymbol)symbol2).getAssociatedProperty(project);
            }
            if (symbol1 == null || symbol2 == null) {
                return 0;
            }
            int result1 = symbol1.getOffset() - symbol2.getOffset();
            if (result1 == 0 && symbol1 instanceof OCMethodSymbol && symbol2 instanceof OCMethodSymbol) {
                OCResolveContext context = OCResolveContext.forSymbol(symbol1, project);
                return (((OCMethodSymbol)symbol1).isSetter(context) ? 1 : 0) - (((OCMethodSymbol)symbol2).isSetter(context) ? 1 : 0);
            }
            return result1;
        });
        return result;
    }

    @Nullable
    private List<M> chooseCandidates(PsiFile file, @Nullable Editor editor, final @NotNull List<M> candidates, Set<M> selectedCandidates, @NotNull C actionContext, OCCodeStyleSettings settings) {
        Project project = file.getProject();
        if (!this.enableChooseDialog(candidates) || candidates.isEmpty() && this.allowEmptySelection(actionContext)) {
            ArrayList<M> list = new ArrayList<M>(candidates);
            if (!selectedCandidates.isEmpty()) {
                list.retainAll(selectedCandidates);
            }
            return this.sortCandidates(list, project);
        }
        if (selectedCandidates.isEmpty() && ApplicationManager.getApplication().isUnitTestMode()) {
            selectedCandidates = new HashSet<M>(candidates);
        }
        ArrayList<Pair<OCOption, Object>> options = new ArrayList<Pair<OCOption, Object>>();
        this.loadOptions(file, editor, actionContext, settings, options);
        final OCMemberChooser chooser = this.createMemberChooser(project, options, actionContext, candidates);
        chooser.setTitle(this.getMembersChooserTitle());
        ClassMember[] nodes = this.getChooserNodes(chooser, candidates, actionContext, 0);
        for (int i = 0; nodes.length == 0 && i < options.size(); ++i) {
            nodes = this.getChooserNodes(chooser, candidates, actionContext, i + 1);
        }
        chooser.resetElements(nodes);
        ArrayList<ClassMember> selectedList = new ArrayList<ClassMember>(selectedCandidates.size());
        for (ClassMember node : nodes) {
            if (!selectedCandidates.contains(node.getSymbol())) continue;
            selectedList.add(node);
        }
        chooser.selectElements(selectedList.toArray(new OCMemberChooserObject[0]));
        JComponent[] optionControls = chooser.getOptionControls();
        for (int i = 0; i < optionControls.length; ++i) {
            final OCOption option = (OCOption)((Pair)options.get(i)).getFirst();
            option.addItemListener(optionControls[i], new ItemListener((OCActionContext)actionContext){
                final /* synthetic */ OCActionContext val$actionContext;
                {
                    this.val$actionContext = oCActionContext;
                }

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    OCClassActionHandlerBase.this.optionValueChanged(chooser, candidates, option, this.val$actionContext);
                }
            });
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            chooser.show();
            if (chooser.getExitCode() != 0) {
                return null;
            }
        } else {
            Disposer.dispose((Disposable)chooser.getDisposable());
        }
        ArrayList<OCSymbolWithParent> selectedMembers = new ArrayList<OCSymbolWithParent>();
        List<OCMemberChooserObject> selection = chooser.getChosenElements();
        if (selection != null) {
            for (OCMemberChooserObject object : selection) {
                selectedMembers.add((OCSymbolWithParent)object.getSymbol());
            }
        } else if (!this.allowEmptySelection(actionContext)) {
            return null;
        }
        Map<OCOption, Object> checkboxSelections = chooser.getOptionSelections();
        if (settings != null) {
            this.saveOptions(file, settings, checkboxSelections);
        }
        ((OCActionContext)actionContext).setOptionValues(checkboxSelections);
        return selectedMembers;
    }

    protected OCMemberChooser createMemberChooser(Project project, List<Pair<OCOption, Object>> options, C actionContext, List<M> candidates) {
        return new OCMemberChooser(new OCMemberChooserObject[0], this.allowEmptySelection(actionContext), this.allowMultiSelection(actionContext), options, null, project){

            @Nullable
            protected String getHelpId() {
                return OCClassActionHandlerBase.this.getHelpID();
            }
        };
    }

    protected OCMemberChooserObject[] getChooserNodes(OCMemberChooser chooser, Collection<M> candidates, C actionContext, int moreNodesLevel) {
        Map<OCSymbol, OCSymbol> parentsMap = ((OCActionContext)actionContext).createParentsMap(candidates);
        return (OCMemberChooserObject[])ContainerUtil.map2Array(candidates, OCMemberChooserObject.class, m -> new OCMemberChooserObject((OCSymbol)m, parentsMap, actionContext.getProject()));
    }

    protected void optionValueChanged(OCMemberChooser chooser, Collection<M> candidates, OCOption option, C actionContext) {
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    @NonNls
    protected String getHelpID() {
        return null;
    }
}

