/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.generate.FunctionQualifiedNameInfo;
import com.jetbrains.cidr.lang.generate.OCCppGeneratedQualifiedFunctionKt;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCRequiresClause;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterTypeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000^\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u001e\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0016\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006\u001a\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001c\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\u0005\u001a\u00020\u0006H\u0003\u001a\"\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0005\u001a\u00020\u001bH\u0002\u001a\"\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0005\u001a\u00020\u001bH\u0002\u001a\u0018\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\"\u0010\u001e\u001a\u00020\u00142\u0010\u0010 \u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u001a\u0018\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u001f2\u0006\u0010\u0005\u001a\u00020\u001bH\u0002\u001a.\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\u0010\u001a\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0005\u001a\u00020\u001bH\u0002\u001a\u001e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001bH\u0002\u00a8\u0006%"}, d2={"fromQualifiers", "Lcom/jetbrains/cidr/lang/generate/FunctionQualifiedNameInfo;", "quals", "", "Lcom/jetbrains/cidr/lang/symbols/cpp/OCSymbolWithQualifiedName;", "context", "Lcom/intellij/psi/PsiElement;", "getQualifiedNameAndTemplateHeader", "function", "Lcom/jetbrains/cidr/lang/symbols/cpp/OCFunctionSymbol;", "psiContext", "getRequiresClause", "Lcom/jetbrains/cidr/lang/psi/OCRequiresClause;", "structSym", "Lcom/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol;", "project", "Lcom/intellij/openapi/project/Project;", "getScopeSymbol", "Lcom/jetbrains/cidr/lang/symbols/cpp/OCNamespaceSymbol;", "getTemplateVar", "", "s", "Lcom/jetbrains/cidr/lang/symbols/OCTypeParameterSymbol;", "isFriendFunctionInProperNamespace", "", "symbol", "scope", "Lcom/jetbrains/cidr/lang/symbols/OCResolveContext;", "isResolved", "target", "makeTemplateHeader", "Lcom/jetbrains/cidr/lang/symbols/cpp/OCTemplateSymbol;", "symbols", "makeTemplateParameters", "t", "reduceQualifiers", "toParts", "intellij.c"})
public final class OCCppGeneratedQualifiedFunctionKt {
    @NotNull
    public static final FunctionQualifiedNameInfo getQualifiedNameAndTemplateHeader(@NotNull OCFunctionSymbol function, @NotNull PsiElement psiContext) {
        OCResolveContext context = OCResolveContext.forPsi(psiContext);
        List<OCSymbolWithQualifiedName> result = OCCppGeneratedQualifiedFunctionKt.reduceQualifiers(OCCppGeneratedQualifiedFunctionKt.toParts(function, context), OCCppGeneratedQualifiedFunctionKt.getScopeSymbol(psiContext), context);
        return OCCppGeneratedQualifiedFunctionKt.fromQualifiers(result, psiContext);
    }

    private static final List<OCSymbolWithQualifiedName> toParts(OCSymbolWithQualifiedName symbol, OCResolveContext context) {
        List res = new ArrayList();
        for (OCSymbolWithQualifiedName cur = symbol; cur != null; cur = cur.getResolvedOwner(context, false)) {
            res.add(cur);
        }
        return CollectionsKt.reversed((Iterable)res);
    }

    private static final OCNamespaceSymbol getScopeSymbol(PsiElement context) {
        PsiElement scopePSI = PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{OCStruct.class, OCCppNamespace.class, OCFile.class});
        PsiElement psiElement = scopePSI;
        return psiElement instanceof OCSymbolDeclarator ? (OCNamespaceSymbol)((OCSymbolDeclarator)scopePSI).getSymbol() : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<OCSymbolWithQualifiedName> reduceQualifiers(List<? extends OCSymbolWithQualifiedName> target, OCNamespaceSymbol scope, OCResolveContext context) {
        int n = target.size() - 1;
        boolean bl = false;
        while (n >= 0) {
            void i;
            if (OCCppGeneratedQualifiedFunctionKt.isResolved(target.get((int)i), scope, context) || OCCppGeneratedQualifiedFunctionKt.isFriendFunctionInProperNamespace(target.get((int)i), scope, context)) {
                return target.subList((int)i, target.size());
            }
            --i;
        }
        return target;
    }

    private static final boolean isFriendFunctionInProperNamespace(OCSymbolWithQualifiedName symbol, OCNamespaceSymbol scope, OCResolveContext context) {
        if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isFriend()) {
            if (scope == null) {
                return ((OCFunctionSymbol)symbol).getQualifierParent() == null;
            }
            return scope.isSameSymbol(((OCFunctionSymbol)symbol).getQualifierParent(), context);
        }
        return false;
    }

    private static final boolean isResolved(OCSymbolWithQualifiedName target, OCNamespaceSymbol scope, OCResolveContext context) {
        OCNamespaceSymbol oCNamespaceSymbol = scope;
        List<OCSymbol> symbols = OCSymbolReference.getGlobalReference(OCQualifiedName.with(target.getName()), scope, (VirtualFile)(oCNamespaceSymbol != null ? oCNamespaceSymbol.getContainingFile() : null), -1L).resolveToSymbols(context);
        Collection collection = symbols;
        return !collection.isEmpty() && target.isSameSymbol((OCSymbol)CollectionsKt.first(symbols), context.getProject());
    }

    private static final FunctionQualifiedNameInfo fromQualifiers(List<? extends OCSymbolWithQualifiedName> quals, PsiElement context) {
        StringBuilder qualifiedName = new StringBuilder();
        StringBuilder templateHeader = new StringBuilder();
        for (OCSymbolWithQualifiedName oCSymbolWithQualifiedName : quals) {
            boolean functionItself = oCSymbolWithQualifiedName instanceof OCFunctionSymbol;
            qualifiedName.append(oCSymbolWithQualifiedName.getName());
            if (oCSymbolWithQualifiedName instanceof OCTemplateSymbol) {
                qualifiedName.append(OCCppGeneratedQualifiedFunctionKt.makeTemplateParameters((OCTemplateSymbol)((Object)oCSymbolWithQualifiedName), OCResolveContext.forPsi(context)));
                templateHeader.append(OCCppGeneratedQualifiedFunctionKt.makeTemplateHeader((OCTemplateSymbol)((Object)oCSymbolWithQualifiedName), context));
                if (oCSymbolWithQualifiedName instanceof OCStructSymbol && OCCppGeneratedQualifiedFunctionKt.getRequiresClause((OCStructSymbol)oCSymbolWithQualifiedName, context.getProject()) != null) {
                    OCRequiresClause oCRequiresClause;
                    OCRequiresClause it = oCRequiresClause;
                    boolean bl = false;
                    templateHeader.append(it.getText());
                }
            }
            if (functionItself) continue;
            qualifiedName.append("::");
        }
        return new FunctionQualifiedNameInfo(qualifiedName.toString(), templateHeader.toString());
    }

    private static final String makeTemplateParameters(OCTemplateSymbol t, OCResolveContext context) {
        List<OCTypeArgument> spec = t.getTemplateSpecialization();
        List<OCTypeParameterSymbol> params = t.getTemplateParameters();
        if (spec != null) {
            return "<" + CollectionsKt.joinToString$default((Iterable)spec, (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<OCTypeArgument, CharSequence>(context){
                final /* synthetic */ OCResolveContext $context;

                @NotNull
                public final CharSequence invoke(OCTypeArgument it) {
                    return it.getNameForPresentation(OCType.Presentation.BEST, this.$context, false, 0);
                }
                {
                    this.$context = oCResolveContext;
                    super(1);
                }
            }), (int)30, null) + ">";
        }
        if (!params.isEmpty() && !(t instanceof OCFunctionSymbol)) {
            return "<" + CollectionsKt.joinToString$default((Iterable)params, (CharSequence)", ", null, null, (int)0, null, (Function1)makeTemplateParameters.2.INSTANCE, (int)30, null) + ">";
        }
        return "";
    }

    private static final String makeTemplateHeader(OCTemplateSymbol s, PsiElement context) {
        return s.isTemplateSymbol() && (!(s instanceof OCStructSymbol) || !((OCStructSymbol)s).getTemplateParameters().isEmpty()) ? OCCppGeneratedQualifiedFunctionKt.makeTemplateHeader(s.getTemplateParameters(), context) + "\n" : "";
    }

    /*
     * WARNING - void declaration
     */
    @NlsSafe
    @NotNull
    public static final String makeTemplateHeader(@NotNull List<? extends OCTypeParameterSymbol<?>> symbols, @NotNull PsiElement context) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = symbols;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            OCTypeParameterSymbol oCTypeParameterSymbol = (OCTypeParameterSymbol)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = OCCppGeneratedQualifiedFunctionKt.getTemplateVar(it, context);
            collection.add(string);
        }
        return "template<" + CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ">";
    }

    @NlsSafe
    private static final String getTemplateVar(OCTypeParameterSymbol<?> s, PsiElement context) {
        Object object;
        OCResolveContext resolveContext = OCResolveContext.forPsi(context);
        OCTypeParameterSymbol<?> oCTypeParameterSymbol = s;
        if (oCTypeParameterSymbol instanceof OCTypeParameterTypeSymbol) {
            String string;
            if (((OCTypeParameterTypeSymbol)s).isConstrained()) {
                OCQualifiedName oCQualifiedName = ((OCTypeParameterTypeSymbol)s).getConstraintName();
                Intrinsics.checkNotNull((Object)oCQualifiedName);
                string = oCQualifiedName.getFullName(resolveContext);
            } else {
                string = ((OCTypeParameterTypeSymbol)s).isSpelledWithTypenameKeyword() ? "typename" : "class";
            }
            object = string + (((OCTypeParameterTypeSymbol)s).isVariadic() ? "..." : "") + (String)(Intrinsics.areEqual((Object)((OCTypeParameterTypeSymbol)s).getName(), (Object)"<unnamed>") || Intrinsics.areEqual((Object)((OCTypeParameterTypeSymbol)s).getName(), (Object)"") ? "" : " " + ((OCTypeParameterTypeSymbol)s).getName());
        } else if (oCTypeParameterSymbol instanceof OCTypeParameterValueSymbol) {
            object = OCElementFactory.declarationText(((OCTypeParameterValueSymbol)s).getName(), ((OCTypeParameterValueSymbol)s).getType(), null, null, context);
        } else {
            OCLog.LOG.error("Template parameter is not a type nor value");
            object = "UNKNOWN";
        }
        return object;
    }

    private static final OCRequiresClause getRequiresClause(OCStructSymbol structSym, Project project) {
        PsiElement psiElement = structSym.locateDefinition(project);
        if (!(psiElement instanceof OCStruct)) {
            psiElement = null;
        }
        OCStruct oCStruct = (OCStruct)psiElement;
        if (oCStruct == null) {
            return null;
        }
        OCStruct structDef = oCStruct;
        return structDef.getRequiresClause();
    }
}

