/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.ExternalFormatProcessor;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.formatting.CidrProjectWizardFilesFormatter;
import com.jetbrains.cidr.lang.parser.OCParser;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class OCProjectWizardFilesFormatter
extends CidrProjectWizardFilesFormatter {
    private static final Logger LOG = Logger.getInstance(OCProjectWizardFilesFormatter.class);

    public void reformatProjectFiles(@NotNull Project project, VirtualFile ... files) {
        boolean[] externalFormatConfigIsCreated = new boolean[]{false};
        Arrays.asList(files).forEach(vf -> {
            ExternalFormatProcessor efp;
            PsiFile psiFile;
            if (!externalFormatConfigIsCreated[0] && (psiFile = PsiManager.getInstance((Project)project).findFile(vf)) != null && ExternalFormatProcessor.useExternalFormatter((PsiFile)psiFile) && (efp = ExternalFormatProcessor.activeExternalFormatProcessor((PsiFile)psiFile)) != null) {
                efp.createConfiguration(psiFile.getProject());
                externalFormatConfigIsCreated[0] = true;
            }
            OCProjectWizardFilesFormatter.reformatFile(project, vf);
        });
    }

    static void reformatFile(@NotNull Project project, @NotNull VirtualFile fileToFormat) {
        PsiFile file = PsiManager.getInstance((Project)project).findFile(fileToFormat);
        FileDocumentManager manager = FileDocumentManager.getInstance();
        Document document = manager.getDocument(fileToFormat);
        LOG.assertTrue(document != null);
        String oldText = document.getText();
        OCCodeFragment fragment = OCElementFactory.codeFragment(oldText, project, (PsiElement)file, OCTokenTypes.OC_FILE, false, false, (OCLanguageKind)CLanguageKind.CPP);
        OCParser.setSimplifiedParsingMode(fragment, true);
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)fragment);
        String newText = fragment.getText();
        document.setText((CharSequence)newText);
        manager.saveDocument(document);
    }

    @TestOnly
    public static void reformatFileFromTest(@NotNull Project project, @NotNull VirtualFile fileToFormat) {
        OCProjectWizardFilesFormatter.reformatFile(project, fileToFormat);
    }
}

