/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.surround;

import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.jetbrains.cidr.lang.editor.surround.OCCondCompilationSurrounder;
import com.jetbrains.cidr.lang.editor.surround.OCStructureUnawareBraceSurrounder;
import org.jetbrains.annotations.NotNull;

public class OCPrepSurroundDescriptor
implements SurroundDescriptor {
    private static final Surrounder[] SURROUNDERS = new Surrounder[]{new OCCondCompilationSurrounder(), new OCStructureUnawareBraceSurrounder()};

    public Surrounder @NotNull [] getSurrounders() {
        return SURROUNDERS;
    }

    public boolean isExclusive() {
        return false;
    }

    public PsiElement @NotNull [] getElementsToSurround(PsiFile file, int startOffset, int endOffset) {
        PsiElement element1 = file.findElementAt(startOffset);
        PsiElement element2 = file.findElementAt(endOffset - 1);
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
            element1 = file.findElementAt(startOffset);
        }
        if (element2 instanceof PsiWhiteSpace) {
            endOffset = element2.getTextRange().getStartOffset();
            element2 = file.findElementAt(endOffset - 1);
        }
        if (element1 == null || element2 == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        return new PsiElement[]{element1, element2};
    }
}

