/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.ide.DataManager;
import com.intellij.lang.ASTNode;
import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.editor.smartEnter.OCFixer;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBlockOwner;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCaseStatement;
import com.jetbrains.cidr.lang.psi.OCDoWhileStatement;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStatementWithExpression;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import java.awt.Component;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlainEnterProcessor
extends SmartEnterProcessorWithFixers.FixEnterProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doEnter(@NotNull PsiElement atCaret, @NotNull PsiFile file, @NotNull Editor editor, boolean modified) {
        boolean braceOnEnter = CodeInsightSettings.getInstance().INSERT_BRACE_ON_ENTER;
        try {
            CodeInsightSettings.getInstance().INSERT_BRACE_ON_ENTER = false;
            if (PlainEnterProcessor.expandCodeBlock(editor, atCaret)) {
                boolean bl = true;
                return bl;
            }
            PlainEnterProcessor.getEnterHandler("EditorStartNewLine").execute(editor, editor.getCaretModel().getCurrentCaret(), EditorUtil.getEditorDataContext((Editor)editor));
            boolean bl = true;
            return bl;
        }
        finally {
            CodeInsightSettings.getInstance().INSERT_BRACE_ON_ENTER = braceOnEnter;
        }
    }

    public static boolean expandCodeBlock(Editor editor, PsiElement psiElement) {
        OCBlockOwner block;
        int offset = editor.getCaretModel().getOffset();
        boolean needSmartNewLine = PlainEnterProcessor.needSmartNewLine(psiElement);
        if (needSmartNewLine) {
            block = null;
            if ((psiElement = PlainEnterProcessor.adjustNewLinePosition(psiElement)) == null) {
                return false;
            }
        } else {
            block = PlainEnterProcessor.getControlStatementBlock(offset, psiElement);
        }
        PsiElement lbrace = null;
        boolean hasGoodLBrace = false;
        if (block != null) {
            TextRange range;
            lbrace = block.getOpeningBrace();
            hasGoodLBrace = OCFixer.isRealLeafElement(lbrace);
            boolean canExpandBlockBeforeCursor = block.getParent() instanceof OCDoWhileStatement;
            TextRange textRange = range = hasGoodLBrace ? OCChangeUtil.getRangeWithMacros(lbrace) : null;
            if (hasGoodLBrace && (offset <= range.getEndOffset() || canExpandBlockBeforeCursor)) {
                editor.getCaretModel().moveToOffset(range.getEndOffset());
            } else {
                Document document = editor.getDocument();
                int cursorLine = document.getLineNumber(offset);
                int endLineNumber = document.getLineNumber(OCChangeUtil.getRangeWithMacros(block).getEndOffset());
                if (!canExpandBlockBeforeCursor && cursorLine >= endLineNumber) {
                    return false;
                }
            }
        }
        if (!needSmartNewLine && PsiTreeUtil.hasErrorElements((PsiElement)(block != null ? block : psiElement))) {
            return lbrace == null;
        }
        if (PlainEnterProcessor.processExistingBlankLine(editor, block, psiElement)) {
            return true;
        }
        if (block == null) {
            return false;
        }
        if (!hasGoodLBrace || !OCFixer.isRealLeafElement(block.getClosingBrace())) {
            return true;
        }
        EditorActionHandler enterHandler = PlainEnterProcessor.getEnterHandler("EditorStartNewLine");
        PsiElement firstElement = OCFixer.getFirstBodyElement(block);
        if (firstElement == null) {
            enterHandler = PlainEnterProcessor.getEnterHandler("EditorEnter");
        } else {
            editor.getCaretModel().moveToOffset(OCChangeUtil.getRangeWithMacros(firstElement).getStartOffset());
            if (!(firstElement instanceof PsiWhiteSpace) || !firstElement.textContains('\n')) {
                enterHandler = PlainEnterProcessor.getEnterHandler("EditorEnter");
            }
        }
        enterHandler.execute(editor, editor.getCaretModel().getCurrentCaret(), EditorUtil.getEditorDataContext((Editor)editor));
        return true;
    }

    @Nullable
    private static PsiElement adjustNewLinePosition(@NotNull PsiElement psiElement) {
        if (psiElement instanceof OCCaseStatement) {
            ASTNode colon = psiElement.getNode().findChildByType((IElementType)OCTokenTypes.COLON);
            if (colon != null) {
                psiElement = colon.getPsi();
                PsiErrorElement error = OCFixer.getNextError(psiElement);
                if (error != null) {
                    psiElement = error;
                }
            } else {
                return null;
            }
        }
        return psiElement;
    }

    @Contract(value="null -> false", pure=true)
    private static boolean needSmartNewLine(PsiElement psiElement) {
        return psiElement instanceof OCCaseStatement;
    }

    private static EditorActionHandler getEnterHandler(String actionId) {
        return EditorActionManager.getInstance().getActionHandler(actionId);
    }

    @Nullable
    private static OCBlockOwner getControlStatementBlock(int caret, PsiElement element) {
        if (OCFixer.isCompleteBlockOwner(element)) {
            return (OCBlockOwner)element;
        }
        OCStatement body = null;
        if (element instanceof OCIfStatement && ((OCIfStatement)element).getRParenth() != null) {
            body = ((OCIfStatement)element).getThenBranch();
            if (body != null && caret > OCChangeUtil.getRangeWithMacros(body).getEndOffset()) {
                body = ((OCIfStatement)element).getElseBranch();
            }
        } else if (element instanceof OCStatementWithExpression && ((OCStatementWithExpression)element).getRParenth() != null) {
            body = ((OCStatementWithExpression)element).getBody();
        } else if (element instanceof OCCallable) {
            body = ((OCCallable)element).getBody();
        }
        return body instanceof OCBlockOwner ? (OCBlockOwner)((Object)body) : null;
    }

    private static boolean processExistingBlankLine(@NotNull Editor editor, @Nullable PsiElement codeBlock, @Nullable PsiElement element) {
        PsiWhiteSpace whiteSpace = null;
        if (codeBlock == null) {
            PsiElement next;
            if (element != null && (next = PsiTreeUtil.nextLeaf((PsiElement)element)) instanceof PsiWhiteSpace) {
                whiteSpace = (PsiWhiteSpace)next;
            }
        } else {
            whiteSpace = (PsiWhiteSpace)PsiTreeUtil.findChildOfType((PsiElement)codeBlock, PsiWhiteSpace.class);
            if (whiteSpace == null) {
                return false;
            }
            PsiElement lbraceCandidate = whiteSpace.getPrevSibling();
            if (lbraceCandidate == null) {
                return false;
            }
            ASTNode node = lbraceCandidate.getNode();
            if (node == null || node.getElementType() != OCTokenTypes.LBRACE) {
                return false;
            }
        }
        if (whiteSpace == null) {
            return false;
        }
        TextRange textRange = whiteSpace.getTextRange();
        Document document = editor.getDocument();
        CharSequence whiteSpaceText = document.getCharsSequence().subSequence(textRange.getStartOffset(), textRange.getEndOffset());
        if (StringUtil.countNewLines((CharSequence)whiteSpaceText) < 2) {
            return false;
        }
        int i = CharArrayUtil.shiftForward((CharSequence)whiteSpaceText, (int)0, (String)" \t");
        if (i >= whiteSpaceText.length() - 1) {
            assert (false) : String.format("code block: %s, white space: %s", codeBlock == null ? "undefined" : codeBlock.getTextRange(), whiteSpace.getTextRange());
            return false;
        }
        editor.getCaretModel().moveToOffset(i + 1 + textRange.getStartOffset());
        EditorActionManager actionManager = EditorActionManager.getInstance();
        EditorActionHandler actionHandler = actionManager.getActionHandler("EditorLineEnd");
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor.getComponent());
        if (dataContext == null) {
            if ((i = CharArrayUtil.shiftForwardUntil((CharSequence)whiteSpaceText, (int)i, (String)"\n")) >= whiteSpaceText.length()) {
                i = whiteSpaceText.length();
            }
            editor.getCaretModel().moveToOffset(i + textRange.getStartOffset());
        } else {
            actionHandler.execute(editor, editor.getCaretModel().getCurrentCaret(), dataContext);
        }
        return true;
    }
}

