/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.smartEnter.OCFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.OCSmartEnterProcessor;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingIfBranchesFixer
extends OCFixer {
    public void apply(@NotNull Editor editor, @NotNull OCSmartEnterProcessor processor, @NotNull PsiElement psiElement) throws IncorrectOperationException {
        OCStatement thenBranch;
        if (!(psiElement instanceof OCIfStatement)) {
            return;
        }
        OCIfStatement ifStatement = (OCIfStatement)psiElement;
        Document doc = editor.getDocument();
        ASTNode elseKeyword = ifStatement.getElseKeyword();
        if (elseKeyword != null) {
            MissingIfBranchesFixer.handleBranch(doc, ifStatement, true, elseKeyword.getPsi(), ifStatement.getElseBranch());
        }
        if (MissingIfBranchesFixer.fixBlockIfNeed(editor, thenBranch = ifStatement.getThenBranch(), false)) {
            return;
        }
        if (thenBranch != null && MissingIfBranchesFixer.startLine(doc, thenBranch) == MissingIfBranchesFixer.startLine(doc, ifStatement) && !MissingIfBranchesFixer.hasEmptyStatement(ifStatement.getCondition())) {
            return;
        }
        ASTNode rParenth = ifStatement.getRParenth();
        if (rParenth == null) {
            return;
        }
        MissingIfBranchesFixer.handleBranch(doc, ifStatement, false, rParenth.getPsi(), ifStatement.getThenBranch());
    }

    private static void handleBranch(@NotNull Document doc, @NotNull OCIfStatement ifStatement, boolean isElse, @NotNull PsiElement beforeBranch, @Nullable OCStatement branch) {
        if (branch instanceof OCBlockStatement || isElse && branch instanceof OCIfStatement) {
            return;
        }
        boolean transformingOneLiner = branch != null && (MissingIfBranchesFixer.startLine(doc, beforeBranch) == MissingIfBranchesFixer.startLine(doc, branch) || MissingIfBranchesFixer.indent(doc, ifStatement) < MissingIfBranchesFixer.indent(doc, branch));
        int endOffset = OCChangeUtil.getRangeWithMacros(beforeBranch).getEndOffset();
        if (!transformingOneLiner) {
            doc.insertString(endOffset, (CharSequence)"{}");
        } else {
            doc.insertString(endOffset, (CharSequence)"{");
            doc.insertString(OCChangeUtil.getRangeWithMacros(branch).getEndOffset() + 1, (CharSequence)"}");
        }
    }

    private static int indent(Document doc, @NotNull PsiElement psiElement) {
        int offset = OCChangeUtil.getRangeWithMacros(psiElement).getStartOffset();
        return offset - doc.getLineStartOffset(doc.getLineNumber(offset));
    }
}

