/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.smartEnter.OCFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.OCSmartEnterProcessor;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import org.jetbrains.annotations.NotNull;

public class MissingCallableBodyFixer
extends OCFixer {
    public void apply(@NotNull Editor editor, @NotNull OCSmartEnterProcessor processor, @NotNull PsiElement psiElement) throws IncorrectOperationException {
        OCClassDeclaration containingClass;
        if (!(psiElement instanceof OCFunctionDefinition) && !(psiElement instanceof OCMethod)) {
            return;
        }
        if (psiElement instanceof OCMethod && ((containingClass = ((OCMethod)psiElement).getContainingClass()) instanceof OCInterface || containingClass instanceof OCProtocol)) {
            return;
        }
        OCCallable fun = (OCCallable)psiElement;
        OCBlockStatement body = fun.getBody();
        Document doc = editor.getDocument();
        if (body != null) {
            MissingCallableBodyFixer.fixBlockIfNeed(editor, body, false);
            return;
        }
        int endOffset = OCChangeUtil.getRangeWithMacros(fun).getEndOffset();
        if (StringUtil.endsWithChar((CharSequence)fun.getText(), (char)';')) {
            doc.deleteString(endOffset - 1, endOffset);
            --endOffset;
        }
        doc.insertString(endOffset, (CharSequence)"{\n}");
    }
}

