/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.smartEnter.OCFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.OCSmartEnterProcessor;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import org.jetbrains.annotations.NotNull;

public class IfConditionFixer
extends OCFixer {
    public void apply(@NotNull Editor editor, @NotNull OCSmartEnterProcessor processor, @NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement instanceof OCIfStatement) {
            if (IfConditionFixer.hasMacroBasedStatement(psiElement, OCTokenTypes.IF_KEYWORD)) {
                return;
            }
            Document doc = editor.getDocument();
            OCIfStatement ifStatement = (OCIfStatement)psiElement;
            ASTNode rParenth = ifStatement.getRParenth();
            ASTNode lParenth = ifStatement.getLParenth();
            OCCondition condition = ifStatement.getCondition();
            if (lParenth == null) {
                int stopOffset = doc.getLineEndOffset(doc.getLineNumber(OCChangeUtil.getRangeWithMacros(ifStatement).getStartOffset()));
                OCStatement then = ifStatement.getThenBranch();
                if (then != null) {
                    stopOffset = Math.min(stopOffset, OCChangeUtil.getRangeWithMacros(then).getStartOffset());
                }
                stopOffset = Math.min(stopOffset, OCChangeUtil.getRangeWithMacros(ifStatement).getEndOffset());
                doc.replaceString(OCChangeUtil.getRangeWithMacros(ifStatement).getStartOffset(), stopOffset, (CharSequence)"if ()");
                processor.registerUnresolvedError(OCChangeUtil.getRangeWithMacros(ifStatement).getStartOffset() + "if (".length());
            } else {
                IfConditionFixer.fixConditionIfNeed(editor, processor, lParenth, condition, rParenth);
            }
        }
    }
}

