/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.smartEnter.OCFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.OCSmartEnterProcessor;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDoWhileStatement;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStatementWithExpression;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import org.jetbrains.annotations.NotNull;

public class DefaultStatementWithExpressionFixer
extends OCFixer {
    public void apply(@NotNull Editor editor, @NotNull OCSmartEnterProcessor processor, @NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (!(!(psiElement instanceof OCStatementWithExpression) || psiElement instanceof OCDoWhileStatement || psiElement instanceof OCForStatement || psiElement instanceof OCForeachStatement || DefaultStatementWithExpressionFixer.hasMacroBasedStatement(psiElement, ((OCStatementWithExpression)psiElement).getKeywordType()))) {
            Document doc = editor.getDocument();
            OCStatementWithExpression conditionalStatement = (OCStatementWithExpression)psiElement;
            ASTNode rParenth = conditionalStatement.getRParenth();
            ASTNode lParenth = conditionalStatement.getLParenth();
            PsiElement condition = conditionalStatement.getExpression();
            if (lParenth == null) {
                ASTNode dogNode;
                int stopOffset = doc.getLineEndOffset(doc.getLineNumber(OCChangeUtil.getRangeWithMacros(conditionalStatement).getStartOffset()));
                OCStatement block = conditionalStatement.getBody();
                if (block != null) {
                    stopOffset = Math.min(stopOffset, OCChangeUtil.getRangeWithMacros(block).getStartOffset());
                }
                stopOffset = Math.min(stopOffset, OCChangeUtil.getRangeWithMacros(conditionalStatement).getEndOffset());
                Object prefix = "";
                if (OCTokenTypes.KEYWORDS_WITH_AT.contains((IElementType)conditionalStatement.getKeywordType()) && (dogNode = psiElement.getNode().findChildByType((IElementType)OCElementTypes.OBJC_KEYWORD)) != null) {
                    prefix = "@";
                }
                prefix = (String)prefix + conditionalStatement.getKeywordType().getName() + " (";
                doc.replaceString(OCChangeUtil.getRangeWithMacros(conditionalStatement).getStartOffset(), stopOffset, (CharSequence)((String)prefix + ")"));
                processor.registerUnresolvedError(OCChangeUtil.getRangeWithMacros(conditionalStatement).getStartOffset() + ((String)prefix).length());
            } else {
                DefaultStatementWithExpressionFixer.fixConditionIfNeed(editor, processor, lParenth, condition, rParenth);
            }
        }
    }
}

