/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.smartEnter.OCFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.OCSmartEnterProcessor;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCaseStatement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaseColonFixer
extends OCFixer {
    public void apply(@NotNull Editor editor, @NotNull OCSmartEnterProcessor processor, @NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement instanceof OCCaseStatement) {
            TextRange range;
            int caretOffset = editor.getCaretModel().getOffset();
            Document document = editor.getDocument();
            if (document.getLineNumber((range = OCChangeUtil.getRangeWithMacros(psiElement)).getStartOffset()) == document.getLineNumber(caretOffset) || range.contains(caretOffset)) {
                OCExpression beforeColon = ((OCCaseStatement)psiElement).getExpression();
                if (beforeColon == null && OCElementUtil.getElementType(beforeColon = psiElement.getFirstChild()) != OCTokenTypes.DEFAULT_KEYWORD) {
                    beforeColon = null;
                }
                if (beforeColon != null) {
                    int offset;
                    ASTNode colon = CaseColonFixer.findFirstColonInCase(psiElement);
                    if (colon != null) {
                        offset = CaseColonFixer.getRangeWithMacros(colon).getEndOffset();
                    } else {
                        offset = OCChangeUtil.getRangeWithMacros(beforeColon).getEndOffset();
                        document.insertString(offset, (CharSequence)":");
                        ++offset;
                    }
                    editor.getCaretModel().moveToOffset(offset);
                }
            }
        }
    }

    @Nullable
    public static ASTNode findFirstColonInCase(@NotNull PsiElement psiElement) {
        return psiElement.getNode().findChildByType((IElementType)OCTokenTypes.COLON);
    }
}

