/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.liveTemplates;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.editor.completion.OCCodeContextType;
import com.jetbrains.cidr.lang.editor.liveTemplates.OCTemplatesUtil;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.refactoring.OCNamingConventionUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSuggestIndexNameMacro
extends Macro {
    @NlsSafe
    private static final String MACRO_NAME = "suggestIndexName";

    public String getName() {
        return MACRO_NAME;
    }

    @NotNull
    public String getDefaultValue() {
        return "i";
    }

    /*
     * WARNING - void declaration
     */
    public Result calculateResult(Expression @NotNull [] params, ExpressionContext context) {
        PsiElement place = OCTemplatesUtil.getInsertionPlace(context);
        PsiFile file = place.getContainingFile();
        assert (file != null);
        Collection<String> candidates = OCNamingConventionUtil.applyNamingConvention(ContainerUtil.newArrayList((Object[])new String[]{"i", "j", "k", "l", "m", "n"}), OCSymbolKind.LOCAL_VARIABLE, context.getProject());
        int attempt = 0;
        while (true) {
            for (String string : candidates) {
                void var8_8;
                if (attempt > 0) {
                    String string2 = string + attempt;
                }
                if (!OCSuggestIndexNameMacro.isNameAvailable((String)var8_8, file, place)) continue;
                return new TextResult((String)var8_8);
            }
            ++attempt;
        }
    }

    private static boolean isNameAvailable(@NotNull String candidate, @NotNull PsiFile file, @Nullable PsiElement context) {
        Project project = file.getProject();
        OCSymbol symbol = OCCodeInsightUtil.resolveNameInScope(OCSymbolKind.LOCAL_VARIABLE, candidate, null, context, project);
        if (symbol == null) {
            return true;
        }
        if (context == null) {
            return false;
        }
        PsiElement parent = context.getParent();
        return parent instanceof OCDeclarator && parent.equals(symbol.locateDefinition(project));
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof OCCodeContextType;
    }
}

